/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.suf2;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.EOFException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import nl.b3p.geotools.data.suf2.SUF2GeometryFactory;
import nl.b3p.suf2.SUF2ParseException;
import nl.b3p.suf2.SUF2RecordCollector;
import nl.b3p.suf2.records.SUF2Record;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SUF2FeatureReader
implements FeatureReader {
    private static final Log log = LogFactory.getLog(SUF2FeatureReader.class);
    private GeometryFactory gf;
    private SimpleFeatureType ft;
    private Map<String, String[]> metadata = new HashMap<String, String[]>();
    private int featureID = 0;
    private SUF2RecordCollector recordCollector;
    private SimpleFeature feature;
    private SortedMap info = new TreeMap();

    public SUF2FeatureReader(URL url, String typeName, String srs) throws IOException, SUF2ParseException {
        this.gf = new GeometryFactory(new PrecisionModel(100.0));
        this.recordCollector = new SUF2RecordCollector(url);
        this.createFeatureType(typeName, srs);
    }

    private void createFeatureType(String typeName, String srs) throws DataSourceException {
        CoordinateReferenceSystem crs = null;
        String[] csMetadata = this.metadata.get("coordinatesystem");
        if (csMetadata != null) {
            String wkt = csMetadata[0];
            try {
                CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
                crs = crsFactory.createFromWKT(wkt);
            }
            catch (Exception e) {
                throw new DataSourceException("Error parsing CoordinateSystem WKT: \"" + wkt + "\"");
            }
        }
        if (srs != null) {
            try {
                crs = CRS.decode((String)srs);
            }
            catch (Exception e) {
                throw new DataSourceException("Error parsing CoordinateSystem srs: \"" + srs + "\"");
            }
        }
        try {
            SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
            ftb.setName(typeName);
            ftb.setCRS(crs);
            ftb.add("the_geom", Geometry.class);
            ftb.add("type", String.class);
            ftb.add("recordtype", String.class);
            ftb.add("LKI_classificatiecode", String.class);
            ftb.add("angle", Double.class);
            ftb.add("bestandsidentificatie", String.class);
            ftb.add("volledig/mutatie", String.class);
            ftb.add("datum laatste herziening", String.class);
            ftb.add("actualiteitsdatum", String.class);
            ftb.add("aantal deelbestanden uitwisseling", String.class);
            ftb.add("huidig deelbestandsnummer", String.class);
            ftb.add("bestandsnaam", String.class);
            ftb.add("R.D.-coordinatenstelsel", String.class);
            ftb.add("aanduiding keuze voor LKI-classificatie", String.class);
            ftb.add("registratie coordinaten in millimeters", String.class);
            ftb.add("registratie richtingen in microgen", String.class);
            ftb.add("LKI-symbool-codes", String.class);
            ftb.add("hoogte in NAP", String.class);
            ftb.add("geen optelconstante in X-coordinaat", String.class);
            ftb.add("geen optelconstante in Y-coordinaat", String.class);
            ftb.add("geen optelconstante in Z-coordinaat", String.class);
            ftb.add("vermeningsvuldigingsconstante x, y", String.class);
            ftb.add("vermeningsvuldigingsconstante z", String.class);
            ftb.add("gemeentecode_perceel_links", String.class);
            ftb.add("sectie_perceel_links", String.class);
            ftb.add("indexletter_perceel_links", String.class);
            ftb.add("perceelnummer_perceel_links", String.class);
            ftb.add("indexnummer_perceel_links", String.class);
            ftb.add("gemeentecode_perceel_rechts", String.class);
            ftb.add("sectie_perceel_rechts", String.class);
            ftb.add("indexletter_perceel_rechts", String.class);
            ftb.add("perceelnummer_perceel_rechts", String.class);
            ftb.add("indexnummer_perceel_rechts", String.class);
            ftb.add("stringsoort van het grafisch element", String.class);
            ftb.add("zichtbaarheid van object ivm tekeninstructies", String.class);
            ftb.add("wijze van inwinning", String.class);
            ftb.add("status van het object", String.class);
            ftb.add("opnamedatum van het grafisch element", String.class);
            ftb.add("bronvermelding bij het object", String.class);
            ftb.add("wijze van verzekering bij grondslag", String.class);
            ftb.add("functie van het coordinaatpunt", String.class);
            ftb.add("precisieklasse", String.class);
            ftb.add("idealisatieklasse", String.class);
            ftb.add("betrouwbaarheid", String.class);
            ftb.add("text align", String.class);
            ftb.add("status perceel", String.class);
            ftb.add("is tekst", String.class);
            ftb.add("symbooltype", String.class);
            ftb.add("tekst veldlengte", String.class);
            ftb.add("tekst", String.class);
            ftb.add("gemeentecode", String.class);
            ftb.add("sectie", String.class);
            ftb.add("perceelnummer", String.class);
            ftb.add("indexletter", String.class);
            ftb.add("indexnummer", String.class);
            ftb.add("suf_id", Integer.class);
            this.ft = ftb.buildFeatureType();
        }
        catch (Exception e) {
            log.error((Object)"Error creating SimpleFeature", (Throwable)e);
            throw new DataSourceException("Error creating SimpleFeatureType", (Throwable)e);
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.ft;
    }

    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        return this.feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() throws IOException {
        block13: {
            try {
                if (!this.recordCollector.hasNext()) {
                    return false;
                }
                while (true) {
                    SUF2Record record;
                    if ((record = this.recordCollector.next()).hasGeometry()) {
                        boolean error = false;
                        try {
                            this.feature = this.createFeature(record);
                            continue;
                        }
                        catch (Exception ex) {
                            log.debug((Object)("Exception in record " + record.getLineNumber() + "; " + ex.getLocalizedMessage()));
                            error = true;
                            return error;
                        }
                        finally {
                            if (error) continue;
                            break block13;
                        }
                    }
                    try {
                        this.info.putAll(record.getProperties());
                    }
                    catch (SUF2ParseException ex) {
                        throw new IOException(ex.getMessage());
                    }
                    if (!this.recordCollector.hasNext()) break;
                }
                return false;
            }
            catch (EOFException ex) {
                return false;
            }
            catch (Exception ex) {
                log.error((Object)ex);
                throw new IOException(ex);
            }
        }
        return true;
    }

    private SimpleFeature createFeature(SUF2Record record) throws Exception {
        Map properties = record.getProperties();
        Object[] values = new Object[]{SUF2GeometryFactory.createGeometry(this.gf, record), record.getType().getDescription(), (String)properties.get("recordtype"), (String)properties.get("LKI_classificatiecode"), properties.containsKey("angle") ? (Double)properties.get("angle") : new Double(0.0), (String)properties.get("bestandsidentificatie"), (String)properties.get("volledig/mutatie"), (String)properties.get("datum laatste herziening"), (String)properties.get("actualiteitsdatum"), (String)properties.get("aantal deelbestanden uitwisseling"), (String)properties.get("huidig deelbestandsnummer"), (String)properties.get("bestandsnaam"), (String)properties.get("R.D.-coordinatenstelsel"), (String)properties.get("aanduiding keuze voor LKI-classificatie"), (String)properties.get("registratie coordinaten in millimeters"), (String)properties.get("registratie richtingen in microgen"), (String)properties.get("LKI-symbool-codes"), (String)properties.get("hoogte in NAP"), (String)properties.get("geen optelconstante in X-coordinaat"), (String)properties.get("geen optelconstante in Y-coordinaat"), (String)properties.get("geen optelconstante in Z-coordinaat"), (String)properties.get("vermeningsvuldigingsconstante x, y"), (String)properties.get("vermeningsvuldigingsconstante z"), (String)properties.get("gemeentecode_perceel_links"), (String)properties.get("sectie_perceel_links"), (String)properties.get("indexletter_perceel_links"), (String)properties.get("perceelnummer_perceel_links"), (String)properties.get("indexnummer_perceel_links"), (String)properties.get("gemeentecode_perceel_rechts"), (String)properties.get("sectie_perceel_rechts"), (String)properties.get("indexletter_perceel_rechts"), (String)properties.get("perceelnummer_perceel_rechts"), (String)properties.get("indexnummer_perceel_rechts"), (String)properties.get("stringsoort van het grafisch element"), (String)properties.get("zichtbaarheid van object ivm tekeninstructies"), (String)properties.get("wijze van inwinning"), (String)properties.get("status van het object"), (String)properties.get("opnamedatum van het grafisch element"), (String)properties.get("bronvermelding bij het object"), (String)properties.get("wijze van verzekering bij grondslag"), (String)properties.get("functie van het coordinaatpunt"), (String)properties.get("precisieklasse"), (String)properties.get("idealisatieklasse"), (String)properties.get("betrouwbaarheid"), (String)properties.get("text align"), (String)properties.get("status perceel"), (String)properties.get("is tekst"), (String)properties.get("symbooltype"), (String)properties.get("tekst veldlengte"), (String)properties.get("tekst"), (String)properties.get("gemeentecode"), (String)properties.get("sectie"), (String)properties.get("perceelnummer"), (String)properties.get("indexletter"), (String)properties.get("indexnummer"), record.getLineNumber()};
        return SimpleFeatureBuilder.build((SimpleFeatureType)this.ft, (Object[])values, (String)Integer.toString(this.featureID++));
    }

    public void close() throws IOException {
        this.recordCollector.close();
    }
}

