/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.suf2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.b3p.suf2.SUF2Coordinate;
import nl.b3p.suf2.SUF2Math;
import nl.b3p.suf2.records.SUF2Record;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class SUF2GeometryFactory {
    private static final Log log = LogFactory.getLog(SUF2GeometryFactory.class);
    public static final double NUM_SEGMENTS = 32.0;

    public static Geometry createGeometry(GeometryFactory gf, SUF2Record record) throws Exception {
        List coordinatePoints = record.getCoordinates();
        if (record.getType() == SUF2Record.Type.ARC) {
            return SUF2GeometryFactory.createArc(gf, record);
        }
        Coordinate[] coordinates = new Coordinate[coordinatePoints.size()];
        for (int i = 0; i < coordinatePoints.size(); ++i) {
            SUF2Coordinate coordinate = (SUF2Coordinate)coordinatePoints.get(i);
            coordinates[i] = new Coordinate(coordinate.x, coordinate.y);
        }
        if ((record.getType().equals((Object)SUF2Record.Type.TEXT) || record.getType().equals((Object)SUF2Record.Type.SYMBOL)) && record.getProperties().containsKey("is tekst")) {
            return SUF2GeometryFactory.createTextPoint(gf, record);
        }
        if (coordinates.length == 2 && record.getProperties().containsKey("is tekst") && record.getProperties().get("is tekst").toString().equals("1")) {
            return SUF2GeometryFactory.createTextPoint(gf, record);
        }
        if (coordinates.length <= 0) {
            throw new IOException("No coordinates found");
        }
        if (coordinates.length == 1) {
            return gf.createPoint(coordinates[0]);
        }
        if (SUF2GeometryFactory.isPolygon(record, coordinatePoints)) {
            CoordinateArraySequence coordinateSequence = new CoordinateArraySequence(coordinates);
            LinearRing linearRing = new LinearRing((CoordinateSequence)coordinateSequence, gf);
            return gf.createPolygon(linearRing, new LinearRing[0]);
        }
        return gf.createLineString(coordinates);
    }

    private static boolean isPolygon(SUF2Record record, List<SUF2Coordinate> coordinatePoints) {
        return record.getType() == SUF2Record.Type.POLYGON;
    }

    public static Geometry createArc(GeometryFactory gf, SUF2Record record) throws Exception {
        List coordinates = record.getCoordinates();
        return SUF2GeometryFactory.createArc(gf, coordinates);
    }

    public static Geometry createArc(GeometryFactory gf, List<SUF2Coordinate> coordinates) throws Exception {
        SUF2Coordinate pc;
        SUF2Coordinate p1 = coordinates.get(0);
        SUF2Coordinate p2 = coordinates.get(1);
        SUF2Coordinate p3 = coordinates.get(2);
        try {
            pc = SUF2GeometryFactory.circle(coordinates);
        }
        catch (Exception ex) {
            log.debug((Object)(ex.getLocalizedMessage() + "; converted arc to line"));
            return gf.createLineString(new Coordinate[]{new Coordinate(p1.x, p1.y), new Coordinate(p3.x, p3.y)});
        }
        double radius = Math.sqrt((p1.x - pc.x) * (p1.x - pc.x) + (p1.y - pc.y) * (p1.y - pc.y));
        double angle1 = Math.toRadians(SUF2Math.angle((SUF2Coordinate)pc, (SUF2Coordinate)p1));
        double angle2 = Math.toRadians(SUF2Math.angle((SUF2Coordinate)pc, (SUF2Coordinate)p2));
        double angle3 = Math.toRadians(SUF2Math.angle((SUF2Coordinate)pc, (SUF2Coordinate)p3));
        if (angle1 == angle3) {
            angle1 = 0.0;
            angle3 = Math.PI * 2;
        } else {
            if (angle2 == angle1 || angle2 == angle3) {
                log.debug((Object)"Record at line someline: Arc with middleCoordinate equal to startCoordinate or endCoordinate");
                Coordinate[] line = new Coordinate[]{new Coordinate(p1.x, p1.y), new Coordinate(p3.x, p3.y)};
                return gf.createLineString(line);
            }
            if (angle2 > angle1 && angle2 > angle3 || angle2 < angle1 && angle2 < angle3) {
                if (angle1 < angle3) {
                    angle1 += Math.PI * 2;
                } else {
                    angle3 += Math.PI * 2;
                }
            }
        }
        return gf.createLineString(SUF2GeometryFactory.toCoordinateArray(pc, radius, angle1, angle3, gf));
    }

    private static Geometry createTextPoint(GeometryFactory gf, SUF2Record record) throws Exception {
        Map properties = record.getProperties();
        List coordinates = record.getCoordinates();
        if (coordinates.size() == 2) {
            properties.put("angle", SUF2Math.angle((SUF2Coordinate)((SUF2Coordinate)coordinates.get(0)), (SUF2Coordinate)((SUF2Coordinate)coordinates.get(1))));
        } else {
            properties.put("angle", new Double(0.0));
        }
        if (properties.get("is tekst").toString().equals("2")) {
            if (properties.get("symbooltype").equals("")) {
                properties.put("tekst", properties.get("LKI_classificatiecode"));
            } else {
                properties.put("tekst", properties.get("symbooltype"));
            }
        } else if (properties.containsKey("perceelnummer")) {
            properties.put("tekst", properties.get("perceelnummer"));
        } else {
            properties.put("tekst", properties.get("LKI_classificatiecode"));
        }
        SUF2Coordinate coordinate = SUF2Math.middle((List)coordinates);
        return gf.createPoint(new Coordinate(coordinate.x, coordinate.y));
    }

    private static SUF2Coordinate circle(List<SUF2Coordinate> coordinates) throws Exception {
        double a23;
        double b23;
        double a12;
        double b12;
        SUF2Coordinate c1 = coordinates.get(0);
        SUF2Coordinate c2 = coordinates.get(1);
        SUF2Coordinate c3 = coordinates.get(2);
        double x1 = c1.x;
        double x2 = c2.x;
        double x3 = c3.x;
        double y1 = c1.y;
        double y2 = c2.y;
        double y3 = c3.y;
        SUF2Coordinate p12 = SUF2Math.middle((SUF2Coordinate)c1, (SUF2Coordinate)c2);
        SUF2Coordinate p23 = SUF2Math.middle((SUF2Coordinate)c2, (SUF2Coordinate)c3);
        if (y2 == y1) {
            b12 = p12.y;
            a12 = 0.0;
        } else {
            b12 = p12.y + (x2 - x1) / (y2 - y1) * p12.x;
            a12 = (x2 - x1) / (y2 - y1);
        }
        if (y3 == y2) {
            b23 = p23.y;
            a23 = 0.0;
        } else {
            b23 = p23.y + (x3 - x2) / (y3 - y2) * p23.x;
            a23 = (x3 - x2) / (y3 - y2);
        }
        if (a12 == a23) {
            throw new Exception("Devide by zero, unable to create arc");
        }
        double x = (b23 - b12) / (a12 - a23);
        double y = a12 * x + b12;
        return new SUF2Coordinate(-x, y);
    }

    public static Coordinate[] toCoordinateArray(SUF2Coordinate point, double radius, double startAngle, double endAngle, GeometryFactory gf) throws Exception {
        if (point == null) {
            throw new Exception("toCoordinateArray(...) point == null");
        }
        if (radius <= 0.0) {
            throw new Exception("toCoordinateArray(...) radius is equal or below zero (radius=" + radius + ")");
        }
        boolean ccw = startAngle < endAngle;
        ArrayList<Coordinate> lc = new ArrayList<Coordinate>();
        double segAngle = 0.19634954084936207;
        double angle = startAngle;
        while (true) {
            double x = point.x + radius * Math.cos(angle);
            double y = point.y + radius * Math.sin(angle);
            lc.add(new Coordinate(x, y));
            if (ccw) {
                if (angle >= endAngle) break;
                if (!((angle += segAngle) > endAngle)) continue;
                angle = endAngle;
                continue;
            }
            if (angle <= endAngle) break;
            if (!((angle -= segAngle) < endAngle)) continue;
            angle = endAngle;
        }
        if (lc.size() <= 1) {
            throw new Exception("toCoordinateArray(...) returned " + lc.size() + " coordinates, value must be 2 or more");
        }
        return lc.toArray(new Coordinate[0]);
    }
}

