/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.openbareruimte.vragen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.b3p.viewer.openbareruimte.entities.RawCrow;
import nl.b3p.viewer.openbareruimte.vragen.CustomInput;
import nl.b3p.viewer.openbareruimte.vragen.MaatregelForm;
import nl.b3p.viewer.openbareruimte.vragen.Tekst;
import nl.b3p.viewer.openbareruimte.vragen.Vraag;
import nl.b3p.viewer.openbareruimte.vragen.VraagOptie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory {
    public static MaatregelForm createVragen(List<RawCrow> raw) {
        Collections.sort(raw);
        return Factory.createVragenSorted(raw);
    }

    public static MaatregelForm createVragenSorted(List<RawCrow> sortedRaw) {
        MaatregelForm f = new MaatregelForm();
        ArrayList<Vraag> vragen = new ArrayList<Vraag>();
        if (sortedRaw == null || sortedRaw.size() == 0) {
            return f;
        }
        String curCode = null;
        Vraag laatsteVraag = null;
        VraagOptie laatsteOptie = null;
        for (RawCrow raw : sortedRaw) {
            List<CustomInput> cis;
            if (raw.getDeficode() == null || raw.getDeficode().length() == 0) continue;
            Tekst t = new Tekst(raw.getTekst());
            t.setAanwijzing(raw.getAanwijzing());
            t.setType(raw.getType());
            if (raw.getDeficode().equals("0000")) {
                if (raw.getEenheid() != null && raw.getEenheid().length() > 0) {
                    f.setEenheid(raw.getEenheid());
                }
                if (raw.getVrij() != null && !raw.getVrij().equalsIgnoreCase("0000")) {
                    cis = Factory.createCustomInputs(raw.getVrij());
                    t.setCustomInputs(cis);
                }
                f.addTekst(t);
                continue;
            }
            if (curCode == null) {
                curCode = raw.getDeficode();
                laatsteVraag = new Vraag(new Integer("" + curCode.charAt(0)));
                laatsteOptie = new VraagOptie(curCode);
            }
            if (!curCode.equalsIgnoreCase(raw.getDeficode())) {
                laatsteVraag.add(laatsteOptie);
                laatsteOptie = new VraagOptie(raw.getDeficode());
            }
            if (raw.getVrij() != null && !raw.getVrij().equalsIgnoreCase("0000")) {
                cis = Factory.createCustomInputs(raw.getVrij());
                t.setCustomInputs(cis);
            }
            laatsteOptie.addTekst(t);
            if (curCode.charAt(0) != raw.getDeficode().charAt(0)) {
                vragen.add(laatsteVraag);
                laatsteVraag = new Vraag(new Integer("" + raw.getDeficode().charAt(0)));
            }
            if (raw.getEenheid() != null && raw.getEenheid().length() > 0) {
                laatsteOptie.setEenheid(raw.getEenheid());
            }
            curCode = raw.getDeficode();
        }
        f.setVragen(vragen);
        return f;
    }

    private static List<CustomInput> createCustomInputs(String vrij) {
        ArrayList<CustomInput> cis = new ArrayList<CustomInput>();
        while (vrij.length() > 0) {
            Integer startIndex = new Integer(vrij.substring(0, 2));
            Integer endIndex = new Integer(vrij.substring(2, 4));
            Integer n = startIndex;
            Integer n2 = startIndex = Integer.valueOf(startIndex - 1);
            CustomInput ci = new CustomInput(startIndex, endIndex - startIndex);
            vrij = vrij.substring(4);
            cis.add(ci);
        }
        return cis;
    }
}

