/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.suf2;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import nl.b3p.suf2.SUF2Coordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUF2Math {
    public static double angle(SUF2Coordinate c1, SUF2Coordinate c2) {
        double dx = c2.x - c1.x;
        double dy = c2.y - c1.y;
        double angle = dx == 0.0 ? (dy == 0.0 ? 0.0 : (dy > 0.0 ? 1.5707963267948966 : 4.71238898038469)) : (dy == 0.0 ? (dx > 0.0 ? 0.0 : Math.PI) : (dx < 0.0 ? Math.atan(dy / dx) + Math.PI : (dy < 0.0 ? Math.atan(dy / dx) + Math.PI * 2 : Math.atan(dy / dx))));
        return angle * 180.0 / Math.PI;
    }

    public static SUF2Coordinate middle(SUF2Coordinate c1, SUF2Coordinate c2) {
        ArrayList<SUF2Coordinate> coordinates = new ArrayList<SUF2Coordinate>();
        coordinates.add(c1);
        coordinates.add(c2);
        return SUF2Math.middle(coordinates);
    }

    public static SUF2Coordinate middle(List<SUF2Coordinate> coordinates) {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < coordinates.size(); ++i) {
            x += coordinates.get((int)i).x;
            y += coordinates.get((int)i).y;
        }
        return new SUF2Coordinate(x / (double)coordinates.size(), y / (double)coordinates.size());
    }

    public static double distance(SUF2Coordinate c1, SUF2Coordinate c2) {
        return Point2D.distance(c1.x, c1.y, c2.x, c2.y);
    }
}

