/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.suf2.records;

import java.io.IOException;
import java.io.LineNumberReader;
import nl.b3p.suf2.SUF2Map;
import nl.b3p.suf2.SUF2ParseException;
import nl.b3p.suf2.records.SUF2Record;

public class SUF2Record06
extends SUF2Record {
    public static final String VELDLENGTE = "tekst veldlengte";
    public static final String TEKST = "tekst";
    public static final String GEMEENTECODE = "gemeentecode";
    public static final String SECTIE = "sectie";
    public static final String PERCEELNUMMER = "perceelnummer";
    public static final String INDEXLETTER = "indexletter";
    public static final String INDEXNUMMER = "indexnummer";

    public SUF2Record06(LineNumberReader lineNumberReader, String line) throws SUF2ParseException, IOException {
        super(lineNumberReader, line);
    }

    public SUF2Record06(LineNumberReader lineNumberReader, String line, SUF2Map properties) throws SUF2ParseException, IOException {
        super(lineNumberReader, line, properties);
    }

    @Override
    public void parseProperties() throws SUF2ParseException {
        if (this.line.charAt(6).charValue() == 'T') {
            if (!this.properties.containsKey("LKI_classificatiecode")) {
                throw new SUF2ParseException(this.lineNumberReader, "LKI classificatiecode niet gevonden voor dit object");
            }
            if (this.line.part(19, 23).equals("G0000")) {
                this.properties.put(GEMEENTECODE, this.line.part(7, 11));
                this.properties.put(SECTIE, this.line.part(12, 13));
                this.properties.put(PERCEELNUMMER, this.line.part(14, 18));
                this.properties.put(INDEXLETTER, this.line.part(19));
                this.properties.put(INDEXNUMMER, this.line.part(20, 23));
                this.setType(SUF2Record.Type.PERCEEL);
            } else if (this.line.part(19, 23).equals("D0000")) {
                this.properties.put(GEMEENTECODE, this.line.part(7, 11));
                this.properties.put(SECTIE, this.line.part(12, 13));
                this.properties.put(PERCEELNUMMER, this.line.part(14, 18));
                this.properties.put(INDEXLETTER, this.line.part(19));
                this.properties.put(INDEXNUMMER, this.line.part(20, 23));
                this.setType(SUF2Record.Type.PERCEEL);
            } else if (this.properties.get("is tekst").equals("1")) {
                this.properties.put(TEKST, this.line.part(7, 46));
                this.properties.put(VELDLENGTE, this.line.part(4, 5));
                this.setType(SUF2Record.Type.TEXT);
            } else {
                this.setType(SUF2Record.Type.SYMBOL);
            }
        } else {
            throw new SUF2ParseException(this.lineNumberReader, "Line is a record06, but character 6 is not a 'T'");
        }
        this.hasGeometry = true;
    }
}

