/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.suf2;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Iterator;
import nl.b3p.suf2.SUF2ParseException;
import nl.b3p.suf2.SUF2RecordFactory;
import nl.b3p.suf2.records.SUF2Record;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SUF2RecordCollector
implements Iterator<SUF2Record> {
    private static final Log log = LogFactory.getLog(SUF2RecordCollector.class);
    private SUF2Record record;
    private LineNumberReader lineNumberReader;
    private CountingInputStream cis;

    public SUF2RecordCollector(URL url) throws IOException, SUF2ParseException {
        this.cis = new CountingInputStream(url.openStream());
        this.lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)this.cis));
    }

    @Override
    public SUF2Record next() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        try {
            this.record = SUF2RecordFactory.getNextRecord(this.lineNumberReader);
            return this.record != null;
        }
        catch (EOFException ex) {
            return false;
        }
        catch (Exception ex) {
            log.error((Object)"SUF2 parse error", (Throwable)ex);
            return this.hasNext();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() throws IOException {
        this.lineNumberReader.close();
    }

    public long getByteCount() {
        return this.cis.getByteCount();
    }

    public int getLineNumber() {
        return this.lineNumberReader.getLineNumber();
    }
}

