/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.suf2.records;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.suf2.SUF2Map;
import nl.b3p.suf2.SUF2ParseException;
import nl.b3p.suf2.SUF2ValueFinder;
import nl.b3p.suf2.records.SUF2Record;

public class SUF2Record03
extends SUF2Record {
    public static final String GEMEENTECODEPERCEELLINKS = "gemeentecode_perceel_links";
    public static final String SECTIEPERCEELLINKS = "sectie_perceel_links";
    public static final String INDEXLETTERPERCEELLINKS = "indexletter_perceel_links";
    public static final String PERCEELNUMMERLINKS = "perceelnummer_perceel_links";
    public static final String INDEXNUMMERLINKS = "indexnummer_perceel_links";
    public static final String GEMEENTECODEPERCEELRECHTS = "gemeentecode_perceel_rechts";
    public static final String SECTIEPERCEELRECHTS = "sectie_perceel_rechts";
    public static final String INDEXLETTERPERCEELRECHTS = "indexletter_perceel_rechts";
    public static final String PERCEELNUMMERRECHTS = "perceelnummer_perceel_rechts";
    public static final String INDEXNUMMERRECHTS = "indexnummer_perceel_rechts";
    public static final String G_STRINGSOORT = "stringsoort van het grafisch element";
    public static final String G_ZICHTBAARHEID = "zichtbaarheid van object ivm tekeninstructies";
    public static final String G_INWINNING = "wijze van inwinning";
    public static final String G_STATUS_VAN_OBJECT = "status van het object";
    public static final String D_OPNAMEDATUM = "opnamedatum van het grafisch element";
    public static final String B_BRONVERMELDING = "bronvermelding bij het object";
    public static final String B_WIJZE_VERZEKERING = "wijze van verzekering bij grondslag";

    public SUF2Record03(LineNumberReader lineNumberReader, String line) throws SUF2ParseException, IOException {
        super(lineNumberReader, line);
    }

    public SUF2Record03(LineNumberReader lineNumberReader, String line, SUF2Map properties) throws SUF2ParseException, IOException {
        super(lineNumberReader, line, properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parseProperties() throws SUF2ParseException {
        this.line.setShift(2);
        while (this.line.getShift() < 62) {
            if (this.line.charAt(1).charValue() == 'M') {
                this.properties.put("LKI_classificatiecode", this.line.part(2, 4));
            } else if (this.line.charAt(1).charValue() == 'L') {
                this.properties.put(GEMEENTECODEPERCEELLINKS, this.line.part(2, 6));
                this.properties.put(SECTIEPERCEELLINKS, this.line.part(7, 8));
                this.properties.put(INDEXLETTERPERCEELLINKS, this.line.part(10));
                this.line.shift(10);
                if (this.line.charAt(1).charValue() != 'V') throw new SUF2ParseException(this.lineNumberReader, "Ongeldig volg-subrecord. Na een L subrecord dient een V subrecord te komen.");
                this.properties.put(PERCEELNUMMERLINKS, this.line.part(2, 6));
                this.properties.put(INDEXNUMMERLINKS, this.line.part(7, 10));
            } else if (this.line.charAt(1).charValue() == 'R') {
                this.properties.put(GEMEENTECODEPERCEELRECHTS, this.line.part(2, 6));
                this.properties.put(SECTIEPERCEELRECHTS, this.line.part(7, 8));
                this.properties.put(INDEXLETTERPERCEELRECHTS, this.line.part(10));
                this.line.shift(10);
                if (this.line.charAt(1).charValue() != 'V') throw new SUF2ParseException(this.lineNumberReader, "Ongeldig volg-subrecord. Na een R subrecord dient een V subrecord te komen.");
                this.properties.put(PERCEELNUMMERRECHTS, this.line.part(2, 6));
                this.properties.put(INDEXNUMMERRECHTS, this.line.part(7, 10));
            } else if (this.line.charAt(1).charValue() == 'G') {
                HashMap<Integer, String> values_stringsoort = new HashMap<Integer, String>();
                values_stringsoort.put(1, "(knik)punt");
                values_stringsoort.put(12, "string (2 punten of meer)");
                values_stringsoort.put(13, "cirkelboog voor drie punten");
                SUF2ValueFinder.addValue(this.line.part(2, 3), G_STRINGSOORT, (Map)this.properties, values_stringsoort);
                String[] values_zichtbaarheid = new String[]{"normaal / niet bekend", "boven en onder maaiveld (Z-niveau)", "onzichtbaar vanuit de lucht", "vaag of slecht interpreteerbaar"};
                SUF2ValueFinder.addValue(this.line.part(4), G_ZICHTBAARHEID, (Map)this.properties, values_zichtbaarheid);
                String[] values_inwinning = new String[]{"niet bekend", "terrestrische meting (T)", "fotogrammetrische meting (F)", "digistalisering kaart (D)", "scanning kaart (S)", "kaartverbetering (K)"};
                SUF2ValueFinder.addValue(this.line.part(6), G_INWINNING, (Map)this.properties, values_inwinning);
                String[] values_status = new String[]{null, "nieuw object", null, null, "te verwijderen object"};
                SUF2ValueFinder.addValue(this.line.part(7), G_STATUS_VAN_OBJECT, (Map)this.properties, values_status);
            } else if (this.line.charAt(1).charValue() == 'D') {
                this.properties.put(D_OPNAMEDATUM, this.line.part(2, 10));
            } else if (this.line.charAt(1).charValue() == 'B') {
                this.properties.put(B_BRONVERMELDING, this.line.part(2, 6));
                String[] values = new String[]{"niet bekend", "kad. steen", "ijzeren buis", "draineerbuis", "bout", "spijker", "piket"};
                SUF2ValueFinder.addValue(this.line.part(8), B_WIJZE_VERZEKERING, (Map)this.properties, values);
            }
            this.line.shift(10);
        }
    }
}

