/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.suf2.records;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Map;
import nl.b3p.suf2.SUF2Coordinate;
import nl.b3p.suf2.SUF2Map;
import nl.b3p.suf2.SUF2ParseException;
import nl.b3p.suf2.SUF2ValueFinder;
import nl.b3p.suf2.records.SUF2Record;

public class SUF2Record04
extends SUF2Record {
    public static final String I_COORD_FUNCTIE = "functie van het coordinaatpunt";
    public static final String Q_PRECISIEKLASSE = "precisieklasse";
    public static final String Q_IDEALISATIEKLASSE = "idealisatieklasse";
    public static final String Q_BETROUWBAARHEID = "betrouwbaarheid";

    public SUF2Record04(LineNumberReader lineNumberReader, String line) throws SUF2ParseException, IOException {
        super(lineNumberReader, line);
    }

    public SUF2Record04(LineNumberReader lineNumberReader, String line, SUF2Map properties) throws SUF2ParseException, IOException {
        super(lineNumberReader, line, properties);
    }

    @Override
    public void parseProperties() throws SUF2ParseException {
        this.line.setShift(2);
        ArrayList<SUF2Coordinate> coordinates = new ArrayList<SUF2Coordinate>();
        SUF2Coordinate.Tag tag = null;
        while (this.line.getShift() < 52) {
            if (this.line.charAt(1).charValue() == 'I') {
                int tagNum = Integer.parseInt(this.line.part(2));
                switch (tagNum) {
                    case 1: {
                        tag = SUF2Coordinate.Tag.I1;
                        break;
                    }
                    case 2: {
                        tag = SUF2Coordinate.Tag.I2;
                        break;
                    }
                    case 4: {
                        tag = SUF2Coordinate.Tag.I4;
                        this.setType(SUF2Record.Type.ARC);
                        break;
                    }
                    default: {
                        throw new SUF2ParseException(this.lineNumberReader, "Unknown Coordinate tag " + tagNum);
                    }
                }
            } else if (this.line.charAt(1).charValue() == 'X') {
                String x = this.line.part(2, 10);
                this.line.shift(10);
                if (this.line.charAt(1).charValue() == 'Y') {
                    String y = this.line.part(2, 10);
                    SUF2Coordinate coordinate = new SUF2Coordinate((double)Integer.parseInt(x) / 1000.0, (double)Integer.parseInt(y) / 1000.0);
                    if (tag != null) {
                        coordinate.setTag(tag);
                    }
                    tag = null;
                    coordinates.add(coordinate);
                }
            } else if (this.line.charAt(1).charValue() == 'Q') {
                String[] values_precisie = new String[]{"1 cm", "5 cm", "12 cm", "23 cm", "23 cm", "46 cm", "100 cm", "250 cm"};
                SUF2ValueFinder.addValue(this.line.part(4), Q_PRECISIEKLASSE, (Map)this.properties, values_precisie);
                String[] values_idealisatie = new String[]{"onbekend", "0 - 2 cm", "2 - 5 cm", "5 - 10 cm", "> 10 cm"};
                SUF2ValueFinder.addValue(this.line.part(7), Q_IDEALISATIEKLASSE, (Map)this.properties, values_idealisatie);
                this.properties.put(Q_BETROUWBAARHEID, this.line.part(10));
            }
            this.line.shift(10);
        }
        if (coordinates.size() != 0) {
            this.properties.put("coordinates", coordinates);
            this.setType(SUF2Record.Type.LINE);
            this.hasGeometry = true;
        }
    }
}

