/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.suf2.records;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import nl.b3p.suf2.SUF2Coordinate;
import nl.b3p.suf2.SUF2Map;
import nl.b3p.suf2.SUF2ParseException;
import nl.b3p.suf2.records.SUF2Record;

public class SUF2Record05
extends SUF2Record {
    public static final String TEXT_ALIGN = "text align";
    public static final String STATUS_PERCEEL = "status perceel";
    public static final String TEKST_OF_SYMBOOL = "is tekst";
    public static final String SYMBOOLTYPE = "symbooltype";

    public SUF2Record05(LineNumberReader lineNumberReader, String line) throws SUF2ParseException, IOException {
        super(lineNumberReader, line);
    }

    public SUF2Record05(LineNumberReader lineNumberReader, String line, SUF2Map properties) throws SUF2ParseException, IOException {
        super(lineNumberReader, line, properties);
    }

    @Override
    public void parseProperties() throws SUF2ParseException {
        if (this.lineNumberReader.getLineNumber() >= 212667) {
            boolean bl = false;
        }
        this.line.setShift(2);
        this.properties.put(TEXT_ALIGN, this.line.part(2));
        this.properties.put(STATUS_PERCEEL, this.line.part(3));
        this.properties.put(TEKST_OF_SYMBOOL, this.line.part(4));
        this.properties.put(SYMBOOLTYPE, this.line.part(5, 10));
        ArrayList<SUF2Coordinate> coordinates = new ArrayList<SUF2Coordinate>();
        if (this.line.part(11).equals("X")) {
            this.line.setShift(12);
            double x = Integer.parseInt(this.line.part(2, 10));
            this.line.setShift(22);
            double y = Integer.parseInt(this.line.part(2, 10));
            coordinates.add(new SUF2Coordinate(x / 1000.0, y / 1000.0));
            this.line.setShift(32);
            if (!this.line.part(2, 10).trim().equals("")) {
                x = Integer.parseInt(this.line.part(2, 10));
                this.line.setShift(42);
                y = Integer.parseInt(this.line.part(2, 10));
                coordinates.add(new SUF2Coordinate(x / 1000.0, y / 1000.0));
                this.setType(SUF2Record.Type.SYMBOL);
                this.line.setShift(52);
                this.properties.put("LKI_classificatiecode", this.line.part(2, 4));
            }
        } else if (this.line.part(1).equals("X")) {
            double x = Integer.parseInt(this.line.part(2, 10));
            this.line.setShift(12);
            double y = Integer.parseInt(this.line.part(2, 10));
            coordinates.add(new SUF2Coordinate(x / 1000.0, y / 1000.0));
            this.line.setShift(22);
            if (this.line.part(1).equals("X")) {
                x = Integer.parseInt(this.line.part(2, 10));
                this.line.setShift(32);
                y = Integer.parseInt(this.line.part(2, 10));
                coordinates.add(new SUF2Coordinate(x / 1000.0, y / 1000.0));
                this.line.setShift(52);
                this.properties.put("LKI_classificatiecode", this.line.part(2, 4));
            } else {
                this.properties.put("LKI_classificatiecode", this.line.part(2, 4));
            }
            this.setType(SUF2Record.Type.LINE);
        }
        this.properties.put("coordinates", coordinates);
        this.hasGeometry = true;
    }
}

