/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.suf2.records;

import java.io.IOException;
import java.io.LineNumberReader;
import nl.b3p.suf2.SUF2Map;
import nl.b3p.suf2.SUF2ParseException;
import nl.b3p.suf2.records.SUF2Record;

public class SUF2Record07
extends SUF2Record {
    public static final String NAAM = "naam";
    public static final String OBJECT_ID = "aanduiding veld voor object-identificatie";
    public static final String BEHEERDER_ID = "identificatie beheerder";
    public static final String STRAATNAAM = "straatnaam";
    public static final String HUISNUMMER = "huisnummer";
    public static final String HUISNUMMER_TOEV = "huisnummer toevoeging";
    public static final String POSTCODE = "postcode";
    public static final String WOONPLAATS = "woonplaats";

    public SUF2Record07(LineNumberReader lineNumberReader, String line) throws SUF2ParseException, IOException {
        super(lineNumberReader, line);
    }

    public SUF2Record07(LineNumberReader lineNumberReader, String line, SUF2Map properties) throws SUF2ParseException, IOException {
        super(lineNumberReader, line, properties);
    }

    @Override
    public void parseProperties() throws SUF2ParseException {
        if (this.line.charAt(3).charValue() == 'N') {
            this.properties.put(NAAM, this.line.part(4, 38));
            this.properties.put(OBJECT_ID, this.line.part(53));
            this.properties.put(BEHEERDER_ID, this.line.part(54, 61));
        } else if (this.line.charAt(3).charValue() == 'A') {
            this.properties.put(STRAATNAAM, this.line.part(4, 27));
            this.properties.put(HUISNUMMER, this.line.part(28, 32));
            this.properties.put(HUISNUMMER_TOEV, this.line.part(33, 37));
            this.properties.put(POSTCODE, this.line.part(54, 59));
        } else if (this.line.charAt(3).charValue() == 'W') {
            this.properties.put(WOONPLAATS, this.line.part(4, 27));
            if (this.line.isMultiLine()) {
                throw new SUF2ParseException(this.lineNumberReader, "Record07 didn't close correct");
            }
        } else {
            throw new SUF2ParseException(this.lineNumberReader, "Unknown subrecord character in " + this.getClass().getSimpleName() + "; " + this.line.charAt(1) + " not supported");
        }
    }
}

