/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.zoeker.configuratie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import nl.b3p.zoeker.configuratie.ZoekConfiguratie;
import nl.b3p.zoeker.services.ZoekResultaat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachedResult {
    public static final long LIFECYCLE_CACHE = 21600000L;
    public static final int MAX_LIFECYCLE_CACHE_REQUEST = 28;
    private ZoekConfiguratie zc;
    private List<ZoekResultaat> resultList;
    private String[] searchStrings;
    private Integer maxResults;
    private long collectionTS;
    private int numOfRequests;

    CachedResult(ZoekConfiguratie zc, List<ZoekResultaat> resultList, String[] searchStrings, Integer maxResults) {
        this.zc = zc;
        this.resultList = resultList;
        this.searchStrings = searchStrings;
        this.maxResults = maxResults;
        this.collectionTS = new Date().getTime();
        this.numOfRequests = 1;
    }

    public boolean isExpired() {
        int calcRequests;
        long now = new Date().getTime();
        return now - this.collectionTS > (long)(calcRequests = Math.min(this.numOfRequests, 28)) * 21600000L;
    }

    public List<ZoekResultaat> getCachedResultList(ZoekConfiguratie zc, String[] searchStrings, Integer maxResults) {
        if (zc.isResultListDynamic()) {
            return null;
        }
        if (this.isExpired()) {
            return null;
        }
        if (maxResults == null && this.maxResults != null) {
            return null;
        }
        if (this.maxResults == null && maxResults != null) {
            return null;
        }
        if (maxResults != null && this.maxResults != null && !this.maxResults.equals(maxResults)) {
            return null;
        }
        if (!this.zc.getId().equals(zc.getId())) {
            return null;
        }
        if (searchStrings == null || this.searchStrings == null) {
            return null;
        }
        if (searchStrings.length != this.searchStrings.length) {
            return null;
        }
        for (int i = 0; i < searchStrings.length; ++i) {
            if (this.searchStrings[i].equals(searchStrings[i])) continue;
            return null;
        }
        ++this.numOfRequests;
        return this.resultList;
    }

    public static List<String> createKey(ZoekConfiguratie zc, String[] searchStrings) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(zc.getId().toString());
        key.addAll(Arrays.asList(searchStrings));
        return key;
    }
}

