/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.zoeker.services;

import java.util.ArrayList;
import java.util.List;
import nl.b3p.zoeker.configuratie.ZoekConfiguratie;
import nl.b3p.zoeker.services.ZoekResultaatAttribuut;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opengis.geometry.BoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoekResultaat
implements Comparable {
    private static final Log log = LogFactory.getLog(ZoekResultaat.class);
    private List<ZoekResultaatAttribuut> attributen = null;
    private ZoekConfiguratie zoekConfiguratie = null;
    private Double maxx;
    private Double maxy;
    private Double minx;
    private Double miny;
    private Integer count;

    public Double getMaxx() {
        return this.maxx;
    }

    public void setMaxx(Double maxx) {
        this.maxx = maxx;
    }

    public Double getMaxy() {
        return this.maxy;
    }

    public void setMaxy(Double maxy) {
        this.maxy = maxy;
    }

    public Double getMinx() {
        return this.minx;
    }

    public void setMinx(Double minx) {
        this.minx = minx;
    }

    public Double getMiny() {
        return this.miny;
    }

    public void setMiny(Double miny) {
        this.miny = miny;
    }

    public Integer getZoekConfigId() {
        if (this.getZoekConfiguratie() != null) {
            return this.getZoekConfiguratie().getId();
        }
        return null;
    }

    public List<ZoekResultaatAttribuut> getAttributen() {
        return this.attributen;
    }

    public void setAttributen(List attributen) {
        this.attributen = attributen;
    }

    void addAttribuut(ZoekResultaatAttribuut o) {
        if (this.getAttributen() == null) {
            this.setAttributen(new ArrayList());
        }
        this.attributen.add(o);
    }

    void setBbox(BoundingBox bounds) {
        this.setMaxx(bounds.getMaxX());
        this.setMaxy(bounds.getMaxY());
        this.setMinx(bounds.getMinX());
        this.setMiny(bounds.getMinY());
    }

    public String getId() {
        ArrayList waarden = this.getWaarden(1);
        if (waarden.isEmpty()) {
            ArrayList twaarden = this.getWaarden(2);
            if (twaarden.isEmpty()) {
                return null;
            }
            if (twaarden.size() > 1) {
                log.debug((Object)"Meerdere resultaat attributen geconfigureerd met type toon, dit mag er maar 1 zijn als er geen ID veld is. De eerste wordt gebruikt");
            }
            return twaarden.get(0).toString();
        }
        if (waarden.size() > 1) {
            log.debug((Object)"Meerdere resultaat attributen geconfigureerd met type ID, dit mag er maar 1 zijn. De eerste wordt gebruikt");
        }
        return waarden.get(0).toString();
    }

    public ArrayList getExtraAttribuutWaarden() {
        return this.getWaarden(0);
    }

    public String getLabel() {
        String resultValue = "";
        ArrayList waarden = this.getWaarden(2);
        waarden.addAll(this.getWaarden(-1));
        for (int i = 0; i < waarden.size(); ++i) {
            if (resultValue.length() > 0) {
                resultValue = resultValue + " ";
            }
            if (waarden.get(i) == null) continue;
            resultValue = resultValue + waarden.get(i).toString();
        }
        return resultValue;
    }

    public Double getMeasure() {
        ArrayList waarden = this.getWaarden(120);
        if (waarden.size() > 0) {
            String zonderKm = waarden.get(0).toString().replace("km", "").trim();
            return Double.parseDouble(zonderKm);
        }
        return null;
    }

    private ArrayList getWaarden(int type) {
        ArrayList<Object> returnValue = new ArrayList<Object>();
        if (this.getAttributen() != null) {
            for (int i = 0; i < this.getAttributen().size(); ++i) {
                ZoekResultaatAttribuut a = this.getAttributen().get(i);
                if ((a.getType() == null || a.getType() != type) && (type != 120 || a.getLabel() == null || !a.getLabel().equalsIgnoreCase("afstand"))) continue;
                returnValue.add(a.getWaarde());
            }
        }
        return returnValue;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.attributen != null ? this.attributen.hashCode() : 0);
        return hash;
    }

    public int compareTo(Object o) {
        int comp;
        if (!(o instanceof ZoekResultaat)) {
            return 1;
        }
        ZoekResultaat zoekResultaat = (ZoekResultaat)o;
        if (this.getMeasure() != null && (comp = this.getMeasure().compareTo(zoekResultaat.getMeasure())) != 0) {
            return comp;
        }
        ArrayList zAttributen = (ArrayList)zoekResultaat.getAttributen();
        if (zAttributen == null) {
            return 1;
        }
        if (this.attributen == null) {
            return -1;
        }
        if (this.attributen.size() != zAttributen.size()) {
            return 1;
        }
        block0: for (int i = 0; i < this.attributen.size(); ++i) {
            ZoekResultaatAttribuut thisZra = this.attributen.get(i);
            for (int z = 0; z < zAttributen.size(); ++z) {
                ZoekResultaatAttribuut zra = (ZoekResultaatAttribuut)zAttributen.get(z);
                if (ZoekResultaat.compareAttributeNames(thisZra, zra) != 0) continue;
                int valueCompare = ZoekResultaat.compareAttributeValues(thisZra, zra);
                if (valueCompare == 0) continue block0;
                return valueCompare;
            }
        }
        return 0;
    }

    private static int compareAttributeNames(ZoekResultaatAttribuut thisZra, ZoekResultaatAttribuut zra) {
        if (zra.getType() == null && thisZra.getType() != null) {
            return 1;
        }
        if (thisZra.getType() == null) {
            return -1;
        }
        if (zra.getType() == null && thisZra.getType() == null) {
            return 0;
        }
        if (zra.getAttribuutnaam() == null && thisZra.getAttribuutnaam() != null) {
            return 1;
        }
        if (thisZra.getAttribuutnaam() == null) {
            return -1;
        }
        if (zra.getAttribuutnaam() == null && thisZra.getAttribuutnaam() == null) {
            return 0;
        }
        if (!thisZra.getType().equals(zra.getType())) {
            return 1;
        }
        if (!thisZra.getType().equals(2)) {
            return 0;
        }
        return thisZra.getAttribuutnaam().compareTo(zra.getAttribuutnaam());
    }

    private static int compareAttributeValues(ZoekResultaatAttribuut thisZra, ZoekResultaatAttribuut zra) {
        if (thisZra.getWaarde() == null && zra.getWaarde() == null) {
            return 0;
        }
        if (thisZra.getWaarde() == null) {
            return -1;
        }
        if (zra.getWaarde() == null) {
            return 1;
        }
        if (thisZra.getWaarde() instanceof Comparable && zra.getWaarde() instanceof Comparable) {
            boolean NaN = false;
            if (thisZra.getWaarde() instanceof String && zra.getWaarde() instanceof String) {
                try {
                    Double thisD = new Double(thisZra.getWaarde().toString());
                    Double d = new Double(zra.getWaarde().toString());
                    return thisD.compareTo(d);
                }
                catch (NumberFormatException nfe) {
                    NaN = true;
                }
            }
            if (NaN) {
                return ((Comparable)thisZra.getWaarde()).compareTo(zra.getWaarde());
            }
            return ((Comparable)thisZra.getWaarde()).compareTo((Comparable)zra.getWaarde());
        }
        return thisZra.getWaarde().toString().compareToIgnoreCase(zra.getWaarde().toString());
    }

    public ZoekConfiguratie getZoekConfiguratie() {
        return this.zoekConfiguratie;
    }

    public void setZoekConfiguratie(ZoekConfiguratie zoekConfiguratie) {
        this.zoekConfiguratie = zoekConfiguratie;
    }

    public ZoekResultaatAttribuut getAttribuutByName(String name) {
        if (this.attributen != null) {
            for (ZoekResultaatAttribuut at : this.attributen) {
                if (!at.getNaam().equals(name)) continue;
                return at;
            }
        }
        return null;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }
}

