/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.zoeker.configuratie;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.oracle.OracleNGDataStoreFactory;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.v1_0_0.WFSCapabilities;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.filter.FilterCapabilities;
import org.json.JSONException;
import org.json.JSONObject;

public class Bron {
    private Integer id = null;
    private String naam = null;
    private String url = null;
    private String gebruikersnaam = null;
    private String wachtwoord = null;
    private Integer volgorde = null;
    private static final int TIMEOUT = 60000;
    public static final String TYPE_JDBC = "jdbc";
    public static final String TYPE_ORACLE = "oracle";
    public static final String TYPE_WFS = "wfs";
    public static final String TYPE_EMPTY = "unknown";
    protected static Map<Map, WFSDataStore> perParameterSetDataStoreCache = new HashMap<Map, WFSDataStore>();
    protected static long dataStoreTimestamp = 0L;
    private static long dataStoreLifecycle = 0L;
    public static final String LIFECYCLE_CACHE_PARAM = "cachelifecycle";
    private static final Log log = LogFactory.getLog(Bron.class);

    public Bron() {
    }

    public Bron(Integer id, String naam, String url, String gebruikersnaam, String wachtwoord, Integer volgorde) {
        this.id = id;
        this.naam = naam;
        this.url = url;
        this.gebruikersnaam = gebruikersnaam;
        this.wachtwoord = wachtwoord;
        this.volgorde = volgorde;
    }

    public Bron(Integer id, String naam, String url) {
        this(id, naam, url, null, null, null);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getNaam() {
        return this.naam;
    }

    public void setNaam(String naam) {
        this.naam = naam;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getVolgorde() {
        return this.volgorde;
    }

    public void setVolgorde(Integer volgorde) {
        this.volgorde = volgorde;
    }

    public String getGebruikersnaam() {
        return this.gebruikersnaam;
    }

    public void setGebruikersnaam(String gebruikersnaam) {
        this.gebruikersnaam = gebruikersnaam;
    }

    public String getWachtwoord() {
        return this.wachtwoord;
    }

    public void setWachtwoord(String wachtwoord) {
        this.wachtwoord = wachtwoord;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.id);
        json.put("naam", (Object)this.getNaam());
        json.put("url", (Object)this.getUrl());
        json.put("volgorde", (Object)this.getVolgorde());
        return json;
    }

    public String getType() {
        if (this.checkType(TYPE_JDBC)) {
            return TYPE_JDBC;
        }
        if (this.checkType(TYPE_WFS)) {
            return TYPE_WFS;
        }
        return TYPE_EMPTY;
    }

    public boolean checkType(String type) {
        if (this.getUrl() == null || type == null || type.length() == 0) {
            return false;
        }
        if (this.getUrl().toLowerCase().startsWith("jdbc:")) {
            if (this.getUrl().toLowerCase().startsWith("jdbc:oracle:") && type.equals(TYPE_ORACLE)) {
                return true;
            }
            if (type.equals(TYPE_JDBC)) {
                return true;
            }
        } else if (type.equals(TYPE_WFS)) {
            return true;
        }
        return false;
    }

    public DataStore toDatastore() throws IOException, Exception {
        if (this.getUrl() == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.checkType(TYPE_ORACLE)) {
            int firstIndex = this.getUrl().indexOf("@") + 1;
            int lastIndex = this.getUrl().indexOf(":", firstIndex);
            String host = this.getUrl().substring(firstIndex, lastIndex);
            firstIndex = lastIndex + 1;
            lastIndex = this.getUrl().indexOf(":", firstIndex);
            String port = this.getUrl().substring(firstIndex, lastIndex);
            firstIndex = lastIndex + 1;
            lastIndex = this.getUrl().indexOf(".", firstIndex);
            String schema = null;
            if (lastIndex == -1) {
                lastIndex = this.getUrl().length();
            } else {
                schema = this.getUrl().substring(lastIndex + 1, this.getUrl().length());
            }
            String instance = this.getUrl().substring(firstIndex, lastIndex);
            params.put(OracleNGDataStoreFactory.HOST.key, host);
            params.put(OracleNGDataStoreFactory.PORT.key, port);
            if (schema != null) {
                params.put(OracleNGDataStoreFactory.SCHEMA.key, schema);
            }
            params.put(OracleNGDataStoreFactory.FETCHSIZE.key, 50);
            params.put(OracleNGDataStoreFactory.DATABASE.key, instance);
            params.put(OracleNGDataStoreFactory.USER.key, this.getGebruikersnaam());
            params.put(OracleNGDataStoreFactory.PASSWD.key, this.getWachtwoord());
            params.put(OracleNGDataStoreFactory.DBTYPE.key, TYPE_ORACLE);
            params.put(OracleNGDataStoreFactory.EXPOSE_PK.key, Boolean.TRUE);
            return new OracleNGDataStoreFactory().createDataStore(params);
        }
        if (this.checkType(TYPE_JDBC)) {
            String[] tokens;
            int firstIndex = this.getUrl().indexOf("//") + 2;
            int lastIndex = this.getUrl().indexOf(":", firstIndex);
            String host = this.getUrl().substring(firstIndex, lastIndex);
            firstIndex = lastIndex + 1;
            lastIndex = this.getUrl().indexOf("/", firstIndex);
            String port = this.getUrl().substring(firstIndex, lastIndex);
            firstIndex = lastIndex + 1;
            String database = this.getUrl().substring(firstIndex, this.getUrl().length());
            String schema = "public";
            if (database.indexOf(".") >= 0 && (tokens = database.split("\\.")).length == 2) {
                schema = tokens[1];
                database = tokens[0];
            }
            params.put(PostgisNGDataStoreFactory.FETCHSIZE.key, 50);
            params.put(PostgisNGDataStoreFactory.DBTYPE.key, "postgis");
            params.put(PostgisNGDataStoreFactory.HOST.key, host);
            params.put(PostgisNGDataStoreFactory.PORT.key, port);
            params.put(PostgisNGDataStoreFactory.SCHEMA.key, schema);
            params.put(PostgisNGDataStoreFactory.DATABASE.key, database);
            if (this.getGebruikersnaam() != null) {
                params.put(PostgisNGDataStoreFactory.USER.key, this.getGebruikersnaam());
            }
            if (this.getWachtwoord() != null) {
                params.put(PostgisNGDataStoreFactory.PASSWD.key, this.getWachtwoord());
            }
            params.put(PostgisNGDataStoreFactory.EXPOSE_PK.key, Boolean.TRUE);
        }
        if (this.checkType(TYPE_WFS)) {
            WFSDataStore ds;
            String url = this.getUrl();
            if (this.getUrl().toLowerCase().indexOf("request=") == -1 && (url = url.indexOf(63) < 0 ? url + "?request=GetCapabilities&service=WFS" : (url.indexOf(63) == url.length() - 1 ? url + "request=GetCapabilities&service=WFS" : (url.lastIndexOf(38) == url.length() - 1 ? url + "request=GetCapabilities&service=WFS" : url + "&request=GetCapabilities&service=WFS"))).toLowerCase().indexOf("version") == -1) {
                url = url + "&Version=1.1.0";
            }
            params.put(WFSDataStoreFactory.URL.key, url);
            if (this.getGebruikersnaam() != null && this.getWachtwoord() != null) {
                params.put(WFSDataStoreFactory.USERNAME.key, this.getGebruikersnaam());
                params.put(WFSDataStoreFactory.PASSWORD.key, this.getWachtwoord());
            }
            params.put(WFSDataStoreFactory.TIMEOUT.key, 60000);
            params.put(WFSDataStoreFactory.PROTOCOL.key, Boolean.TRUE);
            if (url.contains("mapserv") && url.contains(".map")) {
                params.put(WFSDataStoreFactory.WFS_STRATEGY.key, "mapserver");
            }
            if ((ds = Bron.getWfsCache(params)) == null && !perParameterSetDataStoreCache.containsKey(params)) {
                ds = new WFSDataStoreFactory().createDataStore(params);
                Bron.putWfsCache(params, (WFSDataStore)Bron.repairDataStore((DataStore)ds));
            }
            return ds;
        }
        return Bron.createDataStoreFromParams(params);
    }

    public static synchronized void flushWfsCache() {
        perParameterSetDataStoreCache = new HashMap<Map, WFSDataStore>();
        log.info((Object)"Cache WFS leeggemaakt.");
    }

    public static synchronized void putWfsCache(HashMap p, WFSDataStore ds) {
        perParameterSetDataStoreCache.put(p, ds);
    }

    public static synchronized WFSDataStore getWfsCache(HashMap p) {
        if (Bron.isCacheExpired()) {
            Bron.flushWfsCache();
            return null;
        }
        if (perParameterSetDataStoreCache.containsKey(p)) {
            return perParameterSetDataStoreCache.get(p);
        }
        return null;
    }

    public static boolean isCacheExpired() {
        long nowTimestamp = new Date().getTime();
        if (Bron.getDataStoreLifecycle() > 0L && nowTimestamp - dataStoreTimestamp > Bron.getDataStoreLifecycle()) {
            dataStoreTimestamp = nowTimestamp;
            return true;
        }
        return false;
    }

    public static long getDataStoreLifecycle() {
        return dataStoreLifecycle;
    }

    public static void setDataStoreLifecycle(long aDataStoreLifecycle) {
        dataStoreLifecycle = aDataStoreLifecycle;
    }

    public static DataStore createDataStoreFromParams(Map params) throws IOException, Exception {
        DataStore ds = null;
        try {
            ds = Bron.repairDataStore(DataStoreFinder.getDataStore((Map)params));
        }
        catch (IOException ex) {
            throw new Exception("Connectie naar gegevensbron mislukt. Controleer de bron instellingen.");
        }
        return ds;
    }

    private static DataStore repairDataStore(DataStore ds) throws Exception {
        if (ds instanceof WFS_1_0_0_DataStore) {
            WFS_1_0_0_DataStore wfs100ds = (WFS_1_0_0_DataStore)ds;
            WFSCapabilities wfscap = wfs100ds.getCapabilities();
            FilterCapabilities filterCap = wfscap.getFilterCapabilities();
            filterCap.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
            boolean b = filterCap.supports(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
            wfscap.setFilterCapabilities(filterCap);
        }
        return ds;
    }

    public String toString() {
        String returnValue = "";
        if (this.getNaam() != null) {
            returnValue = returnValue + this.getNaam() + " ";
        }
        if (this.getUrl() != null) {
            returnValue = returnValue + "(" + this.getUrl() + ")";
        }
        return returnValue;
    }
}

