/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.zoeker.configuratie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.b3p.zoeker.configuratie.Attribuut;
import nl.b3p.zoeker.configuratie.Bron;
import nl.b3p.zoeker.configuratie.CachedResult;
import nl.b3p.zoeker.configuratie.ResultaatAttribuut;
import nl.b3p.zoeker.configuratie.ZoekAttribuut;
import nl.b3p.zoeker.services.ZoekResultaat;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoekConfiguratie
implements Comparable {
    public static final String FLUSH_CACHE_PARAM = "flushresultlistcache";
    private Integer id = null;
    private String naam = null;
    private String featureType = null;
    private Set<ZoekAttribuut> zoekVelden = null;
    private Set<ResultaatAttribuut> resultaatVelden = null;
    private ZoekConfiguratie parentZoekConfiguratie = null;
    private Bron parentBron = null;
    private static Map<List<String>, CachedResult> cachedResultMap = new HashMap<List<String>, CachedResult>();
    private boolean resultListDynamic = true;
    private String omschrijving;
    private String forUsageIn;
    public static final String USE_IN_VIEWER_WEBR = "viewer_webr";
    public static final String USE_IN_VIEWER = "viewer";
    public static final String USE_IN_WEBR = "webr";
    private static final Log log = LogFactory.getLog(ZoekConfiguratie.class);

    public ZoekConfiguratie() {
    }

    public ZoekConfiguratie(Integer id, String naam, String featureType, Bron parentBron, ZoekConfiguratie parentZoekConfiguratie) {
        this.id = id;
        this.naam = naam;
        this.featureType = featureType;
        this.parentBron = parentBron;
        this.parentZoekConfiguratie = parentZoekConfiguratie;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(String featureType) {
        this.featureType = featureType;
    }

    public Set<ZoekAttribuut> getZoekVelden() {
        return this.zoekVelden;
    }

    public void setZoekVelden(Set zoekVelden) {
        this.zoekVelden = zoekVelden;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ZoekConfiguratie getParentZoekConfiguratie() {
        return this.parentZoekConfiguratie;
    }

    public void setParentZoekConfiguratie(ZoekConfiguratie parentZoekConfiguratie) {
        this.parentZoekConfiguratie = parentZoekConfiguratie;
    }

    public Bron getParentBron() {
        return this.parentBron;
    }

    public void setParentBron(Bron parentBron) {
        this.parentBron = parentBron;
    }

    public String getNaam() {
        return this.naam;
    }

    public void setNaam(String naam) {
        this.naam = naam;
    }

    public Bron getBron() {
        if (this.getParentBron() != null) {
            return this.getParentBron();
        }
        if (this.getParentZoekConfiguratie() != null) {
            return this.getParentZoekConfiguratie().getBron();
        }
        return null;
    }

    public Set<ResultaatAttribuut> getResultaatVelden() {
        return this.resultaatVelden;
    }

    public void setResultaatVelden(Set resultaatVelden) {
        this.resultaatVelden = resultaatVelden;
    }

    public void addZoekAttribuut(ZoekAttribuut zoekAttribuut) {
        if (this.zoekVelden == null) {
            this.zoekVelden = new HashSet<ZoekAttribuut>();
        }
        zoekAttribuut.setZoekConfiguratie(this);
        this.zoekVelden.add(zoekAttribuut);
    }

    public void addResultaatAttribuut(ResultaatAttribuut resultaatAttribuut) {
        if (this.resultaatVelden == null) {
            this.resultaatVelden = new HashSet<ResultaatAttribuut>();
        }
        resultaatAttribuut.setZoekConfiguratie(this);
        this.resultaatVelden.add(resultaatAttribuut);
    }

    public JSONObject toJSON() throws JSONException {
        Iterator<Attribuut> it;
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.getId());
        json.put("naam", (Object)this.getNaam());
        json.put("featureType", (Object)this.getFeatureType());
        if (this.getZoekVelden() != null) {
            it = this.getZoekVelden().iterator();
            JSONArray jsonZoekVelden = null;
            while (it.hasNext()) {
                if (jsonZoekVelden == null) {
                    jsonZoekVelden = new JSONArray();
                }
                ZoekAttribuut zoekVeld = (ZoekAttribuut)it.next();
                jsonZoekVelden.put((Object)zoekVeld.toJSON());
            }
            json.put("zoekVelden", jsonZoekVelden);
        }
        if (this.getResultaatVelden() != null) {
            it = this.getResultaatVelden().iterator();
            JSONArray jsonResultaatVelden = null;
            while (it.hasNext()) {
                if (jsonResultaatVelden == null) {
                    jsonResultaatVelden = new JSONArray();
                }
                ResultaatAttribuut resultaatVeld = (ResultaatAttribuut)it.next();
                jsonResultaatVelden.put((Object)resultaatVeld.toJSON());
            }
            json.put("resultaatVelden", jsonResultaatVelden);
        }
        if (this.getParentZoekConfiguratie() != null) {
            json.put("parentZoekConfiguratieId", (Object)this.getParentZoekConfiguratie().getId());
        }
        if (this.getBron() != null) {
            json.put("bron", (Object)this.getBron().toJSON());
        }
        if (this.getForUsageIn() != null) {
            json.put("forUsageIn", (Object)this.getForUsageIn());
        }
        return json;
    }

    public String toString() {
        String returnValue = "";
        if (this.getNaam() != null) {
            returnValue = returnValue + this.getNaam() + " ";
        }
        if (this.getFeatureType() != null) {
            returnValue = returnValue + this.getFeatureType();
        }
        if (this.getBron() != null) {
            returnValue = returnValue + " Bron: " + this.getBron().toString();
        }
        return returnValue;
    }

    public boolean isResultListDynamic() {
        return this.resultListDynamic;
    }

    public void setResultListDynamic(boolean resultListDynamic) {
        this.resultListDynamic = resultListDynamic;
    }

    public static synchronized void flushCachedResultListCache() {
        cachedResultMap = new HashMap<List<String>, CachedResult>();
        log.info((Object)"Cache opzoeklijsten leeggemaakt.");
    }

    public String getOmschrijving() {
        return this.omschrijving;
    }

    public void setOmschrijving(String omschrijving) {
        this.omschrijving = omschrijving;
    }

    public String getForUsageIn() {
        return this.forUsageIn;
    }

    public void setForUsageIn(String forUsageIn) {
        this.forUsageIn = forUsageIn;
    }

    public static synchronized void setCachedResultList(ZoekConfiguratie zc, List<ZoekResultaat> resultList, String[] searchStrings, Integer maxResults) {
        ZoekConfiguratie.cleanUpCache();
        if (zc.isResultListDynamic()) {
            return;
        }
        CachedResult cr = new CachedResult(zc, resultList, searchStrings, maxResults);
        cachedResultMap.put(CachedResult.createKey(zc, searchStrings), cr);
    }

    public static synchronized List<ZoekResultaat> getCachedResultList(ZoekConfiguratie zc, String[] searchStrings, Integer maxResults) {
        ZoekConfiguratie.cleanUpCache();
        CachedResult cr = cachedResultMap.get(CachedResult.createKey(zc, searchStrings));
        if (cr != null) {
            return cr.getCachedResultList(zc, searchStrings, maxResults);
        }
        return null;
    }

    protected static void cleanUpCache() {
        Set<List<String>> keys = cachedResultMap.keySet();
        if (keys == null) {
            return;
        }
        ArrayList<List<String>> remKeys = new ArrayList<List<String>>();
        for (List<String> key : keys) {
            CachedResult cr = cachedResultMap.get(key);
            if (!cr.isExpired()) continue;
            remKeys.add(key);
        }
        for (List<String> remKey : remKeys) {
            cachedResultMap.remove(remKey);
        }
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZoekConfiguratie other = (ZoekConfiguratie)obj;
        return this.id == other.id || this.id != null && this.id.equals(other.id);
    }

    public int compareTo(Object o) {
        ZoekConfiguratie myClass = (ZoekConfiguratie)o;
        return new CompareToBuilder().append((Object)this.naam, (Object)myClass.naam).toComparison();
    }
}

