/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.zoeker.hibernate;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyEMFDatabase {
    private static final Log log = LogFactory.getLog(MyEMFDatabase.class);
    public static final String MAIN_EM = "zoekerMainEM";
    public static final String INIT_EM = "zoekerInitEM";
    public static final String REALM_EM = "zoekerRealmEM";
    private static EntityManagerFactory emf = null;
    private static ThreadLocal tlMap = new ThreadLocal();
    private static String defaultPU = "zoekerPU";
    private static final Owner trueOwner = new Owner(true);
    private static final Owner fakeOwner = new Owner(false);

    public static void openEntityManagerFactory(String persistenceUnit) throws Exception {
        log.info((Object)("ManagedPersistence.openEntityManagerFactory(" + persistenceUnit + ")"));
        if (emf != null) {
            log.warn((Object)("EntityManagerFactory already initialized: " + emf.toString()));
            return;
        }
        if (persistenceUnit == null || persistenceUnit.trim().length() == 0) {
            throw new Exception("PersistenceUnit cannot be left empty.");
        }
        try {
            emf = Persistence.createEntityManagerFactory((String)persistenceUnit);
        }
        catch (Throwable t) {
            log.fatal((Object)"Error initializing EntityManagerFactory: ", t);
        }
        if (emf == null) {
            throw new Exception("Cannot initialize EntityManagerFactory");
        }
        log.info((Object)("EntityManagerFactory initialized: " + emf.toString()));
    }

    public static EntityManagerFactory getEntityManagerFactory() throws Exception {
        if (emf == null) {
            MyEMFDatabase.openEntityManagerFactory(defaultPU);
        }
        return emf;
    }

    public static Object createEntityManager(String emKey) throws Exception {
        EntityManager localEm = (EntityManager)MyEMFDatabase.getThreadLocal(emKey);
        if (localEm == null) {
            log.debug((Object)("No EntityManager Found - Create and give the identity for key: " + emKey));
            localEm = MyEMFDatabase.getEntityManagerFactory().createEntityManager();
            if (localEm == null) {
                throw new Exception("EntityManager could not be initialized for key: " + emKey);
            }
            MyEMFDatabase.setThreadLocal(emKey, localEm);
            return trueOwner;
        }
        log.debug((Object)("EntityManager Found - Give a Fake identity for key: " + emKey));
        return fakeOwner;
    }

    public static EntityManager getEntityManager(String emKey) throws Exception {
        EntityManager localEm = (EntityManager)MyEMFDatabase.getThreadLocal(emKey);
        if (localEm == null) {
            throw new Exception("EntityManager could not be initialized for key: " + emKey);
        }
        return localEm;
    }

    public static void closeEntityManager(Object ownership, String emKey) {
        if (ownership != null && ((Owner)ownership).identity) {
            log.debug((Object)("Identity is accepted. Now closing the session for key: " + emKey));
            EntityManager localEm = (EntityManager)MyEMFDatabase.getThreadLocal(emKey);
            if (localEm == null) {
                log.warn((Object)("EntityManager is missing. Either it's already closed or never initialized for key: " + emKey));
                return;
            }
            MyEMFDatabase.clearThreadLocal(emKey);
            localEm.close();
        } else {
            log.debug((Object)("Identity is rejected. Ignoring the request for key: " + emKey));
        }
    }

    private static void initThreadLocal() {
        tlMap.set(new HashMap());
    }

    private static void clearThreadLocal(String key) {
        Map threadLocalMap = (Map)tlMap.get();
        threadLocalMap.remove(key);
    }

    private static void setThreadLocal(String key, Object object) {
        if (tlMap.get() == null) {
            MyEMFDatabase.initThreadLocal();
        }
        Map threadLocalMap = (Map)tlMap.get();
        threadLocalMap.put(key, object);
    }

    private static Object getThreadLocal(String key) {
        if (tlMap.get() == null) {
            MyEMFDatabase.initThreadLocal();
            return null;
        }
        Map threadLocalMap = (Map)tlMap.get();
        return threadLocalMap.get(key);
    }

    private static class Owner {
        boolean identity = false;

        public Owner(boolean identity) {
            this.identity = identity;
        }
    }
}

