/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.zoeker.services;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nl.b3p.zoeker.configuratie.Bron;
import nl.b3p.zoeker.configuratie.ResultaatAttribuut;
import nl.b3p.zoeker.configuratie.ZoekAttribuut;
import nl.b3p.zoeker.configuratie.ZoekConfiguratie;
import nl.b3p.zoeker.hibernate.MyEMFDatabase;
import nl.b3p.zoeker.services.A11YResult;
import nl.b3p.zoeker.services.ZoekResultaat;
import nl.b3p.zoeker.services.ZoekResultaatAttribuut;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.v1_0_0.WFSCapabilities;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.FilterCapabilities;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zoeker {
    private static final int defaultMaxResults = 1000;
    private static final Log log = LogFactory.getLog(Zoeker.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy", new Locale("NL"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZoekResultaat> zoek(Integer[] zoekConfiguratieIds, String[] searchStrings, Integer maxResults) {
        List<ZoekResultaat> results = new ArrayList<ZoekResultaat>();
        Object identity = null;
        try {
            identity = MyEMFDatabase.createEntityManager("zoekerMainEM");
            EntityManager em = MyEMFDatabase.getEntityManager("zoekerMainEM");
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            try {
                String queryString = "from ZoekConfiguratie z where z.id IN (";
                for (int i = 0; i < zoekConfiguratieIds.length; ++i) {
                    if (i != 0) {
                        queryString = queryString + ",";
                    }
                    queryString = queryString + zoekConfiguratieIds[i];
                }
                queryString = queryString + ") order by z.naam";
                List zoekconfiguraties = em.createQuery(queryString).getResultList();
                for (int i = 0; i < zoekconfiguraties.size(); ++i) {
                    ZoekConfiguratie zc = (ZoekConfiguratie)zoekconfiguraties.get(i);
                    results = this.zoekMetConfiguratie(zc, this.cleanStringArray(searchStrings), maxResults, results);
                    ZoekResultaat zr = this.getXYZoekResultaat(zc, searchStrings);
                    if (zr == null) continue;
                    if (results == null) {
                        results = new ArrayList();
                    }
                    results.add(zr);
                }
                tx.commit();
            }
            catch (Exception ex) {
                log.error((Object)("Exception occured" + (tx.isActive() ? ", rollback" : "tx not active")), (Throwable)ex);
                if (tx.isActive()) {
                    tx.rollback();
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)"Exception occured in search: ", e);
        }
        finally {
            log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager(identity, "zoekerMainEM");
        }
        if (results != null) {
            Collections.sort(results);
        }
        return results;
    }

    private String[] cleanStringArray(String[] sa) {
        if (sa == null) {
            return null;
        }
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = sa[i].trim();
        }
        return sa;
    }

    protected ZoekResultaat resultaatInVraag(ZoekConfiguratie zc, String[] searchStrings) {
        Set<ResultaatAttribuut> rvs = zc.getResultaatVelden();
        Set<ZoekAttribuut> zvs = zc.getZoekVelden();
        Integer gelijkAanType = new Integer(6);
        if (rvs != null && !rvs.isEmpty() && zvs != null && !zvs.isEmpty() && zvs.size() == searchStrings.length) {
            boolean allRvsAvailable = true;
            ZoekResultaat p = new ZoekResultaat();
            p.setZoekConfiguratie(zc);
            for (ResultaatAttribuut rv : rvs) {
                boolean foundRv = false;
                int loop = 0;
                for (ZoekAttribuut zv : zvs) {
                    if (rv.getAttribuutnaam().equals(zv.getAttribuutnaam()) && gelijkAanType.equals(zv.getType())) {
                        ZoekResultaatAttribuut zra = new ZoekResultaatAttribuut(rv);
                        zra.setWaarde(searchStrings[loop]);
                        p.addAttribuut(zra);
                        foundRv = true;
                        break;
                    }
                    ++loop;
                }
                if (foundRv) continue;
                allRvsAvailable = false;
            }
            if (allRvsAvailable) {
                return p;
            }
        }
        return null;
    }

    public List<ZoekResultaat> zoekMetConfiguratie(ZoekConfiguratie zc, String[] searchStrings, Integer maxResults, List<ZoekResultaat> results) {
        return this.zoekMetConfiguratie(zc, searchStrings, maxResults, results, false, 0, 0);
    }

    public List<ZoekResultaat> zoekMetConfiguratie(ZoekConfiguratie zc, String[] searchStrings, Integer maxResults, List<ZoekResultaat> results, boolean usePagination, int startIndex, int limit) {
        return this.zoekMetConfiguratie(zc, searchStrings, maxResults, results, false, 0, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZoekResultaat> zoekMetConfiguratie(ZoekConfiguratie zc, String[] searchStrings, Integer maxResults, List<ZoekResultaat> results, boolean usePagination, int startIndex, int limit, A11YResult currentA11YResult) {
        ArrayList<ZoekResultaat> zoekResultaten;
        block54: {
            if (maxResults == null || maxResults == 0) {
                maxResults = 1000;
            }
            if (zc == null || searchStrings == null) {
                return results;
            }
            boolean calculateDistance = false;
            String locationWkt = null;
            zoekResultaten = new ArrayList<ZoekResultaat>(results);
            ZoekResultaat zr = this.resultaatInVraag(zc, searchStrings);
            if (zr != null) {
                zoekResultaten.add(zr);
                log.debug((Object)"Result found in request, no new search action!");
                return zoekResultaten;
            }
            if (!zc.isResultListDynamic()) {
                List<ZoekResultaat> cachedResultaten = ZoekConfiguratie.getCachedResultList(zc, searchStrings, maxResults);
                if (cachedResultaten != null && !cachedResultaten.isEmpty()) {
                    zoekResultaten.addAll(cachedResultaten);
                    Collections.sort(zoekResultaten);
                    log.debug((Object)"Cached list used!");
                    return zoekResultaten;
                }
                log.debug((Object)"Cached list not found!");
            }
            Bron bron = zc.getBron();
            DataStore ds = null;
            try {
                ds = Zoeker.getDataStore(bron);
                if (ds != null) {
                    FeatureCollection fc = null;
                    FeatureIterator fi = null;
                    try {
                        String startLocatie;
                        if (ds instanceof WFS_1_0_0_DataStore) {
                            WFS_1_0_0_DataStore wfs100ds = (WFS_1_0_0_DataStore)ds;
                            WFSCapabilities wfscap = wfs100ds.getCapabilities();
                            FilterCapabilities filterCap = wfscap.getFilterCapabilities();
                            filterCap.addType(32768L);
                            wfscap.setFilterCapabilities(filterCap);
                        }
                        SimpleFeatureSource fs = ds.getFeatureSource(zc.getFeatureType());
                        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
                        if (zc.getZoekVelden() == null) {
                            throw new Exception("Fout in zoekconfiguratie. Er zijn geen zoekvelden gedefineerd");
                        }
                        if (zc.getZoekVelden().size() != searchStrings.length) {
                            throw new Exception("Fout in zoekconfiguratie. Het aantal zoekvelden (" + zc.getZoekVelden().size() + ") is ongelijk aan het aantal meegegeven strings(" + searchStrings.length + ")");
                        }
                        Iterator<ZoekAttribuut> it = zc.getZoekVelden().iterator();
                        ArrayList<Filter> filters = new ArrayList<Filter>();
                        try {
                            fs.getSchema();
                        }
                        catch (NullPointerException npe) {
                            log.error((Object)"Kan het schema voor de zoekconfiguratie niet ophalen", (Throwable)npe);
                            throw npe;
                        }
                        ArrayList<String> properties = new ArrayList<String>();
                        int i = 0;
                        while (it.hasNext()) {
                            ZoekAttribuut zoekVeld = it.next();
                            Filter filter = this.createFilter(ZoekAttribuut.setToZoekVeldenArray(zc.getZoekVelden()), searchStrings, i, ds, ff, fs.getSchema());
                            if (filter != null) {
                                filters.add(filter);
                            }
                            if (zoekVeld.getType() == 110) {
                                calculateDistance = true;
                                locationWkt = searchStrings[i];
                                startLocatie = this.getStartLocationFromSession();
                                if (startLocatie != null) {
                                    locationWkt = startLocatie;
                                }
                                if (currentA11YResult != null) {
                                    locationWkt = currentA11YResult.getStartWkt();
                                }
                            }
                            ++i;
                        }
                        Object filter = null;
                        filter = filters.size() == 1 ? (Filter)filters.get(0) : ff.and(filters);
                        DefaultQuery query = filters.isEmpty() ? new DefaultQuery(zc.getFeatureType()) : new DefaultQuery(zc.getFeatureType(), (Filter)filter);
                        query.setMaxFeatures(maxResults.intValue());
                        Iterator<ResultaatAttribuut> pit = zc.getResultaatVelden().iterator();
                        if (!pit.hasNext()) {
                            log.error((Object)("Geen resultaatvelden geconfigureerd voor zoekconfiguratie: " + zc.getNaam()));
                            startLocatie = null;
                            return startLocatie;
                        }
                        while (pit.hasNext()) {
                            ResultaatAttribuut pa = pit.next();
                            if (properties.contains(pa.getAttribuutLocalnaam())) continue;
                            properties.add(pa.getAttribuutLocalnaam());
                        }
                        if (log.isDebugEnabled()) {
                            FeatureType schema = fs.getSchema();
                            for (String prop : properties) {
                                PropertyDescriptor pd;
                                if (prop == null || schema == null || (pd = schema.getDescriptor(prop)) != null) continue;
                                log.debug((Object)("The property: '" + prop + "' that is configured " + "in the 'zoeker' is not available in the feature: " + zc.getFeatureType()));
                            }
                        }
                        query.setPropertyNames(properties);
                        SimpleFeatureSource fs2 = fs;
                        Integer count = null;
                        if (!(ds instanceof WFS_1_0_0_DataStore)) {
                            count = fs2.getCount((Query)query);
                        }
                        if (count != null && count < limit) {
                            limit = count;
                        }
                        boolean startIndexSupported = fs.getQueryCapabilities().isOffsetSupported();
                        if (usePagination && startIndexSupported) {
                            query.setSortBy(SortBy.UNSORTED);
                            query.setStartIndex(Integer.valueOf(startIndex));
                            query.setMaxFeatures(Math.min(limit + (startIndexSupported ? 0 : startIndex), maxResults));
                        }
                        fc = fs.getFeatures((Query)query);
                        fi = fc.features();
                        while (fi.hasNext()) {
                            Feature f = null;
                            try {
                                f = fi.next();
                            }
                            catch (Exception e) {
                                log.error((Object)("Error getting next feature, probably Oracle stumbling over null geometry: " + e.getLocalizedMessage()));
                                continue;
                            }
                            ZoekResultaat p = new ZoekResultaat();
                            for (ResultaatAttribuut ra : zc.getResultaatVelden()) {
                                if (f.getProperty(ra.getAttribuutLocalnaam()) != null) {
                                    Object value = f.getProperty(ra.getAttribuutLocalnaam()).getValue();
                                    ZoekResultaatAttribuut zra = new ZoekResultaatAttribuut(ra);
                                    zra.setWaarde(value);
                                    p.addAttribuut(zra);
                                    p.setZoekConfiguratie(zc);
                                    continue;
                                }
                                String attrTypes = "";
                                for (Property pr : f.getProperties()) {
                                    attrTypes = attrTypes + pr.getType().getName().getLocalPart() + " ";
                                }
                                log.debug((Object)("Attribuut: " + ra.toString() + " niet gevonden. Mogelijke attributen: " + attrTypes));
                            }
                            if (f.getType().getGeometryDescriptor() != null && f.getDefaultGeometryProperty() != null && f.getDefaultGeometryProperty().getBounds() != null) {
                                p.setBbox(f.getDefaultGeometryProperty().getBounds());
                            } else {
                                log.debug((Object)"Can't set Bbox for result. No bounds set for feature by the server. And no Geometry given or configured as result in the search configuration");
                            }
                            if (calculateDistance && locationWkt != null && !locationWkt.equals("")) {
                                Geometry locationGeom = this.createGeomFromWkt(locationWkt);
                                if (f.getType().getGeometryDescriptor() != null) {
                                    Geometry resultGeom = (Geometry)f.getDefaultGeometryProperty().getValue();
                                    double distance = this.calcDistance(locationGeom, resultGeom);
                                    p.addAttribuut(this.createAfstandResultaatAttribuut(distance, zc));
                                    p.setZoekConfiguratie(zc);
                                }
                            }
                            p.setCount(count);
                            if (zc.isResultListDynamic()) {
                                zoekResultaten.add(p);
                                continue;
                            }
                            boolean contains = this.containsResult(zoekResultaten, p);
                            if (contains) continue;
                            zoekResultaten.add(p);
                        }
                        break block54;
                    }
                    catch (SchemaNotFoundException snfe) {
                        String typenames = "";
                        String[] tn = ds.getTypeNames();
                        for (int i = 0; i < tn.length; ++i) {
                            if (typenames.length() != 0) {
                                typenames = typenames + "\n";
                            }
                            typenames = typenames + tn[i];
                        }
                        log.error((Object)("Feature " + zc.getFeatureType() + " niet bekend bij bron, mogelijke features: " + typenames), (Throwable)snfe);
                        break block54;
                    }
                    catch (Exception e) {
                        log.error((Object)"Fout tijdens het zoeken met een configuratie: ", (Throwable)e);
                        break block54;
                    }
                    finally {
                        if (fc != null && fi != null) {
                            fi.close();
                        }
                        if (ds != null) {
                            ds.dispose();
                        }
                    }
                }
                log.error((Object)"Kan geen datastore maken van bron");
            }
            catch (Exception ioe) {
                log.error((Object)"Fout bij laden van plannen: ", (Throwable)ioe);
            }
            finally {
                if (ds != null) {
                    ds.dispose();
                }
            }
        }
        Collections.sort(zoekResultaten);
        if (!zc.isResultListDynamic()) {
            ZoekConfiguratie.setCachedResultList(zc, zoekResultaten, searchStrings, maxResults);
            log.debug((Object)"Cache filled.");
        }
        return zoekResultaten;
    }

    private String getStartLocationFromSession() {
        HttpServletRequest request;
        HttpSession session;
        A11YResult a11yResult;
        String locationWkt = null;
        WebContext ctx = WebContextFactory.get();
        if (ctx != null && (a11yResult = (A11YResult)(session = (request = ctx.getHttpServletRequest()).getSession(true)).getAttribute("a11yResult")) != null) {
            locationWkt = a11yResult.getStartWkt();
            log.debug((Object)("Zoeker startlocatie: " + locationWkt));
        }
        return locationWkt;
    }

    private Integer getSearchRadiusFromSession() {
        Integer radius = null;
        WebContext ctx = WebContextFactory.get();
        if (ctx != null) {
            HttpServletRequest request = ctx.getHttpServletRequest();
            HttpSession session = request.getSession(true);
            radius = (Integer)session.getAttribute("defaultSearchRadius");
        }
        return radius;
    }

    private Geometry createGeomFromWkt(String wkt) {
        WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), 28992));
        Geometry geom = null;
        try {
            geom = wktreader.read(wkt);
        }
        catch (Exception e) {
            log.error((Object)"Fout bij parsen wkt geometry", (Throwable)e);
        }
        return geom;
    }

    private ZoekResultaatAttribuut createAfstandResultaatAttribuut(double distance, ZoekConfiguratie zc) {
        ResultaatAttribuut afstandAttr = new ResultaatAttribuut();
        afstandAttr.setLabel("afstand");
        afstandAttr.setAttribuutnaam("afstand");
        afstandAttr.setType(2);
        afstandAttr.setVolgorde(9999);
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        String waarde = twoDForm.format(distance /= 1000.0);
        if (waarde.contains(",")) {
            waarde = waarde.replace(",", ".");
        }
        ZoekResultaatAttribuut zra = new ZoekResultaatAttribuut(afstandAttr);
        zra.setWaarde(waarde + " km");
        return zra;
    }

    private double calcDistance(Geometry geom1, Geometry geometry2) {
        double distance = -1.0;
        if (geom1 == null || geometry2 == null) {
            return distance;
        }
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:28992");
            Coordinate start = new Coordinate(geom1.getCentroid().getX(), geom1.getCentroid().getY());
            Coordinate end = new Coordinate(geometry2.getCentroid().getX(), geometry2.getCentroid().getY());
            if (start != null && end != null) {
                distance = JTS.orthodromicDistance((Coordinate)start, (Coordinate)end, (CoordinateReferenceSystem)crs);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error calculatin distance: ", (Throwable)ex);
        }
        return distance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getZoekConfiguraties() {
        Object identity = null;
        List returnList = null;
        try {
            identity = MyEMFDatabase.createEntityManager("zoekerMainEM");
            EntityManager em = MyEMFDatabase.getEntityManager("zoekerMainEM");
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            try {
                returnList = em.createQuery("from ZoekConfiguratie z LEFT JOIN FETCH z.zoekVelden LEFT JOIN FETCH z.resultaatVelden LEFT JOIN FETCH z.parentBron ORDER BY z.naam DESC").getResultList();
                tx.commit();
            }
            catch (Exception ex) {
                log.error((Object)("Exception occured" + (tx.isActive() ? ", rollback" : "tx not active")), (Throwable)ex);
                if (tx.isActive()) {
                    tx.rollback();
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)"Exception occured in search: ", e);
        }
        finally {
            log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager(identity, "zoekerMainEM");
        }
        return new ArrayList(new HashSet(returnList));
    }

    protected boolean containsResult(List<ZoekResultaat> zoekResultaten, ZoekResultaat p) {
        for (ZoekResultaat zoekresultaat : zoekResultaten) {
            if (zoekresultaat.getId() == null || p.getId() == null || !zoekresultaat.getId().equals(p.getId())) continue;
            return true;
        }
        return false;
    }

    public static DataStore getDataStore(Bron b) throws IOException, Exception {
        return b.toDatastore();
    }

    private Filter createFilter(ZoekAttribuut[] zoekVelden, String[] searchStrings, int index, DataStore ds, FilterFactory2 ff, FeatureType ft) throws Exception {
        String searchString = searchStrings[index];
        Integer searchRadius = null;
        String startLocatie = null;
        ZoekAttribuut zoekVeld = zoekVelden[index];
        if (zoekVeld.getType() == 110) {
            startLocatie = this.getStartLocationFromSession();
            searchRadius = this.getSearchRadiusFromSession();
            if (startLocatie != null) {
                searchString = startLocatie;
            }
        }
        if (searchString == null || searchString.length() == 0) {
            return null;
        }
        Object filter = null;
        if (zoekVeld.getType() == 3 || zoekVeld.getType() == 110) {
            WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), 28992));
            try {
                Geometry geom = wktreader.read(searchString);
                Double straal = null;
                for (int i = 0; i < zoekVelden.length; ++i) {
                    if (i == index || zoekVelden[i].getType() != 100 || searchStrings[i] == null || searchStrings[i].length() <= 0) continue;
                    try {
                        straal = Double.parseDouble(searchStrings[i]);
                        geom = geom.buffer(straal.doubleValue());
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        log.error((Object)("Ingevulde zoekopdracht " + zoekVelden[i].getNaam() + "moet een nummer zijn"), (Throwable)nfe);
                    }
                }
                if (straal != null && straal > 0.0) {
                    filter = ff.within((Expression)ff.property(zoekVeld.getAttribuutnaam()), (Expression)ff.literal((Object)geom));
                }
                if (straal == null && searchRadius != null && searchRadius > 0 && startLocatie != null) {
                    geom = geom.buffer((double)searchRadius.intValue());
                    filter = ff.within((Expression)ff.property(zoekVeld.getAttribuutnaam()), (Expression)ff.literal((Object)geom));
                    log.debug((Object)("Using the default search radius of " + searchRadius));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout bij parsen wkt geometry", (Throwable)e);
            }
        } else if (zoekVeld.getType() == 5) {
            filter = ff.greaterOrEqual((Expression)ff.property(zoekVeld.getAttribuutnaam()), (Expression)ff.literal((Object)searchString));
        } else if (zoekVeld.getType() == 4) {
            filter = ff.lessOrEqual((Expression)ff.property(zoekVeld.getAttribuutnaam()), (Expression)ff.literal((Object)searchString));
        } else if (zoekVeld.getType() == 50) {
            filter = ff.greaterOrEqual((Expression)ff.property(zoekVeld.getAttribuutnaam()), (Expression)ff.literal((Object)searchString));
        } else if (zoekVeld.getType() == 40) {
            filter = ff.lessOrEqual((Expression)ff.property(zoekVeld.getAttribuutnaam()), (Expression)ff.literal((Object)searchString));
        } else if (zoekVeld.getType() == 6) {
            filter = ff.equals((Expression)ff.property(zoekVeld.getAttribuutnaam()), (Expression)ff.literal((Object)searchString));
        } else if (zoekVeld.isFilterMogelijk()) {
            String[] orStrings = searchString.split("\\|");
            ArrayList<PropertyIsLike> orFilters = new ArrayList<PropertyIsLike>();
            for (int i = 0; i < orStrings.length; ++i) {
                Object f = null;
                String sString = orStrings[i];
                if (ds instanceof WFS_1_0_0_DataStore) {
                    f = ft != null && zoekVeld != null && this.propertyIsNumber(ft.getDescriptor(zoekVeld.getAttribuutnaam())) ? ff.equals((Expression)ff.property(zoekVeld.getAttribuutnaam()), (Expression)ff.literal((Object)sString)) : ff.like((Expression)ff.property(zoekVeld.getAttribuutnaam()), sString);
                } else if (sString.length() > 0) {
                    f = this.propertyIsNumber(ft.getDescriptor(zoekVeld.getAttribuutnaam())) ? ff.equals((Expression)ff.property(zoekVeld.getAttribuutnaam()), (Expression)ff.literal((Object)sString)) : ff.like((Expression)ff.property(zoekVeld.getAttribuutnaam()), sString, "*", "?", "\\", false);
                }
                orFilters.add((PropertyIsLike)f);
            }
            filter = orFilters.size() == 1 ? (Filter)orFilters.get(0) : ff.or(orFilters);
        }
        return filter;
    }

    private boolean propertyIsNumber(PropertyDescriptor descriptor) {
        if (descriptor == null || descriptor.getType() == null || descriptor.getType().getBinding() == null) {
            return false;
        }
        return descriptor.getType().getBinding() == Integer.class || descriptor.getType().getBinding() == Double.class || descriptor.getType().getBinding() == BigInteger.class;
    }

    private ZoekResultaat getXYZoekResultaat(ZoekConfiguratie zc, String[] searchStrings) {
        try {
            String wkt;
            Geometry geom;
            String[] coords;
            WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), 28992));
            if (searchStrings != null && searchStrings.length > 0 && (coords = searchStrings[searchStrings.length - 1].split(",")) != null && coords.length == 2 && (geom = wktreader.read(wkt = "POINT(" + coords[0] + " " + coords[1] + ")")) != null) {
                ResultaatAttribuut raToon = new ResultaatAttribuut();
                ZoekResultaatAttribuut zra = new ZoekResultaatAttribuut(raToon);
                zra.setType(-1);
                zra.setLabel("xy");
                String waarde = "Zoom naar (" + coords[0] + " " + coords[1] + ")";
                zra.setWaarde(waarde);
                ZoekResultaat zrGeom = new ZoekResultaat();
                zrGeom.addAttribuut(zra);
                zrGeom.setZoekConfiguratie(zc);
                int bufferSize = 50;
                Envelope env = geom.getEnvelopeInternal();
                zrGeom.setMinx(env.getMinX() - (double)bufferSize);
                zrGeom.setMiny(env.getMinY() + (double)bufferSize);
                zrGeom.setMaxx(env.getMaxX() + (double)bufferSize);
                zrGeom.setMaxy(env.getMaxY() - (double)bufferSize);
                return zrGeom;
            }
        }
        catch (Exception e) {
            log.error((Object)"Fout tijdens omzetten XY zoekopdracht naar een zoekresultaat: ", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZoekConfiguratie getZoekConfiguratie(Integer id) {
        Object identity = null;
        ZoekConfiguratie zc = null;
        try {
            identity = MyEMFDatabase.createEntityManager("zoekerMainEM");
            EntityManager em = MyEMFDatabase.getEntityManager("zoekerMainEM");
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            try {
                zc = (ZoekConfiguratie)em.find(ZoekConfiguratie.class, (Object)id);
                tx.commit();
            }
            catch (Exception ex) {
                log.error((Object)("Exception occured" + (tx.isActive() ? ", rollback" : "tx not active")), (Throwable)ex);
                if (tx.isActive()) {
                    tx.rollback();
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)"Exception occured in search: ", e);
        }
        finally {
            log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager(identity, "zoekerMainEM");
        }
        return zc;
    }
}

