/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.zoeker.configuratie;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import nl.b3p.zoeker.configuratie.Attribuut;
import nl.b3p.zoeker.configuratie.Bron;
import nl.b3p.zoeker.configuratie.ZoekConfiguratie;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.Feature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ZoekAttribuut
extends Attribuut {
    public static final int SELECT_CONTROL = 1;
    public static final int TEXT_CONTROL = 2;
    public static final int RADIO_CONTROL = 3;
    public static final int TEXTAREA_CONTROL = 4;
    private Integer inputtype = 2;
    private Integer inputsize = 0;
    private ZoekConfiguratie inputzoekconfiguratie = null;
    static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());

    public ZoekAttribuut() {
    }

    public ZoekAttribuut(Integer id, String naam, String attribuutnaam, String label, Integer type, Integer volgorde) {
        super(id, naam, attribuutnaam, label, type, volgorde, null, null);
    }

    public ZoekAttribuut(Integer id, String naam, String attribuutnaam, String label, Integer type, Integer volgorde, String omschrijving) {
        super(id, naam, attribuutnaam, label, type, volgorde, omschrijving, null);
    }

    public ZoekAttribuut(Integer id, String naam, String attribuutnaam, String label, Integer type, Integer volgorde, String omschrijving, String dropDownValues) {
        super(id, naam, attribuutnaam, label, type, volgorde, omschrijving, dropDownValues);
    }

    public static ZoekAttribuut[] setToZoekVeldenArray(Set set) {
        return set.toArray(new ZoekAttribuut[set.size()]);
    }

    public boolean isFilterMogelijk() {
        if (this.getType() == null) {
            return true;
        }
        return this.getType() < 100;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.getId());
        json.put("naam", (Object)this.getNaam());
        json.put("attribuutnaam", (Object)this.getAttribuutLocalnaam());
        json.put("label", (Object)this.getLabel());
        json.put("type", (Object)this.getType());
        json.put("volgorde", (Object)this.getVolgorde());
        json.put("inputType", (Object)this.getInputtype());
        json.put("inputSize", (Object)this.getInputsize());
        json.put("dropDownValues", (Object)this.getDropDownValues());
        if (this.getInputzoekconfiguratie() != null) {
            json.put("inputZoekConfiguratie", (Object)this.getInputzoekconfiguratie().getId());
        }
        return json;
    }

    public Integer getInputsize() {
        return this.inputsize;
    }

    public void setInputsize(Integer inputsize) {
        this.inputsize = inputsize;
    }

    public Integer getInputtype() {
        return this.inputtype;
    }

    public void setInputtype(Integer inputtype) {
        this.inputtype = inputtype;
    }

    public ZoekConfiguratie getInputzoekconfiguratie() {
        return this.inputzoekconfiguratie;
    }

    public void setInputzoekconfiguratie(ZoekConfiguratie inputzoekconfiguratie) {
        this.inputzoekconfiguratie = inputzoekconfiguratie;
    }

    public static void main(String[] args) throws IOException, Exception {
        Bron b = new Bron(0, "buurten", "jdbc:postgresql://x5.b3p.nl:5432/demo_kaartenbalie", "postgres", "xxxxxx", 0);
        DataStore ds = b.toDatastore();
        String featureTypeName = "buurt_2006_cbs";
        String attributeName = "gm_naam";
        String sortAttributeName = "bu_naam";
        String geomAttributeName = "the_geom";
        ArrayList<String> propNames = new ArrayList<String>();
        propNames.add(attributeName);
        SimpleFeatureSource fs = ds.getFeatureSource(featureTypeName);
        QueryCapabilities qc = fs.getQueryCapabilities();
        HashSet uniqueValues = new HashSet();
        Filter filter = null;
        DefaultQuery query = null;
        SortBy[] sortBy1 = new SortBy[]{ff.sort(sortAttributeName, SortOrder.ASCENDING)};
        SortBy[] sortBy2 = new SortBy[]{ff.sort(sortAttributeName, SortOrder.DESCENDING)};
        if (qc != null && qc.supportsSorting(sortBy1)) {
            System.out.println("sorting supported");
        }
        if (qc != null && qc.isOffsetSupported()) {
            System.out.println("offset supported");
        }
        int minx = 21000;
        int maxx = 283000;
        int miny = 357000;
        int maxy = 615000;
        int aantalSegmenten = 3;
        int max = 100;
        int deltax = (maxx - minx) / aantalSegmenten;
        int deltay = (maxy - miny) / aantalSegmenten;
        int loopNum = 0;
        for (int xloop = 0; xloop < aantalSegmenten; ++xloop) {
            int minxLoop = minx + xloop * deltax;
            int maxxLoop = minxLoop + deltax;
            for (int yloop = 0; yloop < aantalSegmenten; ++yloop) {
                int minyLoop = miny + yloop * deltay;
                int maxyLoop = minyLoop + deltay;
                try {
                    Thread.currentThread();
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                BBOX geomFilter = null;
                if (aantalSegmenten > 0) {
                    CoordinateReferenceSystem crs = ds.getSchema(featureTypeName).getGeometryDescriptor().getCoordinateReferenceSystem();
                    ReferencedEnvelope bbox = new ReferencedEnvelope((double)minxLoop, (double)maxxLoop, (double)minyLoop, (double)maxyLoop, crs);
                    geomFilter = ff.bbox((Expression)ff.property(geomAttributeName), (BoundingBox)bbox);
                }
                HashSet<String> uniqueValuesLoop = new HashSet<String>();
                boolean found = false;
                do {
                    block16: {
                        ++loopNum;
                        found = false;
                        if (uniqueValuesLoop != null && uniqueValuesLoop.size() > 0) {
                            String[] values = uniqueValuesLoop.toArray(new String[uniqueValuesLoop.size()]);
                            filter = ZoekAttribuut.createAndNotEqualsFilter(attributeName, values);
                            query = new DefaultQuery(featureTypeName, ZoekAttribuut.createAndFilter(filter, (Filter)geomFilter));
                        } else {
                            query = new DefaultQuery(featureTypeName, ZoekAttribuut.createAndFilter(null, geomFilter));
                        }
                        query.setMaxFeatures(max);
                        query.setPropertyNames(propNames);
                        if (loopNum % 2 == 0) {
                            query.setSortBy(sortBy1);
                        } else {
                            query.setSortBy(sortBy2);
                        }
                        FeatureCollection fc = fs.getFeatures((Query)query);
                        FeatureIterator fi = fc.features();
                        try {
                            while (fi.hasNext()) {
                                Feature f = fi.next();
                                String v = (String)f.getProperty(attributeName).getValue();
                                if (v == null) continue;
                                v = v.trim();
                                System.out.println("gemeente  " + v);
                                if (uniqueValuesLoop.contains(v)) continue;
                                found = true;
                                uniqueValuesLoop.add(v);
                                System.out.println("nieuwe gemeente  " + v);
                            }
                        }
                        catch (Exception e) {
                            System.out.println("xxxxxx");
                            String mapserver4Hack = "msQueryByRect(): Search returned no results. No matching record(s) found.";
                            String message = e.getMessage();
                            if (message != null && message.contains(mapserver4Hack)) break block16;
                            throw e;
                        }
                    }
                    System.out.println("-------");
                } while (found);
                uniqueValues.addAll(uniqueValuesLoop);
            }
            System.out.println("!!!!!!!! aantal: " + uniqueValues.size());
        }
        for (String uv : uniqueValues) {
            System.out.println(uv);
        }
        System.out.println("++++++++++++++ aantal: " + uniqueValues.size());
        System.out.println("++++++++++++++ loop num: " + loopNum);
    }

    public static Filter createAndNotEqualsFilter(String key, String[] values) {
        ArrayList<PropertyIsEqualTo> filters = new ArrayList<PropertyIsEqualTo>();
        PropertyName pn = ff.property(key);
        for (int i = 0; i < values.length; ++i) {
            String val = values[i];
            if (val == null) continue;
            if (val.contains("'")) {
                val = val.replaceAll("'", "\\'");
            }
            filters.add(ff.equals((Expression)pn, (Expression)ff.literal((Object)val)));
        }
        if (filters.size() == 1) {
            return ff.not((Filter)filters.get(0));
        }
        if (filters.size() > 1) {
            return ff.not((Filter)ff.or(filters));
        }
        return null;
    }

    public static Filter createAndFilter(Filter f1, Filter f2) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (f1 != null) {
            filters.add(f1);
        }
        if (f2 != null) {
            filters.add(f2);
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        if (filters.size() > 1) {
            return ff.and(filters);
        }
        return null;
    }
}

