/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bag2.loader;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.ResourceBundle;

public class BAG2LoaderUtils {
    public static final String BUNDLE_NAME = "BAG2Loader";
    static final ResourceBundle bundle = ResourceBundle.getBundle("BAG2Loader");

    public static String getUserAgent() {
        return String.format("%s, %s (%s)/%s, %s/%s", BAG2LoaderUtils.getBundleString("app.user-agent"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"));
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }

    public static String getBundleString(String key) {
        return bundle.getString(key);
    }

    public static String getMessageFormattedString(String key, Object ... args) {
        ResourceBundle bundle = BAG2LoaderUtils.getBundle();
        return new MessageFormat(bundle.getString(key), bundle.getLocale()).format(args);
    }

    public static String getLoaderVersion() {
        return BAG2LoaderUtils.getBundleString("app.version");
    }

    public static String getBrmoVersion() {
        return BAG2LoaderUtils.getBundleString("brmo.version");
    }

    public static BAG2FileName analyzeBAG2FileName(String name) throws IllegalArgumentException {
        LocalDate mutatiesFrom;
        if (name.startsWith("http://") || name.startsWith("https://")) {
            URI uri = URI.create(name);
            String[] parts = uri.getPath().split("/");
            name = parts[parts.length - 1];
        }
        if (name.contains(File.separator)) {
            Path p = Path.of(name, new String[0]);
            name = p.getFileName().toString();
        }
        if (name.equals("lvbag-extract-nl.zip") || name.matches("BAGNLDL-\\d{8}\\.zip")) {
            return new BAG2FileName(name, true, false, false);
        }
        if (name.matches("BAGGEM\\d{4}L-\\d{8}\\.zip")) {
            return new BAG2FileName(name, true, true, false, name.substring(6, 10));
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyy");
        if (name.matches("BAGGEM\\d{4}M-\\d{8}-\\d{8}\\.zip")) {
            mutatiesFrom = LocalDate.parse(name.substring(12, 20), dtf);
            LocalDate mutatiesTo = LocalDate.parse(name.substring(21, 29), dtf);
            return new BAG2FileName(name, false, true, true, name.substring(6, 10), mutatiesFrom, mutatiesTo);
        }
        if (name.matches("BAGNLDM-\\d{8}-\\d{8}\\.zip")) {
            LocalDate mutatiesTo;
            mutatiesFrom = LocalDate.parse(name.substring(8, 16), dtf);
            long days = ChronoUnit.DAYS.between(mutatiesFrom, mutatiesTo = LocalDate.parse(name.substring(17, 25), dtf));
            return new BAG2FileName(name, false, false, days > 1L, null, mutatiesFrom, mutatiesTo);
        }
        throw new IllegalArgumentException("Ongeldige BAG2 bestandsnaam: " + name);
    }

    public static class BAG2FileName {
        private String name;
        private boolean isStand;
        private boolean isGemeente;
        private boolean isMaandmutaties;
        private String gemeenteCode;
        private LocalDate mutatiesFrom;
        private LocalDate mutatiesTo;

        public BAG2FileName(String name, boolean isStand, boolean isGemeente, boolean isMaandmutaties) {
            this(name, isStand, isGemeente, isMaandmutaties, null, null, null);
        }

        public BAG2FileName(String name, boolean isStand, boolean isGemeente, boolean isMaandmutaties, String gemeenteCode) {
            this(name, isStand, isGemeente, isMaandmutaties, gemeenteCode, null, null);
        }

        public BAG2FileName(String name, boolean isStand, boolean isGemeente, boolean isMaandmutaties, String gemeenteCode, LocalDate mutatiesFrom, LocalDate mutatiesTo) {
            this.name = name;
            this.isStand = isStand;
            this.isGemeente = isGemeente;
            this.isMaandmutaties = isMaandmutaties;
            this.gemeenteCode = gemeenteCode;
            this.mutatiesFrom = mutatiesFrom;
            this.mutatiesTo = mutatiesTo;
        }

        public String getName() {
            return this.name;
        }

        public boolean isStand() {
            return this.isStand;
        }

        public boolean isGemeente() {
            return this.isGemeente;
        }

        public boolean isMaandmutaties() {
            return this.isMaandmutaties;
        }

        public String getGemeenteCode() {
            return this.gemeenteCode;
        }

        public LocalDate getMutatiesFrom() {
            return this.mutatiesFrom;
        }

        public LocalDate getMutatiesTo() {
            return this.mutatiesTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BAG2FileName that = (BAG2FileName)o;
            return this.isStand == that.isStand && this.isGemeente == that.isGemeente && this.isMaandmutaties == that.isMaandmutaties && this.name.equals(that.name) && Objects.equals(this.gemeenteCode, that.gemeenteCode) && Objects.equals(this.mutatiesFrom, that.mutatiesFrom) && Objects.equals(this.mutatiesTo, that.mutatiesTo);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.isStand, this.isGemeente, this.isMaandmutaties, this.gemeenteCode, this.mutatiesFrom, this.mutatiesTo);
        }

        public String toString() {
            return "BAG2FileName{name='" + this.name + "', isStand=" + this.isStand + ", isGemeente=" + this.isGemeente + ", isMaandmutaties=" + this.isMaandmutaties + ", gemeenteCode='" + this.gemeenteCode + "', mutatiesFrom=" + this.mutatiesFrom + ", mutatiesTo=" + this.mutatiesTo + "}";
        }
    }
}

