/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bag2.loader;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import nl.b3p.brmo.bag2.loader.BAG2LoaderUtils;
import nl.b3p.brmo.bag2.loader.cli.BAG2DatabaseOptions;
import nl.b3p.brmo.bag2.loader.cli.BAG2LoadOptions;
import nl.b3p.brmo.bag2.schema.BAG2ObjectTableWriter;
import nl.b3p.brmo.bag2.schema.BAG2SchemaMapper;
import nl.b3p.brmo.sql.LoggingQueryRunner;
import nl.b3p.brmo.sql.dialect.MSSQLDialect;
import nl.b3p.brmo.sql.dialect.OracleDialect;
import nl.b3p.brmo.sql.dialect.PostGISDialect;
import nl.b3p.brmo.sql.dialect.SQLDialect;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BAG2Database
implements AutoCloseable {
    private static final Log LOG = LogFactory.getLog(BAG2Database.class);
    private SQLDialect dialect;
    private final BAG2DatabaseOptions dbOptions;
    private Connection connection;
    private final boolean allowConnectionCreation;

    public BAG2Database(BAG2DatabaseOptions dbOptions) throws ClassNotFoundException {
        this.dbOptions = dbOptions;
        this.dialect = BAG2Database.createDialect(dbOptions.getConnectionString());
        this.dialect.loadDriver();
        this.allowConnectionCreation = true;
    }

    public BAG2Database(BAG2DatabaseOptions dbOptions, Connection connection) throws SQLException {
        this.dbOptions = dbOptions;
        this.connection = connection;
        this.dialect = BAG2Database.createDialect(connection.getMetaData().getURL());
        this.allowConnectionCreation = false;
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(SQLDialect dialect) {
        this.dialect = dialect;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.createConnection();
        }
        if (this.dialect instanceof PostGISDialect) {
            new QueryRunner().update(this.connection, "create schema if not exists bag");
            new QueryRunner().update(this.connection, "set search_path=bag,public");
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    private Connection createConnection() {
        if (!this.allowConnectionCreation) {
            throw new RuntimeException("New connection required but supplied connection is null or closed");
        }
        try {
            return DriverManager.getConnection(this.dbOptions.getConnectionString(), this.dbOptions.getUser(), this.dbOptions.getPassword());
        }
        catch (SQLException e) {
            throw new RuntimeException(BAG2LoaderUtils.getMessageFormattedString("db.connection_error", this.dbOptions.getConnectionString()), e);
        }
    }

    public BAG2ObjectTableWriter createObjectTableWriter(BAG2LoadOptions loadOptions, BAG2DatabaseOptions dbOptions) throws SQLException {
        BAG2ObjectTableWriter writer = new BAG2ObjectTableWriter(this.getConnection(), this.getDialect(), BAG2SchemaMapper.getInstance());
        if (loadOptions == null) {
            loadOptions = new BAG2LoadOptions();
        }
        writer.setBatchSize(dbOptions.getBatchSize() != null ? dbOptions.getBatchSize().intValue() : this.getDialect().getDefaultOptimalBatchSize());
        writer.setMultithreading(loadOptions.isMultithreading());
        writer.setUsePgCopy(dbOptions.isUsePgCopy());
        writer.setObjectLimit(loadOptions.getMaxObjects());
        writer.setIgnoreDuplicates(loadOptions.isIgnoreDuplicates());
        writer.setDropIfExists(loadOptions.isDropIfExists());
        return writer;
    }

    public static SQLDialect createDialect(String connectionString) {
        SQLDialectEnum sqlDialectEnum;
        if (connectionString.startsWith("jdbc:postgresql:")) {
            sqlDialectEnum = SQLDialectEnum.postgis;
        } else if (connectionString.startsWith("jdbc:oracle:thin:")) {
            sqlDialectEnum = SQLDialectEnum.oracle;
        } else if (connectionString.startsWith("jdbc:sqlserver:")) {
            sqlDialectEnum = SQLDialectEnum.mssql;
        } else {
            throw new IllegalArgumentException(BAG2LoaderUtils.getMessageFormattedString("db.unknown_connection_string_dialect", connectionString));
        }
        return BAG2Database.createDialect(sqlDialectEnum);
    }

    public static SQLDialect createDialect(SQLDialectEnum dialectEnum) {
        switch (dialectEnum) {
            case postgis: {
                return new PostGISDialect();
            }
            case oracle: {
                return new OracleDialect();
            }
            case mssql: {
                return new MSSQLDialect();
            }
        }
        throw new IllegalArgumentException(BAG2LoaderUtils.getMessageFormattedString("db.dialect_invalid", new Object[]{dialectEnum}));
    }

    public void createMetadataTable(BAG2LoadOptions loadOptions) throws SQLException {
        LOG.info((Object)BAG2LoaderUtils.getBundleString("db.create_metadata"));
        for (String sql : BAG2SchemaMapper.getInstance().getCreateMetadataTableStatements(this.getDialect(), "", loadOptions.isDropIfExists())) {
            new LoggingQueryRunner().update(this.getConnection(), sql);
        }
    }

    public String getMetadata(BAG2SchemaMapper.Metadata key) throws SQLException {
        Object value = new LoggingQueryRunner().query(this.getConnection(), "select waarde from brmo_metadata where naam = ?", (ResultSetHandler)new ScalarHandler(), new Object[]{key.getDbKey()});
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return clob.getSubString(1L, (int)clob.length());
        }
        return value.toString();
    }

    public void setMetadataValue(BAG2SchemaMapper.Metadata key, String value) throws Exception {
        try {
            int updated = new LoggingQueryRunner().update(this.getConnection(), "update brmo_metadata set waarde = ? where naam = ?", new Object[]{value, key.getDbKey()});
            if (updated == 0) {
                new LoggingQueryRunner().update(this.getConnection(), "insert into brmo_metadata(naam, waarde) values(?,?)", new Object[]{key.getDbKey(), value});
            }
        }
        catch (SQLException e) {
            throw new Exception(BAG2LoaderUtils.getMessageFormattedString("db.metadata_error", key.getDbKey(), value, e.getMessage()), e);
        }
    }

    public LocalDate getCurrentTechnischeDatum() throws SQLException {
        String s = this.getMetadata(BAG2SchemaMapper.Metadata.CURRENT_TECHNISCHE_DATUM);
        if (s == null) {
            throw new IllegalStateException("Geen huidige BAG2 stand ingeladen");
        }
        return LocalDate.parse(s, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public Set<String> getGemeenteCodes() throws SQLException {
        String s = this.getMetadata(BAG2SchemaMapper.Metadata.GEMEENTE_CODES);
        if (s == null) {
            throw new IllegalStateException("Geen huidige BAG2 stand voor gemeentes ingeladen");
        }
        return Arrays.stream(s.split(",")).collect(Collectors.toSet());
    }

    public static enum SQLDialectEnum {
        postgis,
        oracle,
        mssql;

    }
}

