/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bag2.schema;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.b3p.brmo.bag2.loader.BAG2LoaderUtils;
import nl.b3p.brmo.bag2.schema.BAG2Schema;
import nl.b3p.brmo.schema.Schema;
import nl.b3p.brmo.schema.SchemaSQLMapper;
import nl.b3p.brmo.sql.dialect.SQLDialect;

public class BAG2SchemaMapper
extends SchemaSQLMapper {
    private static BAG2SchemaMapper instance;
    private static final String SCHEMA_VERSION_VALUE = "1";
    public static final String METADATA_TABLE_NAME = "brmo_metadata";

    public BAG2SchemaMapper() {
        super((Schema)BAG2Schema.getInstance());
    }

    public static BAG2SchemaMapper getInstance() {
        if (instance == null) {
            instance = new BAG2SchemaMapper();
        }
        return instance;
    }

    public String getMetadataTableName() {
        return METADATA_TABLE_NAME;
    }

    public List<String> getCreateMetadataTableStatements(SQLDialect dialect, String tablePrefix, boolean dropIfExists) {
        List statements = super.getCreateMetadataTableStatements(dialect, tablePrefix, dropIfExists);
        Map<Metadata, String> defaultMetadata = Stream.of({Metadata.SCHEMA_VERSION, SCHEMA_VERSION_VALUE}, {Metadata.LOADER_VERSION, BAG2LoaderUtils.getLoaderVersion()}).collect(Collectors.toMap(entry -> (Metadata)((Object)((Object)entry[0])), entry -> (String)entry[1]));
        Stream.of(Metadata.values()).forEach(metadata -> {
            String value = (String)defaultMetadata.get(metadata);
            statements.add(String.format("insert into %s (naam, waarde) values ('%s', %s)", this.getMetadataTableName(), metadata.getDbKey(), value == null ? "null" : "'" + value + "'"));
        });
        return statements;
    }

    public static enum Metadata {
        SCHEMA_VERSION,
        LOADER_VERSION,
        STAND_LOAD_TIME,
        STAND_LOAD_TECHNISCHE_DATUM,
        CURRENT_TECHNISCHE_DATUM,
        GEMEENTE_CODES,
        FILTER_MUTATIES_WOONPLAATS;


        public String getDbKey() {
            return "bag2_" + this.name().toLowerCase();
        }
    }
}

