/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bag2.loader.cli;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.b3p.brmo.bag2.loader.BAG2Database;
import nl.b3p.brmo.bag2.loader.BAG2GMLMutatieGroepStream;
import nl.b3p.brmo.bag2.loader.BAG2LoaderUtils;
import nl.b3p.brmo.bag2.loader.BAG2ProgressReporter;
import nl.b3p.brmo.bag2.loader.cli.BAG2ConsoleProgressReporter;
import nl.b3p.brmo.bag2.loader.cli.BAG2DatabaseOptions;
import nl.b3p.brmo.bag2.loader.cli.BAG2LoadOptions;
import nl.b3p.brmo.bag2.loader.cli.BAG2MutatiesCommand;
import nl.b3p.brmo.bag2.loader.cli.BAG2ProgressOptions;
import nl.b3p.brmo.bag2.schema.BAG2ObjectTableWriter;
import nl.b3p.brmo.bag2.schema.BAG2ObjectType;
import nl.b3p.brmo.bag2.schema.BAG2Schema;
import nl.b3p.brmo.bag2.schema.BAG2SchemaMapper;
import nl.b3p.brmo.bgt.loader.Utils;
import nl.b3p.brmo.util.ResumingInputStream;
import nl.b3p.brmo.util.http.HttpClientWrapper;
import nl.b3p.brmo.util.http.HttpStartRangeInputStreamProvider;
import nl.b3p.brmo.util.http.wrapper.Java11HttpClientWrapper;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.geotools.util.logging.Logging;
import picocli.CommandLine;

@CommandLine.Command(name="bag2-loader", mixinStandardHelpOptions=true, versionProvider=BAG2LoaderMain.class, resourceBundle="BAG2Loader", subcommands={BAG2MutatiesCommand.class})
public class BAG2LoaderMain
implements CommandLine.IVersionProvider {
    private static Log log;
    private BAG2Database bag2Database = null;
    private Set<BAG2ObjectType> objectTypesWithSchemaCreated = new HashSet<BAG2ObjectType>();
    private Map<BAG2ObjectType, Set<Pair<Object, Object>>> keysPerObjectType = new HashMap<BAG2ObjectType, Set<Pair<Object, Object>>>();

    public static void configureLogging(boolean standAlone) {
        if (standAlone) {
            PropertyConfigurator.configure((InputStream)BAG2LoaderMain.class.getResourceAsStream("/bag2-loader-cli-log4j.properties"));
            log = LogFactory.getLog(BAG2LoaderMain.class);
            try {
                Logging.ALL.setLoggerFactory("org.geotools.util.logging.Log4JLoggerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            log = LogFactory.getLog(BAG2LoaderMain.class);
        }
    }

    public static void main(String ... args) {
        BAG2LoaderMain.configureLogging(true);
        CommandLine cmd = new CommandLine((Object)new BAG2LoaderMain()).setUsageHelpAutoWidth(true);
        System.exit(cmd.execute(args));
    }

    public String[] getVersion() {
        return new String[]{BAG2LoaderUtils.getLoaderVersion(), BAG2LoaderUtils.getUserAgent()};
    }

    @CommandLine.Command(name="load", sortOptions=false)
    public int load(@CommandLine.Mixin BAG2DatabaseOptions dbOptions, @CommandLine.Mixin BAG2LoadOptions loadOptions, @CommandLine.Mixin BAG2ProgressOptions progressOptions, @CommandLine.Parameters(paramLabel="<file>") String[] filenames, @CommandLine.Option(names={"-h", "--help"}, usageHelp=true) boolean showHelp) throws Exception {
        log.info((Object)BAG2LoaderUtils.getUserAgent());
        try (BAG2Database db = this.getBAG2Database(dbOptions);){
            BAG2ProgressReporter progressReporter = progressOptions.isConsoleProgressEnabled() ? new BAG2ConsoleProgressReporter() : new BAG2ProgressReporter();
            this.loadFiles(db, dbOptions, loadOptions, progressReporter, filenames, null);
            int n = 0;
            return n;
        }
    }

    public BAG2Database getBAG2Database(BAG2DatabaseOptions dbOptions) throws ClassNotFoundException {
        if (this.bag2Database == null) {
            this.bag2Database = new BAG2Database(dbOptions);
        }
        return this.bag2Database;
    }

    public void setBag2Database(BAG2Database bag2Database) {
        this.bag2Database = bag2Database;
    }

    public void loadFiles(BAG2Database db, BAG2DatabaseOptions dbOptions, BAG2LoadOptions loadOptions, BAG2ProgressReporter progressReporter, String[] filenames, CookieManager cookieManager) throws Exception {
        if (filenames.length == 1 && Files.isDirectory(Path.of(filenames[0], new String[0]), new LinkOption[0])) {
            log.info((Object)"Directory opgegeven, kijken naar toepasbare mutaties...");
            filenames = (String[])Files.list(Path.of(filenames[0], new String[0])).filter(p -> !Files.isDirectory(p, new LinkOption[0]) && p.getFileName().toString().endsWith(".zip")).map(p -> p.toAbsolutePath().toString()).toArray(String[]::new);
            if (filenames.length == 0) {
                log.info((Object)"Geen ZIP bestanden gevonden, niets te doen");
            } else {
                this.applyMutaties(db, dbOptions, loadOptions, progressReporter, filenames, null);
            }
            return;
        }
        BAG2LoaderUtils.BAGExtractSelectie bagExtractLevering = BAG2LoaderUtils.getBAGExtractSelectieFromZip(filenames[0]);
        if (bagExtractLevering.isStand()) {
            if (bagExtractLevering.isGebiedNLD()) {
                if (filenames.length > 1) {
                    throw new IllegalArgumentException("Inladen stand heel Nederland: teveel bestanden opgegeven");
                }
            } else {
                HashSet<String> gemeenteCodes = new HashSet<String>();
                for (int i = 1; i < filenames.length; ++i) {
                    BAG2LoaderUtils.BAGExtractSelectie nextBagExtractLevering = BAG2LoaderUtils.getBAGExtractSelectieFromZip(filenames[i]);
                    if (!nextBagExtractLevering.isStand() || nextBagExtractLevering.isGebiedNLD()) {
                        throw new IllegalArgumentException("Inladen stand gemeentes, ongeldig bestand opgegeven (geen gemeentestand): " + filenames[i]);
                    }
                    Set<String> nextBagExtractLeveringGemeenteCodes = nextBagExtractLevering.getGemeenteCodes();
                    if (gemeenteCodes.stream().anyMatch(nextBagExtractLeveringGemeenteCodes::contains)) {
                        throw new IllegalArgumentException("Inladen stand gemeentes, dubbele gemeentecode in bestand: " + filenames[i]);
                    }
                    gemeenteCodes.addAll(nextBagExtractLeveringGemeenteCodes);
                }
            }
            this.loadStandFiles(db, dbOptions, loadOptions, progressReporter, filenames, cookieManager);
        } else {
            this.applyMutaties(db, dbOptions, loadOptions, progressReporter, filenames, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStandFiles(BAG2Database db, BAG2DatabaseOptions dbOptions, BAG2LoadOptions loadOptions, BAG2ProgressReporter progressReporter, String[] filenames, CookieManager cookieManager) throws Exception {
        try {
            BAG2LoaderUtils.BAGExtractSelectie levering;
            loadOptions.setIgnoreDuplicates(filenames.length > 1);
            if (filenames.length == 1 && !(levering = BAG2LoaderUtils.getBAGExtractSelectieFromZip(filenames[0])).isGebiedNLD()) {
                loadOptions.setIgnoreDuplicates(levering.getGemeenteCodes().size() > 1);
            }
            BAG2GMLMutatieGroepStream.BagInfo bagInfo = null;
            String lastFilename = null;
            HashSet<String> gemeenteIdentificaties = new HashSet<String>();
            for (String filename : filenames) {
                BAG2GMLMutatieGroepStream.BagInfo latestBagInfo = this.loadBAG2ExtractFromURLorFile(db, loadOptions, dbOptions, progressReporter, filename);
                if (bagInfo != null && !latestBagInfo.equalsExceptGemeenteIdentificaties(bagInfo)) {
                    throw new IllegalArgumentException(String.format("Incompatible BagInfo for file \"%s\" (%s) compared to last file \"%s\" (%s)", filename, latestBagInfo, lastFilename, bagInfo));
                }
                bagInfo = latestBagInfo;
                gemeenteIdentificaties.addAll(bagInfo.getGemeenteIdentificaties());
                lastFilename = filename;
            }
            if (bagInfo != null) {
                this.createKeysAndIndexes(db, loadOptions, dbOptions, progressReporter);
                this.updateMetadata(db, loadOptions, true, gemeenteIdentificaties, bagInfo.getStandTechnischeDatum());
            }
            db.getConnection().commit();
        }
        finally {
            progressReporter.reportTotalSummary();
        }
    }

    public void applyMutaties(BAG2Database db, BAG2DatabaseOptions dbOptions, BAG2LoadOptions loadOptions, BAG2ProgressReporter progressReporter, String[] urls, CookieManager cookieManager) throws Exception {
        if (urls.length == 0) {
            return;
        }
        BAG2LoaderUtils.BAGExtractSelectie bagExtractLevering = BAG2LoaderUtils.getBAGExtractSelectieFromZip(urls[0]);
        if (bagExtractLevering.isGebiedNLD()) {
            this.applyNLMutaties(db, dbOptions, loadOptions, progressReporter, urls, cookieManager);
        } else {
            this.applyGemeenteMutaties(db, dbOptions, loadOptions, progressReporter, urls, cookieManager);
        }
    }

    private void applyGemeenteMutaties(BAG2Database db, BAG2DatabaseOptions dbOptions, BAG2LoadOptions loadOptions, BAG2ProgressReporter progressReporter, String[] urls, CookieManager cookieManager) throws Exception {
        LocalDate currentTechnischeDatum = db.getCurrentTechnischeDatum();
        Set<String> gemeenteCodes = db.getGemeenteCodes();
        while (true) {
            HashSet<Integer> applicableMutatieIndexes = new HashSet<Integer>();
            HashSet<String> missingGemeentes = new HashSet<String>(gemeenteCodes);
            for (int i = 0; i < urls.length; ++i) {
                BAG2LoaderUtils.BAGExtractSelectie bagExtractLevering = BAG2LoaderUtils.getBAGExtractSelectieFromZip(urls[i]);
                if (bagExtractLevering.isGebiedNLD() || bagExtractLevering.isStand() || !bagExtractLevering.getMutatiesFrom().equals(currentTechnischeDatum)) continue;
                for (String gemeenteCode : bagExtractLevering.getGemeenteCodes()) {
                    if (!gemeenteCodes.contains(gemeenteCode)) continue;
                    applicableMutatieIndexes.add(i);
                    missingGemeentes.remove(gemeenteCode);
                }
            }
            if (applicableMutatieIndexes.isEmpty()) break;
            if (!missingGemeentes.isEmpty()) {
                throw new IllegalArgumentException(String.format("Kan geen gemeente mutaties toepassen voor gemeentes %s vanaf stand technische datum %s, in opgegeven mutatiebestanden ontbreken gemeentecodes %s", gemeenteCodes, currentTechnischeDatum, missingGemeentes));
            }
            log.info((Object)String.format("Toepassen gemeentemutaties voor %d gemeentes vanaf stand technische datum %s...", gemeenteCodes.size(), currentTechnischeDatum));
            BAG2GMLMutatieGroepStream.BagInfo bagInfo = null;
            loadOptions.setIgnoreDuplicates(gemeenteCodes.size() > 1);
            Iterator iterator = applicableMutatieIndexes.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                bagInfo = this.loadBAG2ExtractFromURLorFile(db, loadOptions, dbOptions, progressReporter, urls[index], cookieManager);
            }
            currentTechnischeDatum = new Date(bagInfo.getStandTechnischeDatum().getTime()).toLocalDate();
            this.updateMetadata(db, loadOptions, false, null, bagInfo.getStandTechnischeDatum());
            db.getConnection().commit();
            this.clearDuplicatesCache();
            log.info((Object)("Mutaties verwerkt, huidige stand technische datum: " + currentTechnischeDatum));
        }
        log.info((Object)String.format("Geen nieuw toe te passen gemeentemutatiebestanden gevonden voor huidige stand technische datum %s, klaar", currentTechnischeDatum));
    }

    private void applyNLMutaties(BAG2Database db, BAG2DatabaseOptions dbOptions, BAG2LoadOptions loadOptions, BAG2ProgressReporter progressReporter, String[] urls, CookieManager cookieManager) throws Exception {
        LocalDate currentTechnischeDatum = db.getCurrentTechnischeDatum();
        while (true) {
            String applicatieMutatieURL = null;
            for (String url : urls) {
                BAG2LoaderUtils.BAGExtractSelectie bagExtractSelectie = BAG2LoaderUtils.getBAGExtractSelectieFromZip(url);
                if (!bagExtractSelectie.isGebiedNLD() || bagExtractSelectie.isStand() || !bagExtractSelectie.getMutatiesFrom().equals(currentTechnischeDatum)) continue;
                applicatieMutatieURL = url;
            }
            if (applicatieMutatieURL == null) break;
            log.info((Object)String.format("Toepassen mutaties vanaf stand technische datum %s...", currentTechnischeDatum));
            BAG2GMLMutatieGroepStream.BagInfo bagInfo = this.loadBAG2ExtractFromURLorFile(db, loadOptions, dbOptions, progressReporter, applicatieMutatieURL, cookieManager);
            currentTechnischeDatum = new Date(bagInfo.getStandTechnischeDatum().getTime()).toLocalDate();
            this.updateMetadata(db, loadOptions, false, null, bagInfo.getStandTechnischeDatum());
            db.getConnection().commit();
            log.info((Object)("Mutaties verwerkt, huidige stand technische datum: " + currentTechnischeDatum));
        }
        log.info((Object)String.format("Geen nieuw toe te passen mutatiebestanden gevonden voor huidige stand technische datum %s, klaar", currentTechnischeDatum));
    }

    private void createKeysAndIndexes(BAG2Database db, BAG2LoadOptions loadOptions, BAG2DatabaseOptions databaseOptions, BAG2ProgressReporter progressReporter) throws Exception {
        BAG2ObjectTableWriter writer = db.createObjectTableWriter(loadOptions, databaseOptions);
        writer.setProgressUpdater(progressReporter);
        for (BAG2ObjectType objectType : this.objectTypesWithSchemaCreated) {
            writer.createKeys(objectType);
            writer.createIndexes(objectType);
        }
    }

    private BAG2GMLMutatieGroepStream.BagInfo loadBAG2ExtractFromURLorFile(BAG2Database db, BAG2LoadOptions loadOptions, BAG2DatabaseOptions dbOptions, BAG2ProgressReporter progressReporter, String url) throws Exception {
        return this.loadBAG2ExtractFromURLorFile(db, loadOptions, dbOptions, progressReporter, url, null);
    }

    private BAG2GMLMutatieGroepStream.BagInfo loadBAG2ExtractFromURLorFile(BAG2Database db, BAG2LoadOptions loadOptions, BAG2DatabaseOptions dbOptions, BAG2ProgressReporter progressReporter, String url, CookieManager cookieManager) throws Exception {
        Java11HttpClientWrapper httpClientWrapper;
        Java11HttpClientWrapper java11HttpClientWrapper = httpClientWrapper = cookieManager == null ? new Java11HttpClientWrapper() : new Java11HttpClientWrapper(HttpClient.newBuilder().cookieHandler(cookieManager));
        if (url.startsWith("http://") || url.startsWith("https://")) {
            try (ResumingInputStream in = new ResumingInputStream((ResumingInputStream.StreamAtStartPositionProvider)new HttpStartRangeInputStreamProvider(URI.create(url), (HttpClientWrapper)httpClientWrapper));){
                BAG2GMLMutatieGroepStream.BagInfo bagInfo = this.loadBAG2ExtractFromStream(db, loadOptions, dbOptions, progressReporter, url, (InputStream)in);
                return bagInfo;
            }
        }
        if (url.endsWith(".zip")) {
            try (FileInputStream in = new FileInputStream(url);){
                BAG2GMLMutatieGroepStream.BagInfo bagInfo = this.loadBAG2ExtractFromStream(db, loadOptions, dbOptions, progressReporter, url, in);
                return bagInfo;
            }
        }
        throw new IllegalArgumentException(Utils.getMessageFormattedString((String)"load.invalid_file", (Object[])new Object[]{url}));
    }

    private BAG2GMLMutatieGroepStream.BagInfo loadBAG2ExtractFromStream(BAG2Database db, BAG2LoadOptions loadOptions, BAG2DatabaseOptions dbOptions, BAG2ProgressReporter progressReporter, String name, InputStream input) throws Exception {
        BAG2GMLMutatieGroepStream.BagInfo bagInfo = null;
        HashSet<String> gemeenteIdentificaties = new HashSet<String>();
        try (ZipArchiveInputStream zip = new ZipArchiveInputStream(input);){
            ZipArchiveEntry entry = zip.getNextZipEntry();
            while (entry != null) {
                ZipArchiveInputStream nestedZip;
                if (entry.getName().matches("[0-9]{4}(STA|VBO|OPR|NUM|LIG|PND|WPL).*\\.xml")) {
                    bagInfo = this.loadXmlEntriesFromZipFile(db, loadOptions, dbOptions, progressReporter, name, zip, entry);
                    break;
                }
                if (entry.getName().matches("[0-9]{4}GEM[0-9]{8}\\.zip")) {
                    bagInfo = this.loadBAG2ExtractFromStream(db, loadOptions, dbOptions, progressReporter, name, (InputStream)CloseShieldInputStream.wrap((InputStream)zip));
                }
                if (entry.getName().matches("[0-9]{4}(STA|VBO|OPR|NUM|LIG|PND|WPL).*\\.zip") || entry.getName().matches("[0-9]{4}MUT[0-9]{8}-[0-9]{8}\\.zip")) {
                    nestedZip = new ZipArchiveInputStream((InputStream)zip);
                    bagInfo = this.loadXmlEntriesFromZipFile(db, loadOptions, dbOptions, progressReporter, entry.getName(), nestedZip, nestedZip.getNextZipEntry());
                }
                if (entry.getName().matches("[0-9]{4}Inactief.*\\.zip")) {
                    nestedZip = new ZipArchiveInputStream((InputStream)zip);
                    ZipArchiveEntry nestedEntry = nestedZip.getNextZipEntry();
                    while (nestedEntry != null) {
                        if (nestedEntry.getName().matches("[0-9]{4}IA.*\\.zip")) {
                            ZipArchiveInputStream moreNestedZip = new ZipArchiveInputStream((InputStream)nestedZip);
                            bagInfo = this.loadXmlEntriesFromZipFile(db, loadOptions, dbOptions, progressReporter, nestedEntry.getName(), moreNestedZip, moreNestedZip.getNextZipEntry());
                        }
                        nestedEntry = nestedZip.getNextZipEntry();
                    }
                }
                if (bagInfo != null) {
                    gemeenteIdentificaties.addAll(bagInfo.getGemeenteIdentificaties());
                }
                try {
                    entry = zip.getNextZipEntry();
                }
                catch (IOException e) {
                    if (!"Truncated ZIP file".equals(e.getMessage())) continue;
                    break;
                }
            }
        }
        if (bagInfo != null) {
            bagInfo.setGemeenteIdentificaties(gemeenteIdentificaties);
        }
        return bagInfo;
    }

    private static BAG2ObjectType getObjectTypeFromFilename(String filename) {
        Matcher m = Pattern.compile(".*[0-9]{4}(IA)?(MUT|STA|VBO|OPR|NUM|LIG|PND|WPL).*\\.(xml|zip)").matcher(filename);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid BAG2 filename: " + filename);
        }
        String objectTypeName = null;
        switch (m.group(2)) {
            case "MUT": {
                break;
            }
            case "STA": {
                objectTypeName = "Standplaats";
                break;
            }
            case "OPR": {
                objectTypeName = "OpenbareRuimte";
                break;
            }
            case "VBO": {
                objectTypeName = "Verblijfsobject";
                break;
            }
            case "NUM": {
                objectTypeName = "Nummeraanduiding";
                break;
            }
            case "LIG": {
                objectTypeName = "Ligplaats";
                break;
            }
            case "PND": {
                objectTypeName = "Pand";
                break;
            }
            case "WPL": {
                objectTypeName = "Woonplaats";
            }
        }
        if (objectTypeName == null) {
            return null;
        }
        return BAG2Schema.getInstance().getObjectTypeByName(objectTypeName);
    }

    private void updateMetadata(BAG2Database db, BAG2LoadOptions loadOptions, boolean stand, Set<String> gemeenteIdentificaties, java.util.Date standTechnischeDatum) throws Exception {
        if (!db.getDialect().tableExists(db.getConnection(), "brmo_metadata")) {
            db.createMetadataTable(loadOptions);
        }
        db.setMetadataValue(BAG2SchemaMapper.Metadata.LOADER_VERSION, BAG2LoaderUtils.getLoaderVersion());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (stand) {
            db.setMetadataValue(BAG2SchemaMapper.Metadata.STAND_LOAD_TIME, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date()));
            db.setMetadataValue(BAG2SchemaMapper.Metadata.STAND_LOAD_TECHNISCHE_DATUM, df.format(standTechnischeDatum));
            db.setMetadataValue(BAG2SchemaMapper.Metadata.GEMEENTE_CODES, String.join((CharSequence)",", gemeenteIdentificaties));
            db.setMetadataValue(BAG2SchemaMapper.Metadata.FILTER_MUTATIES_WOONPLAATS, "false");
        }
        db.setMetadataValue(BAG2SchemaMapper.Metadata.CURRENT_TECHNISCHE_DATUM, df.format(standTechnischeDatum));
    }

    private void clearDuplicatesCache() {
        this.keysPerObjectType = new HashMap<BAG2ObjectType, Set<Pair<Object, Object>>>();
    }

    private BAG2GMLMutatieGroepStream.BagInfo loadXmlEntriesFromZipFile(BAG2Database db, BAG2LoadOptions loadOptions, BAG2DatabaseOptions databaseOptions, BAG2ProgressReporter progressReporter, String name, ZipArchiveInputStream zip, ZipArchiveEntry entry) throws Exception {
        BAG2ObjectType objectType = BAG2LoaderMain.getObjectTypeFromFilename(name);
        boolean schemaCreated = objectType == null || this.objectTypesWithSchemaCreated.contains((Object)objectType);
        BAG2ObjectTableWriter writer = db.createObjectTableWriter(loadOptions, databaseOptions);
        writer.setProgressUpdater(progressReporter);
        writer.setCreateSchema(!schemaCreated);
        writer.setCreateKeysAndIndexes(false);
        writer.setKeysPerObjectType(this.keysPerObjectType);
        writer.start();
        writer.getProgress().setInitialLoad(!schemaCreated);
        if (objectType == null) {
            writer.setBatchSize(1);
            writer.setMultithreading(false);
        }
        progressReporter.startNewFile(name);
        try {
            while (entry != null) {
                progressReporter.startNextSplitFile(entry.getName());
                writer.write((InputStream)CloseShieldInputStream.wrap((InputStream)zip));
                if (loadOptions.getMaxObjects() != null && writer.getProgress().getObjectCount() == (long)loadOptions.getMaxObjects().intValue()) break;
                entry = zip.getNextZipEntry();
            }
            writer.complete();
            if (writer.getProgress().getObjectCount() > 0L && objectType != null) {
                this.objectTypesWithSchemaCreated.add(objectType);
            }
            return writer.getProgress().getMutatieInfo();
        }
        catch (Exception e) {
            writer.abortWorkerThread();
            throw e;
        }
    }
}

