/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bag2.schema;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import nl.b3p.brmo.bag2.loader.BAG2GMLMutatieGroepStream;
import nl.b3p.brmo.bag2.loader.BAG2Mutatie;
import nl.b3p.brmo.bag2.loader.BAG2MutatieGroep;
import nl.b3p.brmo.bag2.loader.BAG2ToevoegingMutatie;
import nl.b3p.brmo.bag2.loader.BAG2WijzigingMutatie;
import nl.b3p.brmo.bag2.schema.BAG2Object;
import nl.b3p.brmo.bag2.schema.BAG2ObjectType;
import nl.b3p.brmo.schema.ObjectTableWriter;
import nl.b3p.brmo.schema.ObjectType;
import nl.b3p.brmo.schema.SchemaObjectInstance;
import nl.b3p.brmo.schema.SchemaSQLMapper;
import nl.b3p.brmo.schema.mapping.AttributeColumnMapping;
import nl.b3p.brmo.sql.PreparedStatementQueryBatch;
import nl.b3p.brmo.sql.QueryBatch;
import nl.b3p.brmo.sql.dialect.SQLDialect;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BAG2ObjectTableWriter
extends ObjectTableWriter {
    private static final Log log = LogFactory.getLog(BAG2ObjectTableWriter.class);
    private boolean ignoreDuplicates;
    private Map<BAG2ObjectType, Set<Pair<Object, Object>>> keysPerObjectType = null;

    public BAG2ObjectTableWriter(Connection connection, SQLDialect dialect, SchemaSQLMapper schemaSQLMapper) {
        super(connection, dialect, schemaSQLMapper);
        this.setProgress(new BAG2Progress());
    }

    public void setIgnoreDuplicates(boolean ignoreDuplicates) {
        this.ignoreDuplicates = ignoreDuplicates;
    }

    public boolean getIgnoreDuplicates() {
        return this.ignoreDuplicates;
    }

    public BAG2Progress getProgress() {
        return (BAG2Progress)super.getProgress();
    }

    public Map<BAG2ObjectType, Set<Pair<Object, Object>>> getKeysPerObjectType() {
        return this.keysPerObjectType;
    }

    public void setKeysPerObjectType(Map<BAG2ObjectType, Set<Pair<Object, Object>>> keysPerObjectType) {
        this.keysPerObjectType = keysPerObjectType;
    }

    public void start() throws SQLException {
        BAG2Progress progress = new BAG2Progress();
        progress.setInitialLoad(true);
        super.start((ObjectTableWriter.Progress)progress);
        this.updateProgress(ObjectTableWriter.Stage.PARSE_INPUT);
    }

    private void deletePreviousVersion(BAG2Object object) throws Exception {
        Map<ObjectType, QueryBatch> deleteBatches = this.getProgress().deleteBatches;
        BAG2ObjectType objectType = object.getObjectType();
        if (!deleteBatches.containsKey((Object)objectType)) {
            String args = objectType.getPrimaryKeys().stream().map(k -> this.getSchemaSQLMapper().getColumnNameForObjectType((ObjectType)objectType, k.getName()) + " = ?").collect(Collectors.joining(" and "));
            String sql = String.format("delete from %s where %s", this.getSchemaSQLMapper().getTableNameForObjectType((ObjectType)objectType, this.getTablePrefix()), args);
            deleteBatches.put(objectType, (QueryBatch)new PreparedStatementQueryBatch(this.getConnection(), sql, 1));
        }
        QueryBatch batch = deleteBatches.get((Object)objectType);
        Object[] params = objectType.getPrimaryKeys().stream().map(pk -> {
            try {
                AttributeColumnMapping mapping = objectType.getAttributeByName(pk.getName());
                Object attribute = object.getAttributes().get(pk.getName());
                return mapping.toQueryParameter(attribute);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).toArray();
        boolean executed = batch.addBatch(params);
        ++this.getProgress().updatedCount;
        if (executed) {
            this.updateProgress();
        }
    }

    protected void addObjectToBatch(SchemaObjectInstance object) throws Exception {
        if (!object.getAttributes().containsKey("tijdstipNietBagLV")) {
            super.addObjectToBatch(object);
        }
    }

    public void write(InputStream bagXml) throws Exception {
        CountingInputStream counter = new CountingInputStream(bagXml);
        BAG2GMLMutatieGroepStream bag2Objects = new BAG2GMLMutatieGroepStream((InputStream)counter);
        this.getProgress().bagInfo = bag2Objects.getBagInfo();
        this.updateProgress(ObjectTableWriter.Stage.LOAD_OBJECTS);
        try {
            block2: for (BAG2MutatieGroep mutatieGroep : bag2Objects) {
                for (BAG2Mutatie mutatie : mutatieGroep.getMutaties()) {
                    if (mutatie instanceof BAG2WijzigingMutatie) {
                        BAG2WijzigingMutatie wijzigingMutatie = (BAG2WijzigingMutatie)mutatie;
                        this.deletePreviousVersion(wijzigingMutatie.getWas());
                        this.addObjectToBatch(wijzigingMutatie.getWordt());
                    } else if (mutatie instanceof BAG2ToevoegingMutatie) {
                        BAG2ToevoegingMutatie toevoegingMutatie = (BAG2ToevoegingMutatie)mutatie;
                        if (this.ignoreDuplicates && this.isDuplicate(toevoegingMutatie.getToevoeging())) continue;
                        this.prepareDatabaseForObject(toevoegingMutatie.getToevoeging());
                        this.getProgress().incrementObjectCount();
                        this.addObjectToBatch(toevoegingMutatie.getToevoeging());
                    }
                    if (this.getObjectLimit() == null || this.getProgress().getObjectCount() != (long)this.getObjectLimit().intValue()) continue;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            if (this.isMultithreading()) {
                this.abortWorkerThread();
            }
            throw e;
        }
    }

    private boolean isDuplicate(BAG2Object object) {
        if (this.keysPerObjectType == null) {
            throw new IllegalStateException("keysPerObject type must be set to enable ignoring of duplicates");
        }
        Pair keys = Pair.of(object.getAttributes().get("identificatie"), object.getAttributes().get("voorkomenidentificatie"));
        Set seenKeys = this.keysPerObjectType.computeIfAbsent(object.getObjectType(), k -> new HashSet());
        if (seenKeys.contains(keys)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("\rIgnoring duplicate %s %s", object.getObjectType().getName(), keys));
            }
            return true;
        }
        seenKeys.add(keys);
        return false;
    }

    public void complete() throws Exception {
        super.endOfObjects();
        for (QueryBatch batch : this.getProgress().deleteBatches.values()) {
            batch.executeBatch();
        }
        super.complete();
        super.closeBatches();
    }

    public void createKeys(ObjectType objectType) throws Exception {
        this.getProgress().currentObjectType = (BAG2ObjectType)objectType;
        super.createKeys(objectType);
    }

    public void createIndexes(ObjectType objectType) throws Exception {
        this.getProgress().currentObjectType = (BAG2ObjectType)objectType;
        super.createIndexes(objectType);
    }

    public class BAG2Progress
    extends ObjectTableWriter.Progress {
        private Map<ObjectType, QueryBatch> deleteBatches;
        private long updatedCount;
        private BAG2GMLMutatieGroepStream.BagInfo bagInfo;
        private BAG2ObjectType currentObjectType;

        public BAG2Progress() {
            super((ObjectTableWriter)BAG2ObjectTableWriter.this);
            this.deleteBatches = new HashMap<ObjectType, QueryBatch>();
            this.updatedCount = 0L;
            this.currentObjectType = null;
        }

        public long getUpdatedCount() {
            return this.updatedCount;
        }

        public BAG2ObjectTableWriter getWriter() {
            return BAG2ObjectTableWriter.this;
        }

        public BAG2GMLMutatieGroepStream.BagInfo getMutatieInfo() {
            return this.bagInfo;
        }

        public BAG2ObjectType getCurrentObjectType() {
            return this.currentObjectType;
        }
    }
}

