/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bag2.loader;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import nl.b3p.brmo.bag2.xml.leveringsdocument.BAGExtractLevering;
import nl.b3p.brmo.bag2.xml.leveringsdocument.Gemeente;

public class BAG2LoaderUtils {
    public static final String BUNDLE_NAME = "BAG2Loader";
    public static final String LEVERINGSDOCUMENT_FILENAME = "Leveringsdocument-BAG-Extract.xml";
    static final ResourceBundle bundle = ResourceBundle.getBundle("BAG2Loader");

    public static String getUserAgent() {
        return String.format("%s, %s (%s)/%s, %s/%s", BAG2LoaderUtils.getBundleString("app.user-agent"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"));
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }

    public static String getBundleString(String key) {
        return bundle.getString(key);
    }

    public static String getMessageFormattedString(String key, Object ... args) {
        ResourceBundle bundle = BAG2LoaderUtils.getBundle();
        return new MessageFormat(bundle.getString(key), bundle.getLocale()).format(args);
    }

    public static String getLoaderVersion() {
        return BAG2LoaderUtils.getBundleString("app.version");
    }

    public static String getBrmoVersion() {
        return BAG2LoaderUtils.getBundleString("brmo.version");
    }

    public static BAGExtractSelectie getBAGExtractSelectieFromZip(String zipFileName) throws IOException {
        if (zipFileName.startsWith("http://") || zipFileName.startsWith("https://")) {
            try {
                return BAGExtractSelectieFromFilename.parse(zipFileName);
            }
            catch (IllegalArgumentException iae) {
                return BAG2LoaderUtils.getBAGExtractSelectieFromHttpZip(URI.create(zipFileName));
            }
        }
        return BAG2LoaderUtils.getBAGExtractSelectieFromZipFile(new File(zipFileName));
    }

    /*
     * Exception decompiling
     */
    private static BAGExtractSelectie getBAGExtractSelectieFromHttpZip(URI uri) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static BAGExtractSelectie getBAGExtractSelectieFromZipFile(File zipFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class BAGExtractSelectieFromLeveringsdocument
    implements BAGExtractSelectie {
        BAGExtractLevering levering;

        private BAGExtractSelectieFromLeveringsdocument(BAGExtractLevering levering) {
            this.levering = levering;
        }

        @Override
        public boolean isStand() {
            return this.levering.getSelectieGegevens().getLVCExtract() != null;
        }

        @Override
        public boolean isGebiedNLD() {
            return this.levering.getSelectieGegevens().getGebiedRegistratief().getGebiedNLD() != null;
        }

        @Override
        public LocalDate getMutatiesFrom() {
            XMLGregorianCalendar xmlGregorianCalendar = this.levering.getSelectieGegevens().getMUTExtract().getMutatieperiode().getMutatiedatumVanaf();
            return LocalDate.of(xmlGregorianCalendar.getYear(), xmlGregorianCalendar.getMonth(), xmlGregorianCalendar.getDay());
        }

        @Override
        public LocalDate getMutatiesTot() {
            XMLGregorianCalendar xmlGregorianCalendar = this.levering.getSelectieGegevens().getMUTExtract().getMutatieperiode().getMutatiedatumTot();
            return LocalDate.of(xmlGregorianCalendar.getYear(), xmlGregorianCalendar.getMonth(), xmlGregorianCalendar.getDay());
        }

        @Override
        public Set<String> getGemeenteCodes() {
            return this.levering.getSelectieGegevens().getGebiedRegistratief().getGebiedGEM().getGemeenteCollectie().getGemeente().stream().map(Gemeente::getGemeenteIdentificatie).collect(Collectors.toSet());
        }
    }

    public static class BAGExtractSelectieFromFilename
    implements BAGExtractSelectie {
        private String name;
        private boolean isStand;
        private boolean isGebiedNLD;
        private String gemeenteCode;
        private LocalDate mutatiesFrom;
        private LocalDate mutatiesTot;

        public static BAGExtractSelectie parse(String name) throws IllegalArgumentException {
            if (name.startsWith("http://") || name.startsWith("https://")) {
                URI uri = URI.create(name);
                String[] parts = uri.getPath().split("/");
                name = parts[parts.length - 1];
            }
            if (name.contains(File.separator)) {
                Path p = Path.of(name, new String[0]);
                name = p.getFileName().toString();
            }
            BAGExtractSelectieFromFilename selectie = new BAGExtractSelectieFromFilename();
            selectie.name = name;
            if (name.equals("lvbag-extract-nl.zip") || name.matches("BAGNLDL-\\d{8}\\.zip")) {
                selectie.isStand = true;
                selectie.isGebiedNLD = true;
                return selectie;
            }
            if (name.matches("BAGGEM\\d{4}L-\\d{8}\\.zip")) {
                selectie.isStand = true;
                selectie.isGebiedNLD = false;
                selectie.gemeenteCode = name.substring(6, 10);
                return selectie;
            }
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyy");
            if (name.matches("BAGGEM\\d{4}M-\\d{8}-\\d{8}\\.zip")) {
                selectie.isStand = false;
                selectie.isGebiedNLD = false;
                selectie.gemeenteCode = name.substring(6, 10);
                selectie.mutatiesFrom = LocalDate.parse(name.substring(12, 20), dtf);
                selectie.mutatiesTot = LocalDate.parse(name.substring(21, 29), dtf);
                return selectie;
            }
            if (name.matches("BAGNLDM-\\d{8}-\\d{8}\\.zip")) {
                selectie.isStand = false;
                selectie.isGebiedNLD = true;
                selectie.mutatiesFrom = LocalDate.parse(name.substring(8, 16), dtf);
                selectie.mutatiesTot = LocalDate.parse(name.substring(17, 25), dtf);
                return selectie;
            }
            throw new IllegalArgumentException("Ongeldige BAG2 bestandsnaam: " + name);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean isStand() {
            return this.isStand;
        }

        @Override
        public boolean isGebiedNLD() {
            return this.isGebiedNLD;
        }

        @Override
        public Set<String> getGemeenteCodes() {
            return Collections.singleton(this.gemeenteCode);
        }

        @Override
        public LocalDate getMutatiesFrom() {
            return this.mutatiesFrom;
        }

        @Override
        public LocalDate getMutatiesTot() {
            return this.mutatiesTot;
        }
    }

    public static interface BAGExtractSelectie {
        public boolean isStand();

        public boolean isGebiedNLD();

        public LocalDate getMutatiesFrom();

        public LocalDate getMutatiesTot();

        public Set<String> getGemeenteCodes();
    }
}

