/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bag2.schema;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.b3p.brmo.bag2.schema.BAG2ObjectType;
import nl.b3p.brmo.schema.ObjectType;
import nl.b3p.brmo.schema.Schema;
import nl.b3p.brmo.schema.mapping.ArrayAttributeMapping;
import nl.b3p.brmo.schema.mapping.AttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.BooleanAttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.GeometryAttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.IntegerAttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.SimpleDateFormatAttributeColumnMapping;

public class BAG2Schema
extends Schema {
    private static BAG2Schema instance;
    static final Set<String> bag2ObjectTypes;
    public static final String TIJDSTIP_NIETBAGLV = "tijdstipNietBagLV";
    private static final String WHERE_CLAUSE_ACTUEEL = "(begingeldigheid <= current_date and (eindgeldigheid is null or eindgeldigheid > current_date) and tijdstipinactief is null)";
    private static final List<AttributeColumnMapping> bag2BaseAttributes;

    private List<AttributeColumnMapping> withBaseAttributes(AttributeColumnMapping ... attributes) {
        return Stream.concat(bag2BaseAttributes.stream(), Stream.of(attributes)).collect(Collectors.toList());
    }

    public BAG2Schema() {
        List<AttributeColumnMapping> woonplaatsAttributes = bag2BaseAttributes.stream().map(attribute -> {
            if ("identificatie".equals(attribute.getName())) {
                return new AttributeColumnMapping("identificatie", "char(4)", true, true);
            }
            return attribute;
        }).collect(Collectors.toList());
        woonplaatsAttributes.addAll(List.of(new AttributeColumnMapping("naam"), new GeometryAttributeColumnMapping("geometrie", "geometry(GEOMETRY, 28992)")));
        this.addObjectType(new BAG2ObjectType(this, "Woonplaats", woonplaatsAttributes).addExtraDataDefinitionSQL((List)List.of("create or replace view v_woonplaats_actueel as select * from woonplaats where (begingeldigheid <= current_date and (eindgeldigheid is null or eindgeldigheid > current_date) and tijdstipinactief is null)")));
        this.addObjectType(new BAG2ObjectType(this, "OpenbareRuimte", this.withBaseAttributes(new AttributeColumnMapping("naam"), new AttributeColumnMapping("verkorteNaam", "varchar(255)", false), new AttributeColumnMapping("type"), new AttributeColumnMapping("ligtIn", "char(4)", false))).addExtraDataDefinitionSQL((List)List.of("create or replace view v_openbareruimte_actueel as select * from openbareruimte where (begingeldigheid <= current_date and (eindgeldigheid is null or eindgeldigheid > current_date) and tijdstipinactief is null)")));
        this.addObjectType(new BAG2ObjectType(this, "Nummeraanduiding", this.withBaseAttributes(new AttributeColumnMapping[]{new IntegerAttributeColumnMapping("huisnummer"), new AttributeColumnMapping("huisletter", "varchar(255)", false), new AttributeColumnMapping("huisnummertoevoeging", "varchar(255)", false), new AttributeColumnMapping("postcode", "char(6)", false), new AttributeColumnMapping("typeAdresseerbaarObject", "varchar(255)", false), new AttributeColumnMapping("ligtIn", "char(4)", false), new AttributeColumnMapping("ligtAan", "char(16)", false)})).addExtraDataDefinitionSQL((List)List.of("create or replace view v_nummeraanduiding_actueel as select * from nummeraanduiding where (begingeldigheid <= current_date and (eindgeldigheid is null or eindgeldigheid > current_date) and tijdstipinactief is null)")));
        this.addObjectType(new BAG2ObjectType(this, "Verblijfsobject", this.withBaseAttributes(new AttributeColumnMapping[]{new ArrayAttributeMapping("gebruiksdoel", "gebruiksdoel", "varchar(255)"), new IntegerAttributeColumnMapping("oppervlakte"), new AttributeColumnMapping("heeftAlsHoofdadres", "char(16)", false), new ArrayAttributeMapping("heeftAlsNevenadres", "nevenadres", "char(16)"), new ArrayAttributeMapping("maaktDeelUitVan", "maaktdeeluitvan", "char(16)"), new GeometryAttributeColumnMapping("geometrie", "geometry(GEOMETRY, 28992)")})).addExtraDataDefinitionSQL((List)List.of("create or replace view v_verblijfsobject_actueel as select * from verblijfsobject where (begingeldigheid <= current_date and (eindgeldigheid is null or eindgeldigheid > current_date) and tijdstipinactief is null)", "create index verblijfsobject_nevenadres_idx on verblijfsobject_nevenadres (identificatie, voorkomenidentificatie)", "create index verblijfsobject_maaktdeeluitvan_idx on verblijfsobject_maaktdeeluitvan (identificatie, voorkomenidentificatie)", "create index verblijfsobject_gebruiksdoel_idx on verblijfsobject_gebruiksdoel (identificatie, voorkomenidentificatie)")));
        this.addObjectType(new BAG2ObjectType(this, "Ligplaats", this.withBaseAttributes(new AttributeColumnMapping[]{new GeometryAttributeColumnMapping("geometrie", "geometry(POLYGON, 28992)"), new AttributeColumnMapping("heeftAlsHoofdadres", "char(16)", false), new ArrayAttributeMapping("heeftAlsNevenadres", "nevenadres", "char(16)")})).addExtraDataDefinitionSQL((List)List.of("create or replace view v_ligplaats_actueel as select * from ligplaats where (begingeldigheid <= current_date and (eindgeldigheid is null or eindgeldigheid > current_date) and tijdstipinactief is null)", "create index ligplaats_nevenadres_idx on ligplaats_nevenadres (identificatie, voorkomenidentificatie)")));
        this.addObjectType(new BAG2ObjectType(this, "Standplaats", this.withBaseAttributes(new AttributeColumnMapping[]{new GeometryAttributeColumnMapping("geometrie", "geometry(POLYGON, 28992)"), new AttributeColumnMapping("heeftAlsHoofdadres", "char(16)", false), new ArrayAttributeMapping("heeftAlsNevenadres", "nevenadres", "char(16)")})).addExtraDataDefinitionSQL((List)List.of("create or replace view v_standplaats_actueel as select * from standplaats where (begingeldigheid <= current_date and (eindgeldigheid is null or eindgeldigheid > current_date) and tijdstipinactief is null)", "create index standplaats_nevenadres_idx on standplaats_nevenadres (identificatie, voorkomenidentificatie)")));
        this.addObjectType(new BAG2ObjectType(this, "Pand", this.withBaseAttributes(new AttributeColumnMapping[]{new IntegerAttributeColumnMapping("oorspronkelijkBouwjaar"), new GeometryAttributeColumnMapping("geometrie", "geometry(POLYGON, 28992)")})).addExtraDataDefinitionSQL((List)List.of("create or replace view v_pand_actueel as select * from pand where (begingeldigheid <= current_date and (eindgeldigheid is null or eindgeldigheid > current_date) and tijdstipinactief is null)")));
    }

    protected void addObjectType(ObjectType objectType) {
        String tableName = objectType.getName().toLowerCase();
        String sql = String.format("create index %s_objectid_idx on %s (objectid)", tableName, tableName);
        objectType.addExtraDataDefinitionSQL(List.of(sql));
        super.addObjectType(objectType);
    }

    public static BAG2Schema getInstance() {
        if (instance == null) {
            instance = new BAG2Schema();
        }
        return instance;
    }

    public Stream<BAG2ObjectType> getAllObjectTypes() {
        return super.getAllObjectTypes();
    }

    public BAG2ObjectType getObjectTypeByName(String name) {
        return (BAG2ObjectType)super.getObjectTypeByName(name);
    }

    static {
        bag2ObjectTypes = new HashSet<String>(Arrays.asList("Pand", "Verblijfsobject", "Nummeraanduiding", "OpenbareRuimte", "Ligplaats", "Standplaats", "Woonplaats"));
        bag2BaseAttributes = Arrays.asList(new AttributeColumnMapping("objectid", "sequence(objectid_seq)", true, false, true), new AttributeColumnMapping("identificatie", "char(16)", true, true), new IntegerAttributeColumnMapping("voorkomenidentificatie", true, true), new SimpleDateFormatAttributeColumnMapping("beginGeldigheid", "date", "yyyy-MM-dd"), new SimpleDateFormatAttributeColumnMapping("eindGeldigheid", "date", false, "yyyy-MM-dd"), new SimpleDateFormatAttributeColumnMapping("tijdstipRegistratie", "timestamp", "yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormatAttributeColumnMapping("eindRegistratie", "timestamp", false, "yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormatAttributeColumnMapping("tijdstipInactief", "timestamp", false, "yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormatAttributeColumnMapping("tijdstipRegistratieLV", "timestamp", "yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormatAttributeColumnMapping("tijdstipEindRegistratieLV", "timestamp", false, "yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormatAttributeColumnMapping("tijdstipInactiefLV", "timestamp", false, "yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormatAttributeColumnMapping("documentdatum", "date", "yyyy-MM-dd"), new AttributeColumnMapping("documentnummer"), new BooleanAttributeColumnMapping("geconstateerd"), new AttributeColumnMapping("status"));
    }
}

