/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bag2.loader;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import nl.b3p.brmo.bag2.loader.BAG2Mutatie;
import nl.b3p.brmo.bag2.loader.BAG2MutatieGroep;
import nl.b3p.brmo.bag2.loader.BAG2ToevoegingMutatie;
import nl.b3p.brmo.bag2.loader.BAG2WijzigingMutatie;
import nl.b3p.brmo.bag2.schema.BAG2Object;
import nl.b3p.brmo.bag2.schema.BAG2ObjectType;
import nl.b3p.brmo.bag2.schema.BAG2Schema;
import nl.b3p.brmo.bag2.util.Force2DCoordinateSequenceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMInputCursor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.gml.stream.XmlStreamGeometryReader;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class BAG2GMLMutatieGroepStream
implements Iterable<BAG2MutatieGroep> {
    private static final Log log = LogFactory.getLog(BAG2GMLMutatieGroepStream.class);
    private static final String NS_BAG_EXTRACT = "http://www.kadaster.nl/schemas/lvbag/extract-deelbestand-lvc/v20200601";
    private static final String NS_STANDLEVERING = "http://www.kadaster.nl/schemas/standlevering-generiek/1.0";
    private static final String NS_GML_32 = "http://www.opengis.net/gml/3.2";
    private static final String NS_HISTORIE = "www.kadaster.nl/schemas/lvbag/imbag/historie/v20200601";
    private static final String NS_OBJECTEN_REF = "www.kadaster.nl/schemas/lvbag/imbag/objecten-ref/v20200601";
    private static final String NS_BAG_EXTRACT_MUTATIES = "http://www.kadaster.nl/schemas/lvbag/extract-deelbestand-mutaties-lvc/v20200601";
    private static final String NS_MUTATIELEVERING = "http://www.kadaster.nl/schemas/mutatielevering-generiek/1.0";
    private static final QName BAG_STAND = new QName("http://www.kadaster.nl/schemas/lvbag/extract-deelbestand-lvc/v20200601", "bagStand");
    private static final QName BAG_MUTATIES = new QName("http://www.kadaster.nl/schemas/lvbag/extract-deelbestand-mutaties-lvc/v20200601", "bagMutaties");
    private static final int SRID = 28992;
    private final XmlStreamGeometryReader geometryReader;
    private final SMInputCursor cursor;
    private boolean isMutaties;
    private boolean hasMutatieGroep;
    private BagInfo bagInfo;

    public BAG2GMLMutatieGroepStream(InputStream in) throws XMLStreamException {
        this.cursor = this.initCursor((SMInputCursor)this.buildSMInputFactory().rootElementCursor(in));
        this.geometryReader = this.buildGeometryReader();
    }

    protected SMInputFactory buildSMInputFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        log.trace((Object)("StAX XMLInputFactory: " + xmlInputFactory.getClass().getName()));
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return new SMInputFactory(xmlInputFactory);
    }

    protected XmlStreamGeometryReader buildGeometryReader() {
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), 28992, (CoordinateSequenceFactory)new Force2DCoordinateSequenceFactory());
        return new XmlStreamGeometryReader((XMLStreamReader)this.cursor.getStreamReader(), geometryFactory);
    }

    private SMInputCursor initCursor(SMInputCursor cursor) throws XMLStreamException {
        QName root = cursor.advance().getQName();
        if (root.equals(BAG_STAND)) {
            this.isMutaties = false;
        } else if (root.equals(BAG_MUTATIES)) {
            this.isMutaties = true;
        } else {
            throw new IllegalArgumentException("XML root element moet bagStand of bagMutaties zijn");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date standTechnischeDatum = null;
        if (this.isMutaties) {
            cursor = cursor.childElementCursor().advance();
            cursor.getStreamReader().require(1, NS_BAG_EXTRACT_MUTATIES, "bagInfo");
            SMInputCursor bagInfoCursor = cursor.descendantElementCursor().advance();
            Date mutatieDatumVanaf = null;
            Date mutatieDatumTot = null;
            do {
                try {
                    switch (bagInfoCursor.getLocalName()) {
                        case "StandTechnischeDatum": {
                            standTechnischeDatum = df.parse(bagInfoCursor.collectDescendantText());
                            break;
                        }
                        case "MutatiedatumVanaf": {
                            mutatieDatumVanaf = df.parse(bagInfoCursor.collectDescendantText());
                            break;
                        }
                        case "MutatiedatumTot": {
                            mutatieDatumTot = df.parse(bagInfoCursor.collectDescendantText());
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            } while (bagInfoCursor.getNext() != null);
            this.bagInfo = new BagInfo(standTechnischeDatum, mutatieDatumVanaf, mutatieDatumTot);
            cursor.getNext();
            cursor.getStreamReader().require(1, NS_MUTATIELEVERING, "mutatieBericht");
            cursor = cursor.childElementCursor(new QName(NS_MUTATIELEVERING, "mutatieGroep"));
            this.hasMutatieGroep = cursor.getNext() != null;
        } else {
            cursor = cursor.childElementCursor().advance();
            cursor.getStreamReader().require(1, NS_BAG_EXTRACT, "bagInfo");
            SMInputCursor bagInfoCursor = cursor.descendantElementCursor().advance();
            String gemeenteIdentificatie = null;
            block25: do {
                switch (bagInfoCursor.getLocalName()) {
                    case "StandTechnischeDatum": {
                        try {
                            standTechnischeDatum = df.parse(bagInfoCursor.collectDescendantText());
                        }
                        catch (ParseException parseException) {}
                        continue block25;
                    }
                    case "GemeenteIdentificatie": {
                        if (gemeenteIdentificatie != null) {
                            throw new IllegalArgumentException("Alleen een enkele GemeenteIdentificatie in een GemeenteCollectie wordt ondersteund");
                        }
                        gemeenteIdentificatie = bagInfoCursor.collectDescendantText();
                        break;
                    }
                    case "Gebied-NLD": {
                        gemeenteIdentificatie = "9999";
                    }
                }
            } while (bagInfoCursor.getNext() != null);
            this.bagInfo = new BagInfo(standTechnischeDatum, null, null, gemeenteIdentificatie);
            cursor.getNext();
            cursor.getStreamReader().require(1, NS_STANDLEVERING, "standBestand");
            cursor = cursor.childElementCursor(new QName(NS_STANDLEVERING, "stand"));
        }
        return cursor;
    }

    public BagInfo getBagInfo() {
        return this.bagInfo;
    }

    @Override
    public Iterator<BAG2MutatieGroep> iterator() {
        return new Iterator<BAG2MutatieGroep>(){
            SMEvent event;
            {
                this.event = BAG2GMLMutatieGroepStream.this.cursor.getCurrEvent();
            }

            @Override
            public boolean hasNext() {
                if (BAG2GMLMutatieGroepStream.this.isMutaties && !BAG2GMLMutatieGroepStream.this.hasMutatieGroep) {
                    return false;
                }
                if (this.event != null) {
                    return true;
                }
                try {
                    this.event = BAG2GMLMutatieGroepStream.this.cursor.getNext();
                    return this.event != null;
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public BAG2MutatieGroep next() {
                if (this.event == null && !this.hasNext()) {
                    throw new IllegalStateException("No more items");
                }
                this.event = null;
                try {
                    if (BAG2GMLMutatieGroepStream.this.isMutaties) {
                        if (!BAG2GMLMutatieGroepStream.this.hasMutatieGroep) {
                            throw new IllegalStateException("No items");
                        }
                        BAG2GMLMutatieGroepStream.this.cursor.getStreamReader().require(1, BAG2GMLMutatieGroepStream.NS_MUTATIELEVERING, "mutatieGroep");
                        SMInputCursor mutatieCursor = BAG2GMLMutatieGroepStream.this.cursor.childElementCursor().advance();
                        ArrayList<BAG2Mutatie> mutaties = new ArrayList<BAG2Mutatie>();
                        do {
                            String mutatieNaam = mutatieCursor.getLocalName();
                            Location location = mutatieCursor.getCursorLocation();
                            switch (mutatieNaam) {
                                case "wijziging": {
                                    SMInputCursor wijziging = mutatieCursor.childElementCursor().advance();
                                    wijziging.getStreamReader().require(1, BAG2GMLMutatieGroepStream.NS_MUTATIELEVERING, "was");
                                    BAG2Object was = BAG2GMLMutatieGroepStream.this.parseBAG2ObjectFromBagObjectParentElement(wijziging, BAG2GMLMutatieGroepStream.NS_BAG_EXTRACT_MUTATIES);
                                    wijziging.getNext();
                                    wijziging.getStreamReader().require(1, BAG2GMLMutatieGroepStream.NS_MUTATIELEVERING, "wordt");
                                    BAG2Object wordt = BAG2GMLMutatieGroepStream.this.parseBAG2ObjectFromBagObjectParentElement(wijziging, BAG2GMLMutatieGroepStream.NS_BAG_EXTRACT_MUTATIES);
                                    mutaties.add(new BAG2WijzigingMutatie(location, was, wordt));
                                    break;
                                }
                                case "toevoeging": {
                                    SMInputCursor wijziging = mutatieCursor.childElementCursor().advance();
                                    wijziging.getStreamReader().require(1, BAG2GMLMutatieGroepStream.NS_MUTATIELEVERING, "wordt");
                                    BAG2Object toevoeging = BAG2GMLMutatieGroepStream.this.parseBAG2ObjectFromBagObjectParentElement(wijziging, BAG2GMLMutatieGroepStream.NS_BAG_EXTRACT_MUTATIES);
                                    mutaties.add(new BAG2ToevoegingMutatie(location, toevoeging));
                                    break;
                                }
                                case "verwijdering": {
                                    throw new IllegalArgumentException("Verwijdering-mutaties mogen niet voorkomen in de BAG2");
                                }
                                default: {
                                    throw new IllegalArgumentException("Onbekende mutatie: " + mutatieNaam);
                                }
                            }
                        } while (mutatieCursor.getNext() == SMEvent.START_ELEMENT);
                        return new BAG2MutatieGroep(mutaties);
                    }
                    BAG2GMLMutatieGroepStream.this.cursor.getStreamReader().require(1, BAG2GMLMutatieGroepStream.NS_STANDLEVERING, "stand");
                    Location location = BAG2GMLMutatieGroepStream.this.cursor.getCursorLocation();
                    BAG2Object object = BAG2GMLMutatieGroepStream.this.parseBAG2ObjectFromBagObjectParentElement(BAG2GMLMutatieGroepStream.this.cursor, BAG2GMLMutatieGroepStream.NS_BAG_EXTRACT);
                    return new BAG2MutatieGroep(List.of(new BAG2ToevoegingMutatie(location, object)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private BAG2Object parseBAG2ObjectFromBagObjectParentElement(SMInputCursor bagObjectParentCursor, String bagObjectNamespace) throws XMLStreamException, FactoryException, IOException {
        SMInputCursor bagObjectCursor = bagObjectParentCursor.childElementCursor(new QName(bagObjectNamespace, "bagObject")).advance().childElementCursor().advance();
        return this.parseBAG2Object(bagObjectCursor);
    }

    private BAG2Object parseBAG2Object(SMInputCursor bagObjectCursor) throws XMLStreamException, FactoryException, IOException {
        String name = bagObjectCursor.getLocalName();
        BAG2ObjectType objectType = BAG2Schema.getInstance().getObjectTypeByName(name);
        if (objectType == null) {
            throw new IllegalArgumentException("Onbekend object type: " + name);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        SMInputCursor attributeCursor = bagObjectCursor.childElementCursor();
        while (attributeCursor.getNext() != null) {
            this.parseAttribute(attributeCursor, attributes);
        }
        return new BAG2Object(objectType, attributes);
    }

    private void parseAttribute(SMInputCursor attribute, Map<String, Object> objectAttributes) throws XMLStreamException, FactoryException, IOException {
        String attributeName;
        switch (attributeName = attribute.getLocalName()) {
            case "geometrie": {
                SMInputCursor geomCursor = attribute.childElementCursor().advance();
                if (!geomCursor.getNsUri().equals(NS_GML_32)) {
                    geomCursor.childElementCursor().advance();
                }
                Geometry geom = this.geometryReader.readGeometry();
                geom.setSRID(28992);
                objectAttributes.put(attributeName, geom);
                break;
            }
            case "voorkomen": {
                this.parseVoorkomen(attribute, objectAttributes);
                break;
            }
            case "BeschikbaarLV": {
                this.parseBeschikbaarLV(attribute, objectAttributes);
                break;
            }
            case "heeftAlsNevenadres": {
                this.parseNevenadres(attribute, objectAttributes);
                break;
            }
            case "maaktDeelUitVan": {
                this.parseMaaktDeelUitVan(attribute, objectAttributes);
                break;
            }
            case "gebruiksdoel": {
                this.parseGebruiksdoel(attribute, objectAttributes);
                break;
            }
            case "geconstateerd": {
                String jn = attribute.collectDescendantText().trim();
                objectAttributes.put(attributeName, "J".equals(jn) ? "true" : "false");
                break;
            }
            default: {
                objectAttributes.put(attributeName, attribute.collectDescendantText().trim());
            }
        }
    }

    private void parseVoorkomen(SMInputCursor attributeCursor, Map<String, Object> objectAttributes) throws XMLStreamException, FactoryException, IOException {
        attributeCursor = attributeCursor.childElementCursor(new QName(NS_HISTORIE, "Voorkomen")).advance().childElementCursor();
        while (attributeCursor.getNext() != null) {
            this.parseAttribute(attributeCursor, objectAttributes);
        }
    }

    private void parseBeschikbaarLV(SMInputCursor attributeCursor, Map<String, Object> objectAttributes) throws XMLStreamException, FactoryException, IOException {
        attributeCursor = attributeCursor.childElementCursor();
        while (attributeCursor.getNext() != null) {
            this.parseAttribute(attributeCursor, objectAttributes);
        }
    }

    private void parseNevenadres(SMInputCursor attributeCursor, Map<String, Object> objectAttributes) throws XMLStreamException {
        HashSet<String> values = new HashSet<String>();
        attributeCursor = attributeCursor.childElementCursor(new QName(NS_OBJECTEN_REF, "NummeraanduidingRef"));
        while (attributeCursor.getNext() != null) {
            values.add(attributeCursor.collectDescendantText().trim());
        }
        objectAttributes.put("heeftAlsNevenadres", values);
    }

    private void parseMaaktDeelUitVan(SMInputCursor attributeCursor, Map<String, Object> objectAttributes) throws XMLStreamException {
        HashSet<String> values = new HashSet<String>();
        attributeCursor = attributeCursor.childElementCursor(new QName(NS_OBJECTEN_REF, "PandRef"));
        while (attributeCursor.getNext() != null) {
            values.add(attributeCursor.collectDescendantText().trim());
        }
        objectAttributes.put("maaktDeelUitVan", values);
    }

    private void parseGebruiksdoel(SMInputCursor attributeCursor, Map<String, Object> objectAttributes) throws XMLStreamException {
        HashSet<String> values = (HashSet<String>)objectAttributes.get("gebruiksdoel");
        if (values == null) {
            values = new HashSet<String>();
            objectAttributes.put("gebruiksdoel", values);
        }
        values.add(attributeCursor.collectDescendantText().trim());
    }

    public static class BagInfo {
        private final Date standTechnischeDatum;
        private final Date mutatieDatumVanaf;
        private final Date mutatieDatumTot;
        private Set<String> gemeenteIdentificaties;

        protected BagInfo(Date standTechnischeDatum, Date mutatieDatumVanaf, Date mutatieDatumTot) {
            this(standTechnischeDatum, mutatieDatumVanaf, mutatieDatumTot, (String)null);
        }

        protected BagInfo(Date standTechnischeDatum, Date mutatieDatumVanaf, Date mutatieDatumTot, String gemeenteIdentificatie) {
            this(standTechnischeDatum, mutatieDatumVanaf, mutatieDatumTot, Collections.singleton(gemeenteIdentificatie));
        }

        protected BagInfo(Date standTechnischeDatum, Date mutatieDatumVanaf, Date mutatieDatumTot, Set<String> gemeenteIdentificaties) {
            this.standTechnischeDatum = standTechnischeDatum;
            this.mutatieDatumVanaf = mutatieDatumVanaf;
            this.mutatieDatumTot = mutatieDatumTot;
            this.gemeenteIdentificaties = gemeenteIdentificaties;
        }

        public Date getStandTechnischeDatum() {
            return this.standTechnischeDatum;
        }

        public Date getMutatieDatumVanaf() {
            return this.mutatieDatumVanaf;
        }

        public Date getMutatieDatumTot() {
            return this.mutatieDatumTot;
        }

        public Set<String> getGemeenteIdentificaties() {
            return this.gemeenteIdentificaties;
        }

        public void setGemeenteIdentificaties(Set<String> gemeenteIdentificaties) {
            this.gemeenteIdentificaties = gemeenteIdentificaties;
        }

        public boolean equalsExceptGemeenteIdentificaties(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BagInfo that = (BagInfo)o;
            return Objects.equals(this.standTechnischeDatum, that.standTechnischeDatum) && Objects.equals(this.mutatieDatumVanaf, that.mutatieDatumVanaf) && Objects.equals(this.mutatieDatumTot, that.mutatieDatumTot);
        }

        public int hashCode() {
            return Objects.hash(this.standTechnischeDatum, this.mutatieDatumVanaf, this.mutatieDatumTot);
        }

        public boolean equals(Object o) {
            return this.equalsExceptGemeenteIdentificaties(o);
        }

        public String toString() {
            return "BagInfo{standTechnischeDatum=" + this.standTechnischeDatum + ", mutatieDatumVanaf=" + this.mutatieDatumVanaf + ", mutatieDatumTot=" + this.mutatieDatumTot + "}";
        }
    }
}

