/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bag2.loader;

import java.time.Instant;
import java.util.function.Consumer;
import nl.b3p.brmo.bag2.loader.BAG2LoaderUtils;
import nl.b3p.brmo.bag2.schema.BAG2ObjectTableWriter;
import nl.b3p.brmo.bgt.loader.Utils;
import nl.b3p.brmo.schema.ObjectTableWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BAG2ProgressReporter
implements Consumer<ObjectTableWriter.Progress> {
    private static final Log log = LogFactory.getLog(BAG2ProgressReporter.class);
    private final Instant start = Instant.now();
    protected String currentFileName;
    protected Instant currentFileStart;
    protected int splitFileCount;

    protected void log(String msg) {
        log.info((Object)msg);
    }

    protected void status(String msg) {
        log.debug((Object)msg);
    }

    public void startNewFile(String name) {
        this.currentFileName = name;
        this.currentFileStart = Instant.now();
        this.splitFileCount = 0;
    }

    public void startNextSplitFile(String entry) {
        ++this.splitFileCount;
    }

    @Override
    public void accept(ObjectTableWriter.Progress progress) {
        BAG2ObjectTableWriter.BAG2Progress bag2Progress = (BAG2ObjectTableWriter.BAG2Progress)progress;
        switch (progress.getStage()) {
            case LOAD_OBJECTS: {
                if (progress.getObjectCount() != 0L) break;
                this.log(BAG2LoaderUtils.getMessageFormattedString("progress.loading", this.currentFileName));
                break;
            }
            case CREATE_PRIMARY_KEY: {
                this.log(BAG2LoaderUtils.getMessageFormattedString("progress.create_primary_key", bag2Progress.getCurrentObjectType().getName()));
                break;
            }
            case CREATE_GEOMETRY_INDEX: {
                this.log(BAG2LoaderUtils.getMessageFormattedString("progress.create_geometry_indexes", bag2Progress.getCurrentObjectType().getName()));
                break;
            }
            case FINISHED: {
                this.log(BAG2LoaderUtils.getMessageFormattedString("progress.finished_file", this.currentFileName, this.splitFileCount, bag2Progress.getObjectCount(), Utils.formatTimeSince((Instant)this.currentFileStart)));
                break;
            }
        }
    }

    public void reportTotalSummary() {
        this.log(BAG2LoaderUtils.getMessageFormattedString("progress.finished", Utils.formatTimeSince((Instant)this.start)));
    }
}

