/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bag2.loader.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import nl.b3p.brmo.bag2.loader.BAG2Database;
import nl.b3p.brmo.bag2.loader.BAG2LoaderUtils;
import nl.b3p.brmo.bag2.loader.BAG2ProgressReporter;
import nl.b3p.brmo.bag2.loader.cli.BAG2ConsoleProgressReporter;
import nl.b3p.brmo.bag2.loader.cli.BAG2DatabaseOptions;
import nl.b3p.brmo.bag2.loader.cli.BAG2LoadOptions;
import nl.b3p.brmo.bag2.loader.cli.BAG2LoaderMain;
import nl.b3p.brmo.bag2.loader.cli.BAG2ProgressOptions;
import nl.b3p.brmo.bgt.loader.Utils;
import nl.b3p.brmo.util.ResumingInputStream;
import nl.b3p.brmo.util.http.HttpClientWrapper;
import nl.b3p.brmo.util.http.HttpStartRangeInputStreamProvider;
import nl.b3p.brmo.util.http.wrapper.Java11HttpClientWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import picocli.CommandLine;

@CommandLine.Command(name="mutaties", mixinStandardHelpOptions=true)
public class BAG2MutatiesCommand {
    private static final Log log = LogFactory.getLog(BAG2MutatiesCommand.class);
    @CommandLine.ParentCommand
    private BAG2LoaderMain parent;
    private static final String KADASTER_LOGIN_URL = "https://mijn.kadaster.nl/security/login.do";
    public static final String LVBAG_BESTANDEN_API_URL = "https://bag.kadaster.nl/lvbag/bag-bestanden/api/bestanden";

    public void setParent(BAG2LoaderMain parent) {
        this.parent = parent;
    }

    @CommandLine.Command(name="download", sortOptions=false)
    public int download(@CommandLine.Option(names={"--no-delete"}, negatable=true) boolean noDelete, @CommandLine.Option(names={"--kadaster-user"}) String kadasterUser, @CommandLine.Option(names={"--kadaster-password"}) String kadasterPassword, @CommandLine.Option(names={"--url"}, defaultValue="https://bag.kadaster.nl/lvbag/bag-bestanden/api/bestanden") String url, @CommandLine.Option(names={"--query-params"}, defaultValue="artikelnummers=2529") String queryParams, @CommandLine.Option(names={"--path"}, defaultValue="") String downloadPath, @CommandLine.Option(names={"--mirror-base-url"}) String mirrorBaseUrl, @CommandLine.Option(names={"-h", "--help"}, usageHelp=true) boolean showHelp) throws Exception {
        log.info((Object)BAG2LoaderUtils.getUserAgent());
        Instant start = Instant.now();
        CookieManager kadasterCookieManager = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
        BAG2MutatiesCommand.mijnKadasterLogin(URI.create(url), kadasterUser, kadasterPassword, kadasterCookieManager);
        JSONArray bestanden = BAG2MutatiesCommand.getBagBestanden(url, queryParams, kadasterCookieManager);
        log.info((Object)("Aantal beschikbare bestanden: " + bestanden.length()));
        ArrayList<JSONObject> toDownload = new ArrayList<JSONObject>();
        for (int i = 0; i < bestanden.length(); ++i) {
            JSONObject bestand2 = bestanden.getJSONObject(i);
            File f = Path.of(downloadPath, bestand2.getString("naam")).toFile();
            if (f.exists() && f.length() == bestand2.getLong("grootte")) continue;
            toDownload.add(bestand2);
        }
        if (!noDelete) {
            BAG2MutatiesCommand.deleteZipFilesNotInBestanden(downloadPath, bestanden);
        }
        long totalBytes = toDownload.stream().map(bestand -> bestand.getLong("grootte")).reduce(Long::sum).orElse(0L);
        log.info((Object)String.format("Aantal te downloaden naar directory \"%s\": %d bestanden (%s)", Path.of(downloadPath, new String[0]).toAbsolutePath(), toDownload.size(), FileUtils.byteCountToDisplaySize((long)totalBytes)));
        int count = 0;
        long bytesRead = 0L;
        for (JSONObject bestand3 : toDownload) {
            url = bestand3.getString("url");
            String name = bestand3.getString("naam");
            try (ResumingInputStream input = new ResumingInputStream((ResumingInputStream.StreamAtStartPositionProvider)new HttpStartRangeInputStreamProvider(URI.create(url), (HttpClientWrapper)new Java11HttpClientWrapper(HttpClient.newBuilder().cookieHandler(kadasterCookieManager))));
                 FileOutputStream out = new FileOutputStream(Path.of(downloadPath, name).toFile());){
                log.info((Object)String.format("Bestand %2d/%d (%.1f%%): downloaden %s...", ++count, toDownload.size(), 100.0 / (double)totalBytes * (double)bytesRead, name));
                IOUtils.copyLarge((InputStream)input, (OutputStream)out);
            }
            bytesRead += bestand3.getLong("grootte");
        }
        if (!toDownload.isEmpty()) {
            String msg = "";
            if (mirrorBaseUrl != null) {
                for (int i = 0; i < bestanden.length(); ++i) {
                    JSONObject bestand4 = bestanden.getJSONObject(i);
                    String name = bestand4.getString("naam");
                    bestand4.put("url", (Object)URI.create(mirrorBaseUrl).resolve(name));
                }
                File bestandenJSONMirror = Path.of(downloadPath, "bestanden.json").toFile();
                try (FileOutputStream out = new FileOutputStream(bestandenJSONMirror);){
                    IOUtils.write((String)bestanden.toString(2), (OutputStream)out, (Charset)StandardCharsets.UTF_8);
                    msg = String.format(", JSON voor mirror \"%s\" geschreven naar \"%s\"", mirrorBaseUrl, bestandenJSONMirror);
                }
            }
            log.info((Object)("Alle bestanden gedownload in " + Utils.formatTimeSince((Instant)start) + msg));
        }
        return 0;
    }

    @CommandLine.Command(name="apply", sortOptions=false)
    public int apply(@CommandLine.Mixin BAG2DatabaseOptions dbOptions, @CommandLine.Mixin BAG2ProgressOptions progressOptions, @CommandLine.Mixin BAG2LoadOptions loadOptions, @CommandLine.Option(names={"--kadaster-user"}) String kadasterUser, @CommandLine.Option(names={"--kadaster-password"}) String kadasterPassword, @CommandLine.Option(names={"--url"}, defaultValue="https://bag.kadaster.nl/lvbag/bag-bestanden/api/bestanden") String url, @CommandLine.Option(names={"--query-params"}, defaultValue="artikelnummers=2529") String queryParams, @CommandLine.Option(names={"-h", "--help"}, usageHelp=true) boolean showHelp) throws Exception {
        log.info((Object)BAG2LoaderUtils.getUserAgent());
        Instant start = Instant.now();
        CookieManager kadasterCookieManager = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
        BAG2MutatiesCommand.mijnKadasterLogin(URI.create(url), kadasterUser, kadasterPassword, kadasterCookieManager);
        JSONArray bestanden = BAG2MutatiesCommand.getBagBestanden(url, queryParams, kadasterCookieManager);
        log.info((Object)("Aantal beschikbare bestanden: " + bestanden.length()));
        ArrayList<String> urls = new ArrayList<String>();
        for (int i = 0; i < bestanden.length(); ++i) {
            JSONObject bestand = bestanden.getJSONObject(i);
            urls.add(bestand.getString("url"));
        }
        try (BAG2Database db = this.parent.getBAG2Database(dbOptions);){
            BAG2ProgressReporter progressReporter = progressOptions.isConsoleProgressEnabled() ? new BAG2ConsoleProgressReporter() : new BAG2ProgressReporter();
            this.parent.applyMutaties(db, dbOptions, loadOptions, progressReporter, (String[])urls.toArray(String[]::new), kadasterCookieManager);
            log.info((Object)("Alle mutatiebestanden verwerkt in " + Utils.formatTimeSince((Instant)start)));
            int n = 0;
            return n;
        }
    }

    private static void mijnKadasterLogin(URI forUri, String username, String password, CookieManager cookieManager) throws IOException, InterruptedException {
        if (!forUri.getHost().endsWith("kadaster.nl")) {
            return;
        }
        if (username == null || password == null) {
            throw new IllegalArgumentException("Gebruikersnaam en wachtwoord zijn verplicht");
        }
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(KADASTER_LOGIN_URL)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(String.format("user=%s&password=%s", URLEncoder.encode(username, StandardCharsets.UTF_8), URLEncoder.encode(password, StandardCharsets.UTF_8)))).build();
        HttpClient httpClient = HttpClient.newBuilder().cookieHandler(cookieManager).build();
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 302) {
            throw new IllegalArgumentException(String.format("Fout bij inloggen op Mijn Kadaster met gebruikersnaam \"%s\"", username));
        }
        Map<String, List<String>> cookies = cookieManager.get(URI.create(KADASTER_LOGIN_URL), new HashMap<String, List<String>>());
        Optional<String> kadasterTicketIdCookie = cookies.getOrDefault("Cookie", List.of()).stream().filter(c -> c.startsWith("KadasterTicketId=")).findFirst();
        if (kadasterTicketIdCookie.isEmpty()) {
            throw new IllegalArgumentException("Geen KadasterTicketId cookie ontvangen na inloggen");
        }
    }

    private static JSONArray getBagBestanden(String url, String queryParams, CookieManager kadasterCookieManager) throws Exception {
        JSONArray bestanden;
        url = (String)url + "?" + queryParams;
        log.info((Object)("Opvragen bestanden JSON vanaf URL " + (String)url));
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create((String)url)).build();
        HttpClient httpClient = HttpClient.newBuilder().cookieHandler(kadasterCookieManager).build();
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        try {
            bestanden = new JSONArray(response.body());
        }
        catch (Exception e) {
            throw new Exception("Fout bij parsen BAG bestanden JSON, body: " + response.body(), e);
        }
        return bestanden;
    }

    private static void deleteZipFilesNotInBestanden(String downloadPath, JSONArray bestanden) throws IOException {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < bestanden.length(); ++i) {
            names.add(bestanden.getJSONObject(i).getString("naam"));
        }
        try (Stream<Path> stream = Files.list(Path.of(downloadPath, new String[0]));){
            stream.filter(p -> !Files.isDirectory(p, new LinkOption[0]) && p.getFileName().toString().endsWith(".zip") && !names.contains(p.getFileName().toString())).forEach(p -> {
                log.info((Object)("Verwijderen ZIP bestand niet in bestandenlijst: " + String.valueOf(p.getFileName())));
                try {
                    Files.delete(p);
                }
                catch (Exception e) {
                    log.error((Object)String.format("Fout bij verwijderen ZIP bestand %s: %s", p.getFileName(), e));
                }
            });
        }
    }
}

