/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classifier;

import it.geosolutions.jaiext.classifier.ColorMapTransform;
import it.geosolutions.jaiext.classifier.ColorMapTransformElement;
import it.geosolutions.jaiext.piecewise.GenericPiecewiseOpImage;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RasterClassifierOpImage<T extends ColorMapTransformElement>
extends GenericPiecewiseOpImage<T> {
    public static final String OPERATION_NAME = "RasterClassifier";

    public RasterClassifierOpImage(RenderedImage image, ColorMapTransform<T> lic, ImageLayout layout, Integer bandIndex, ROI roi, Range nodata, RenderingHints hints) {
        super(image, lic, RasterClassifierOpImage.prepareLayout(image, layout, lic), bandIndex, roi, nodata, RasterClassifierOpImage.prepareHints(hints), false);
        this.isByteData = false;
    }

    private static RenderingHints prepareHints(RenderingHints hints) {
        RenderingHints h = null;
        if (hints == null) {
            h = new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, false);
        } else {
            h = (RenderingHints)hints.clone();
            h.put(JAI.KEY_TRANSFORM_ON_COLORMAP, (Object)false);
        }
        return h;
    }

    private static <T extends ColorMapTransformElement> ImageLayout prepareLayout(RenderedImage image, ImageLayout layout, ColorMapTransform<T> lic) {
        IndexColorModel finalColorModel = lic.getColorModel();
        SampleModel finalSampleModel = lic.getSampleModel(image.getWidth(), image.getHeight());
        if (layout == null) {
            layout = new ImageLayout();
        }
        layout.setColorModel((ColorModel)finalColorModel);
        layout.setSampleModel(finalSampleModel);
        return layout;
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        Raster[] sourceRasters = new Raster[]{sources[0].getData()};
        this.computeRect(sourceRasters, dest, destRect);
    }
}

