/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.simple.PolygonEncoder;
import org.geotools.xml.Encoder;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class MultiPolygonEncoder
extends GeometryEncoder<MultiPolygon> {
    static final QualifiedName MULTI_SURFACE = new QualifiedName("http://www.opengis.net/gml", "MultiSurface", "gml");
    static final QualifiedName SURFACE_MEMBER = new QualifiedName("http://www.opengis.net/gml", "surfaceMember", "gml");
    QualifiedName multiSurface;
    QualifiedName surfaceMember;
    PolygonEncoder pe;

    protected MultiPolygonEncoder(Encoder encoder, String gmlPrefix) {
        super(encoder);
        this.pe = new PolygonEncoder(encoder, gmlPrefix);
        this.multiSurface = MULTI_SURFACE.derive(gmlPrefix);
        this.surfaceMember = SURFACE_MEMBER.derive(gmlPrefix);
    }

    public void encode(MultiPolygon geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.multiSurface, (Attributes)atts);
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            handler.startElement(this.surfaceMember, null);
            this.pe.encode((Polygon)geometry.getGeometryN(i), null, handler);
            handler.endElement(this.surfaceMember);
        }
        handler.endElement(this.multiSurface);
    }
}

