/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.memory.MemoryFeatureReader;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MemoryFeatureSource
extends ContentFeatureSource {
    String typeName;
    SimpleFeatureType featureType;

    public MemoryFeatureSource(ContentEntry entry, Query query) {
        super(entry, query);
        this.typeName = entry.getTypeName();
        this.featureType = this.getDataStore().schema.get(this.typeName);
    }

    @Override
    public MemoryDataStore getDataStore() {
        return (MemoryDataStore)super.getDataStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            ReferencedEnvelope bounds = ReferencedEnvelope.create((CoordinateReferenceSystem)this.getSchema().getCoordinateReferenceSystem());
            try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.getReaderInternal(query);){
                while (featureReader.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureReader.next();
                    bounds.include(feature.getBounds());
                }
            }
            return bounds;
        }
        return null;
    }

    @Override
    protected int getCountInternal(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            return this.getDataStore().features(this.typeName).size();
        }
        return -1;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new MemoryFeatureReader(this.getState(), query);
    }

    @Override
    protected SimpleFeatureType buildFeatureType() {
        return this.featureType;
    }

    @Override
    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return super.handleVisitor(query, visitor);
    }
}

