/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.gml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.OperationNotSupportedException;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.gml.ChoiceAttributeType;
import org.geotools.xml.gml.ChoiceAttributeTypeImpl;
import org.geotools.xml.gml.ChoiceGeometryTypeImpl;
import org.geotools.xml.gml.FCBuffer;
import org.geotools.xml.gml.GMLFeatureCollection;
import org.geotools.xml.gml.GMLSchema;
import org.geotools.xml.schema.All;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.xLink.XLinkSchema;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class GMLComplexTypes {
    protected static Logger logger = GMLComplexTypes.getLogger();
    private static final String STREAM_FEATURE_NAME_HINT = "org.geotools.xml.gml.STREAM_FEATURE_NAME_HINT";

    private static final Logger getLogger() {
        Logger l = Logging.getLogger((String)"net.refractions.gml.static");
        l.setLevel(Level.WARNING);
        return l;
    }

    static void encode(Element e, Geometry g, PrintHandler output) throws OperationNotSupportedException, IOException {
        if (g instanceof Point) {
            GMLComplexTypes.encode(e, (Point)g, output);
            return;
        }
        if (g instanceof Polygon) {
            GMLComplexTypes.encode(e, (Polygon)g, output);
            return;
        }
        if (g instanceof LinearRing) {
            GMLComplexTypes.encode(e, (LinearRing)g, output);
            return;
        }
        if (g instanceof LineString) {
            GMLComplexTypes.encode(e, (LineString)g, output);
            return;
        }
        if (g instanceof MultiLineString) {
            GMLComplexTypes.encode(e, (MultiLineString)g, output);
            return;
        }
        if (g instanceof MultiPolygon) {
            GMLComplexTypes.encode(e, (MultiPolygon)g, output);
            return;
        }
        if (g instanceof MultiPoint) {
            GMLComplexTypes.encode(e, (MultiPoint)g, output);
            return;
        }
        if (g instanceof GeometryCollection) {
            GMLComplexTypes.encode(e, (GeometryCollection)g, output);
            return;
        }
    }

    static void encode(Element e, Point g, PrintHandler output) throws IOException {
        if (g == null || g.getCoordinate() == null) {
            throw new IOException("Bad Point Data");
        }
        AttributesImpl ai = GMLComplexTypes.getSrsNameAttribute(g);
        if (e == null) {
            output.startElement(GMLSchema.NAMESPACE, "Point", ai);
        } else {
            output.startElement(e.getNamespace(), e.getName(), ai);
        }
        GMLComplexTypes.encodeCoords(null, g.getCoordinates(), output);
        if (e == null) {
            output.endElement(GMLSchema.NAMESPACE, "Point");
        } else {
            output.endElement(e.getNamespace(), e.getName());
        }
    }

    private static AttributesImpl getSrsNameAttribute(Geometry g) {
        AttributesImpl ai = new AttributesImpl();
        if (g.getUserData() != null) {
            if (g.getUserData() instanceof String) {
                ai.addAttribute("", "srsName", "", "anyURI", (String)g.getUserData());
            } else if (g.getUserData() instanceof CoordinateReferenceSystem) {
                CoordinateReferenceSystem crs = (CoordinateReferenceSystem)g.getUserData();
                try {
                    Integer code = CRS.lookupEpsgCode(crs, false);
                    if (code != null) {
                        ai.addAttribute("", "srsName", "", "anyURI", "EPSG:" + code);
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Could not encode the srsName for geometry, no EPSG code found", ex);
                }
            }
        } else {
            ai = null;
        }
        return ai;
    }

    static void encode(Element e, LineString g, PrintHandler output) throws IOException {
        if (g == null || g.getNumPoints() == 0) {
            throw new IOException("Bad LineString Data");
        }
        AttributesImpl ai = GMLComplexTypes.getSrsNameAttribute(g);
        if (e == null) {
            output.startElement(GMLSchema.NAMESPACE, "LineString", ai);
        } else {
            output.startElement(e.getNamespace(), e.getName(), ai);
        }
        GMLComplexTypes.encodeCoords(null, g.getCoordinates(), output);
        if (e == null) {
            output.endElement(GMLSchema.NAMESPACE, "LineString");
        } else {
            output.endElement(e.getNamespace(), e.getName());
        }
    }

    static void encode(Element e, LinearRing g, PrintHandler output) throws IOException {
        if (g == null || g.getNumPoints() == 0) {
            throw new IOException("Bad LinearRing Data");
        }
        if (e == null) {
            GMLComplexTypes.encode(GMLSchema.getInstance().getElements()[39], (LineString)g, output);
        } else {
            GMLComplexTypes.encode(e, (LineString)g, output);
        }
    }

    static void encode(Element e, Polygon g, PrintHandler output) throws OperationNotSupportedException, IOException {
        if (g == null || g.getNumPoints() == 0) {
            throw new IOException("Bad Polygon Data");
        }
        AttributesImpl ai = GMLComplexTypes.getSrsNameAttribute(g);
        if (e == null) {
            output.startElement(GMLSchema.NAMESPACE, "Polygon", ai);
        } else {
            output.startElement(e.getNamespace(), e.getName(), ai);
        }
        GMLSchema.getInstance().getElements()[35].getType().encode(GMLSchema.getInstance().getElements()[35], g.getExteriorRing(), output, null);
        if (g.getNumInteriorRing() > 0) {
            for (int i = 0; i < g.getNumInteriorRing(); ++i) {
                GMLSchema.getInstance().getElements()[36].getType().encode(GMLSchema.getInstance().getElements()[36], g.getInteriorRingN(i), output, null);
            }
        }
        if (e == null) {
            output.endElement(GMLSchema.NAMESPACE, "Polygon");
        } else {
            output.endElement(e.getNamespace(), e.getName());
        }
    }

    static void encode(Element e, MultiPoint g, PrintHandler output) throws IOException {
        if (g == null || g.getNumGeometries() <= 0) {
            throw new IOException("Bad MultiPoint Data");
        }
        AttributesImpl ai = GMLComplexTypes.getSrsNameAttribute(g);
        if (e == null) {
            output.startElement(GMLSchema.NAMESPACE, "MultiPoint", ai);
        } else {
            output.startElement(e.getNamespace(), e.getName(), ai);
        }
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            output.startElement(GMLSchema.NAMESPACE, "pointMember", null);
            GMLComplexTypes.encode(null, (Point)g.getGeometryN(i), output);
            output.endElement(GMLSchema.NAMESPACE, "pointMember");
        }
        if (e == null) {
            output.endElement(GMLSchema.NAMESPACE, "MultiPoint");
        } else {
            output.endElement(e.getNamespace(), e.getName());
        }
    }

    static void encode(Element e, MultiLineString g, PrintHandler output) throws IOException {
        if (g == null || g.getNumGeometries() <= 0) {
            throw new IOException("Bad MultiLineString Data");
        }
        AttributesImpl ai = GMLComplexTypes.getSrsNameAttribute(g);
        if (e == null) {
            output.startElement(GMLSchema.NAMESPACE, "MultiLineString", ai);
        } else {
            output.startElement(e.getNamespace(), e.getName(), ai);
        }
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            output.startElement(GMLSchema.NAMESPACE, "lineStringMember", null);
            GMLComplexTypes.encode(null, (LineString)g.getGeometryN(i), output);
            output.endElement(GMLSchema.NAMESPACE, "lineStringMember");
        }
        if (e == null) {
            output.endElement(GMLSchema.NAMESPACE, "MultiLineString");
        } else {
            output.endElement(e.getNamespace(), e.getName());
        }
    }

    static void encode(Element e, MultiPolygon g, PrintHandler output) throws OperationNotSupportedException, IOException {
        if (g == null || g.getNumGeometries() <= 0) {
            throw new IOException("Bad MultiPolygon Data");
        }
        AttributesImpl ai = GMLComplexTypes.getSrsNameAttribute(g);
        if (e == null) {
            output.startElement(GMLSchema.NAMESPACE, "MultiPolygon", ai);
        } else {
            output.startElement(e.getNamespace(), e.getName(), ai);
        }
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            output.startElement(GMLSchema.NAMESPACE, "polygonMember", null);
            GMLComplexTypes.encode(null, (Polygon)g.getGeometryN(i), output);
            output.endElement(GMLSchema.NAMESPACE, "polygonMember");
        }
        if (e == null) {
            output.endElement(GMLSchema.NAMESPACE, "MultiPolygon");
        } else {
            output.endElement(e.getNamespace(), e.getName());
        }
    }

    static void encode(Element e, GeometryCollection g, PrintHandler output) throws OperationNotSupportedException, IOException {
        if (g == null || g.getNumGeometries() <= 0) {
            throw new IOException("Bad GeometryCollection Data");
        }
        AttributesImpl ai = GMLComplexTypes.getSrsNameAttribute(g);
        if (e == null) {
            output.startElement(GMLSchema.NAMESPACE, "MultiGeometry", ai);
        } else {
            output.startElement(e.getNamespace(), e.getName(), ai);
        }
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            output.startElement(GMLSchema.NAMESPACE, "geometryMember", null);
            GMLComplexTypes.encode(null, (Polygon)g.getGeometryN(i), output);
            output.endElement(GMLSchema.NAMESPACE, "geometryMember");
        }
        if (e == null) {
            output.endElement(GMLSchema.NAMESPACE, "MultiGeometry");
        } else {
            output.endElement(e.getNamespace(), e.getName());
        }
    }

    static void encodeCoord(Element e, Coordinate coord, PrintHandler output) throws IOException {
        if (coord == null) {
            return;
        }
        AttributesImpl ai = new AttributesImpl();
        ai.addAttribute("", "X", "", "decimal", "" + coord.x);
        ai.addAttribute("", "Y", "", "decimal", "" + coord.y);
        if (coord.z != Double.NaN) {
            ai.addAttribute("", "Z", "", "decimal", "" + coord.z);
        }
        if (e == null) {
            output.element(GMLSchema.NAMESPACE, "coord", ai);
        } else {
            output.element(e.getNamespace(), e.getName(), ai);
        }
    }

    static void encodeCoords(Element e, CoordinateSequence coords, PrintHandler output) throws IOException {
        if (coords == null || coords.size() == 0) {
            return;
        }
        GMLComplexTypes.encodeCoords(e, coords.toCoordinateArray(), output);
    }

    static void encodeCoords(Element e, Coordinate[] coords, PrintHandler output) throws IOException {
        if (coords == null || coords.length == 0) {
            return;
        }
        AttributesImpl ai = new AttributesImpl();
        String dec = ".";
        String cs = ",";
        String ts = " ";
        ai.addAttribute("", "decimal", "", "string", dec);
        ai.addAttribute("", "cs", "", "string", cs);
        ai.addAttribute("", "ts", "", "string", ts);
        if (e == null) {
            output.startElement(GMLSchema.NAMESPACE, "coordinates", ai);
        } else {
            output.startElement(e.getNamespace(), e.getName(), ai);
        }
        Coordinate c = coords[0];
        if (Double.isNaN(c.z)) {
            output.characters(c.x + cs + c.y);
        } else {
            output.characters(c.x + cs + c.y + cs + c.z);
        }
        for (int i = 1; i < coords.length; ++i) {
            c = coords[i];
            if (Double.isNaN(c.z)) {
                output.characters(ts + c.x + cs + c.y);
                continue;
            }
            output.characters(ts + c.x + cs + c.y + cs + c.z);
        }
        if (e == null) {
            output.endElement(GMLSchema.NAMESPACE, "coordinates");
        } else {
            output.endElement(e.getNamespace(), e.getName());
        }
    }

    static void encodeCoords(Element e, Envelope env, PrintHandler output) throws IOException {
        if (env == null) {
            return;
        }
        AttributesImpl ai = new AttributesImpl();
        String dec = ".";
        String cs = ",";
        String ts = " ";
        ai.addAttribute("", "decimal", "", "string", dec);
        ai.addAttribute("", "cs", "", "string", cs);
        ai.addAttribute("", "ts", "", "string", ts);
        if (e == null) {
            output.startElement(GMLSchema.NAMESPACE, "coordinates", ai);
        } else {
            output.startElement(e.getNamespace(), e.getName(), ai);
        }
        output.characters(env.getMinX() + cs + env.getMinY() + ts + env.getMaxX() + cs + env.getMaxY());
        if (e == null) {
            output.endElement(GMLSchema.NAMESPACE, "coordinates");
        } else {
            output.endElement(e.getNamespace(), e.getName());
        }
    }

    public static SimpleFeatureType createFeatureType(Element element) throws SAXException {
        String ftName = element.getName();
        URI ftNS = element.getType().getNamespace();
        logger.finest("Creating feature type for " + ftName + ":" + ftNS);
        SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
        build.setName(ftName);
        build.setNamespaceURI(ftNS);
        GeometryDescriptor geometryAttribute = null;
        ElementGrouping child = ((ComplexType)element.getType()).getChild();
        AttributeDescriptor[] attrs = GMLComplexTypes.getAttributes(element.getName(), child).toArray(new AttributeDescriptor[0]);
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i] == null) continue;
            build.add(attrs[i]);
            if (geometryAttribute != null || !(attrs[i] instanceof GeometryDescriptor) || attrs[i].getLocalName().equalsIgnoreCase(AbstractFeatureType.getInstance().getChildElements()[2].getName())) continue;
            geometryAttribute = (GeometryDescriptor)attrs[i];
        }
        if (geometryAttribute != null) {
            build.setDefaultGeometry(geometryAttribute.getLocalName());
        }
        try {
            SimpleFeatureType ft = build.buildFeatureType();
            return ft;
        }
        catch (IllegalArgumentException e) {
            logger.warning(e.toString());
            throw new SAXException(e);
        }
    }

    public static SimpleFeatureType createFeatureType(ComplexType element) throws SAXException {
        String ftName = element.getName();
        URI ftNS = element.getNamespace();
        logger.finest("Creating feature type for " + ftName + ":" + ftNS);
        SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
        build.setNamespaceURI(ftNS);
        build.setName(ftName);
        GeometryDescriptor geometryAttribute = null;
        ElementGrouping child = element.getChild();
        List<AttributeDescriptor> attrs = GMLComplexTypes.getAttributes(element.getName(), child);
        for (AttributeDescriptor attributeDescriptor : attrs) {
            if (attributeDescriptor == null) continue;
            build.add(attributeDescriptor);
            if (geometryAttribute != null || !(attributeDescriptor instanceof GeometryDescriptor) || attributeDescriptor.getLocalName().equalsIgnoreCase(AbstractFeatureType.getInstance().getChildElements()[2].getName())) continue;
            geometryAttribute = (GeometryDescriptor)attributeDescriptor;
        }
        if (geometryAttribute != null) {
            build.setDefaultGeometry(geometryAttribute.getLocalName());
        }
        try {
            SimpleFeatureType ft = build.buildFeatureType();
            return ft;
        }
        catch (IllegalArgumentException e) {
            logger.warning(e.toString());
            throw new SAXException(e);
        }
    }

    private static List<AttributeDescriptor> getAttributes(String name, ElementGrouping eg) {
        LinkedList<AttributeDescriptor> attributes = new LinkedList<AttributeDescriptor>();
        AttributeDescriptor t = null;
        switch (eg.getGrouping()) {
            case 16: {
                t = GMLComplexTypes.getAttribute(name, (Choice)eg);
                if (t == null) break;
                attributes.add(t);
                break;
            }
            case 2: {
                attributes.addAll(GMLComplexTypes.getAttributes(name, ((Group)eg).getChild()));
                break;
            }
            case 1: {
                t = GMLComplexTypes.getAttribute((Element)eg);
                if (t != null) {
                    attributes.add(t);
                }
                return attributes;
            }
            case 32: {
                Element[] elems = ((All)eg).getElements();
                if (elems == null) break;
                for (int i = 0; i < elems.length; ++i) {
                    attributes.add(GMLComplexTypes.getAttribute(elems[i]));
                }
                break;
            }
            case 8: {
                ElementGrouping[] children = ((Sequence)eg).getChildren();
                if (children == null) break;
                for (int i = 0; i < children.length; ++i) {
                    attributes.addAll(GMLComplexTypes.getAttributes(name, children[i]));
                }
                break;
            }
        }
        return attributes;
    }

    private static AttributeDescriptor getAttribute(Element eg) {
        boolean nillable;
        if (eg.getNamespace() == GMLSchema.NAMESPACE && (AbstractFeatureType.getInstance().getChildElements()[0] == eg || AbstractFeatureType.getInstance().getChildElements()[1] == eg || AbstractFeatureType.getInstance().getChildElements()[2] == eg)) {
            return null;
        }
        Class type = Object.class;
        if (eg.getType() != null) {
            if (eg.getType() instanceof SimpleType) {
                type = eg.getType().getInstanceType();
            } else if (Object.class.equals((Object)eg.getType().getInstanceType()) || Object[].class.equals((Object)eg.getType().getInstanceType())) {
                ElementGrouping child = ((ComplexType)eg.getType()).getChild();
                if (child != null) {
                    List<AttributeDescriptor> l = GMLComplexTypes.getAttributes(eg.getName(), child);
                    if (l.isEmpty()) {
                        type = eg.getType().getInstanceType();
                    } else {
                        if (l.size() == 1) {
                            return l.iterator().next();
                        }
                        type = GMLComplexTypes.getCommonType(l);
                    }
                } else {
                    type = eg.getType().getInstanceType();
                }
            } else {
                type = eg.getType().getInstanceType();
            }
        }
        if (type == null) {
            type = Object.class;
        }
        boolean bl = nillable = eg.isNillable() || eg.getMinOccurs() == 0;
        if (!nillable) {
            try {
                Object defaultValue = DataUtilities.defaultValue((Class)type);
                AttributeTypeBuilder build = new AttributeTypeBuilder();
                build.setName(eg.getName());
                build.setBinding(type);
                build.setNillable(nillable);
                build.setDefaultValue(defaultValue);
                return build.buildDescriptor(eg.getName());
            }
            catch (IllegalArgumentException e) {
                logger.warning("Don't know how to make a default value for: " + type + ". Consider making it nillable.");
                AttributeTypeBuilder build = new AttributeTypeBuilder();
                build.setName(eg.getName());
                build.setBinding(type);
                build.setNillable(nillable);
                return build.buildDescriptor(eg.getName());
            }
        }
        AttributeTypeBuilder build = new AttributeTypeBuilder();
        build.setName(eg.getName());
        build.setBinding(type);
        build.setNillable(nillable);
        return build.buildDescriptor(eg.getName());
    }

    private static AttributeDescriptor getAttribute(String name, Choice eg) {
        boolean nillable;
        LinkedList<AttributeDescriptor> l = new LinkedList<AttributeDescriptor>();
        ElementGrouping[] children = eg.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                l.addAll(GMLComplexTypes.getAttributes(name, children[i]));
            }
        }
        if (l.isEmpty()) {
            return null;
        }
        if (l.size() == 1) {
            return (AttributeDescriptor)l.iterator().next();
        }
        Class<Object> type = GMLComplexTypes.getCommonType(l);
        if (type == null) {
            type = Object.class;
        }
        boolean bl = nillable = eg.getMinOccurs() == 0;
        if (!nillable && children != null) {
            for (int i = 0; i < children.length && !nillable; ++i) {
                if (eg.getMinOccurs() != 0) continue;
                nillable = true;
            }
        }
        Class[] choices = GMLComplexTypes.collectionChoices(l);
        NameImpl typeName = new NameImpl(name);
        if (Geometry.class.isAssignableFrom(type)) {
            return new ChoiceGeometryTypeImpl((Name)typeName, choices, type, nillable, 1, 1, null, null, Collections.EMPTY_LIST);
        }
        return new ChoiceAttributeTypeImpl((Name)typeName, choices, type, nillable, 1, 1, null, Collections.EMPTY_LIST);
    }

    private static Class[] collectionChoices(List l) {
        Class[] choices = new Class[l.size()];
        int i = 0;
        for (AttributeDescriptor type : l) {
            choices[i] = type.getType().getBinding();
            ++i;
        }
        return choices;
    }

    private static Class getCommonType(List AttributeDescriptors) {
        if (AttributeDescriptors == null || AttributeDescriptors.isEmpty()) {
            return null;
        }
        if (AttributeDescriptors.size() == 1) {
            return AttributeDescriptors.iterator().next().getClass();
        }
        Class common = null;
        AttributeDescriptor at2 = null;
        for (AttributeDescriptor at2 : AttributeDescriptors) {
            if (at2 == null) continue;
            if (common == null) {
                common = at2.getType().getBinding();
                continue;
            }
            Class t = at2.getType().getBinding();
            if (t == null || common.isAssignableFrom(t)) continue;
            if (t.isAssignableFrom(common)) {
                common = t;
                continue;
            }
            int selection = GMLComplexTypes.findCompatible(common, t);
            switch (selection) {
                case 0: {
                    common = GMLComplexTypes.findCommon(common, t);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    common = t;
                    break;
                }
            }
        }
        return common;
    }

    private static int findCompatible(Class c1, Class c2) {
        if (c1 == Polygon.class && c2 == MultiPolygon.class) {
            return 2;
        }
        if (c2 == Polygon.class && c1 == MultiPolygon.class) {
            return 1;
        }
        if (c1 == Point.class && c2 == MultiPoint.class) {
            return 2;
        }
        if (c2 == Point.class && c1 == MultiPoint.class) {
            return 1;
        }
        if (c1 == LineString.class && c2 == MultiLineString.class) {
            return 2;
        }
        if (c2 == LineString.class && c1 == MultiLineString.class) {
            return 1;
        }
        if (c1 == Geometry.class && c2 == GeometryCollection.class) {
            return 2;
        }
        if (c2 == Geometry.class && c1 == GeometryCollection.class) {
            return 1;
        }
        return 0;
    }

    private static Class findCommon(Class c1, Class c2) {
        if (Object.class == c1) {
            return c2;
        }
        if (Object.class == c2) {
            return c1;
        }
        Class p1 = c1.getSuperclass();
        if (p1.isAssignableFrom(c2)) {
            return p1;
        }
        Class p2 = c2.getSuperclass();
        if (p2.isAssignableFrom(c1)) {
            return p2;
        }
        Class t = GMLComplexTypes.findCommon(p1, p2);
        if (t != Object.class) {
            return t;
        }
        Class<?>[] it1 = c1.getInterfaces();
        Class<?>[] it2 = c2.getInterfaces();
        if (it1 != null && it1.length > 0 && it2 != null && it2.length > 0) {
            for (int i = 0; i < it1.length; ++i) {
                for (int j = 0; j < it2.length; ++j) {
                    if (it1[i].isAssignableFrom(it2[j])) {
                        return it1[i];
                    }
                    if (!it2[j].isAssignableFrom(it1[i])) continue;
                    return it2[j];
                }
            }
        }
        return Object.class;
    }

    public static class MultiGeometryPropertyType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new MultiGeometryPropertyType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("MultiGeometry", GeometryCollectionType.getInstance(), 0, 1, false, new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 1, 1, true, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return FeatureAssociationType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "MultiGeometryPropertyType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1) {
                throw new SAXException("must be one geometry");
            }
            Object value2 = value[0].getValue();
            return (GeometryCollection)value2;
        }

        @Override
        public Class getInstanceType() {
            return GeometryCollection.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            if (value == null || !(value instanceof GeometryCollection)) {
                return false;
            }
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (value == null || !(value instanceof GeometryCollection)) {
                throw new OperationNotSupportedException("Value is " + value == null ? "null" : value.getClass().getName());
            }
            if (element == null) {
                output.startElement(GMLSchema.NAMESPACE, "multiGeometryProperty", null);
                GMLComplexTypes.encode(null, (GeometryCollection)value, output);
                output.endElement(GMLSchema.NAMESPACE, "multiGeometryProperty");
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
                GMLComplexTypes.encode(null, (GeometryCollection)value, output);
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    public static class MultiPolygonPropertyType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new MultiPolygonPropertyType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("MultiPolygon", MultiPolygonType.getInstance(), 0, 1, false, new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 1, 1, true, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return FeatureAssociationType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "MultiPolygonPropertyType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1) {
                throw new SAXException("must be one geometry");
            }
            Object value2 = value[0].getValue();
            return (MultiPolygon)value2;
        }

        @Override
        public Class getInstanceType() {
            return MultiPolygon.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            if (value == null || !(value instanceof MultiPolygon)) {
                return false;
            }
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (value == null || !(value instanceof MultiPolygon)) {
                throw new OperationNotSupportedException("Value is " + value == null ? "null" : value.getClass().getName());
            }
            if (element == null) {
                output.startElement(GMLSchema.NAMESPACE, "multiPolygonProperty", null);
                GMLComplexTypes.encode(null, (MultiPolygon)value, output);
                output.endElement(GMLSchema.NAMESPACE, "multiPolygonProperty");
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
                GMLComplexTypes.encode(null, (MultiPolygon)value, output);
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    public static class MultiLineStringPropertyType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new MultiLineStringPropertyType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("MultiLineString", MultiLineStringType.getInstance(), 0, 1, false, new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 1, 1, true, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return FeatureAssociationType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "MultiLineStringPropertyType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1) {
                throw new SAXException("must be one geometry");
            }
            Object value2 = value[0].getValue();
            return (MultiLineString)value2;
        }

        @Override
        public Class getInstanceType() {
            return MultiLineString.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            if (value == null || !(value instanceof MultiLineString)) {
                return false;
            }
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (value == null || !(value instanceof MultiLineString)) {
                throw new OperationNotSupportedException("Value is " + value == null ? "null" : value.getClass().getName());
            }
            if (element == null) {
                output.startElement(GMLSchema.NAMESPACE, "multiLineStringProperty", null);
                GMLComplexTypes.encode(null, (MultiLineString)value, output);
                output.endElement(GMLSchema.NAMESPACE, "multiLineStringProperty");
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
                GMLComplexTypes.encode(null, (MultiLineString)value, output);
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    public static class MultiPointPropertyType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new MultiPointPropertyType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("MultiPoint", MultiPointType.getInstance(), 0, 1, false, new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 1, 1, true, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return FeatureAssociationType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "MultiPointPropertyType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1) {
                throw new SAXException("must be one geometry");
            }
            Object value2 = value[0].getValue();
            return (MultiPoint)value2;
        }

        @Override
        public Class getInstanceType() {
            return MultiPoint.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            if (value == null || !(value instanceof MultiPoint)) {
                return false;
            }
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (value == null || !(value instanceof MultiPoint)) {
                throw new OperationNotSupportedException("Value is " + value == null ? "null" : value.getClass().getName());
            }
            if (element == null) {
                output.startElement(GMLSchema.NAMESPACE, "multiPointProperty", null);
                GMLComplexTypes.encode(null, (MultiPoint)value, output);
                output.endElement(GMLSchema.NAMESPACE, "multiPointProperty");
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
                GMLComplexTypes.encode(null, (MultiPoint)value, output);
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    public static class LineStringPropertyType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new LineStringPropertyType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("LineString", LineStringType.getInstance(), 0, 1, false, new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 1, 1, true, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return FeatureAssociationType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "LineStringPropertyType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1) {
                throw new SAXException("must be one geometry");
            }
            return (LineString)value[0].getValue();
        }

        @Override
        public Class getInstanceType() {
            return LineString.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            if (value == null || !(value instanceof LineString)) {
                return false;
            }
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (value == null || !(value instanceof LineString)) {
                throw new OperationNotSupportedException("Value is " + value == null ? "null" : value.getClass().getName());
            }
            if (element == null) {
                output.startElement(GMLSchema.NAMESPACE, "lineStringProperty", null);
                GMLComplexTypes.encode(null, (LineString)value, output);
                output.endElement(GMLSchema.NAMESPACE, "lineStringProperty");
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
                GMLComplexTypes.encode(null, (LineString)value, output);
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    public static class PolygonPropertyType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new PolygonPropertyType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("Polygon", PolygonType.getInstance(), 0, 1, false, new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 1, 1, true, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return FeatureAssociationType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "PolygonPropertyType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1) {
                throw new SAXException("must be one geometry");
            }
            return (Polygon)value[0].getValue();
        }

        @Override
        public Class getInstanceType() {
            return Polygon.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            if (value == null || !(value instanceof Polygon)) {
                return false;
            }
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (value == null || !(value instanceof Polygon)) {
                throw new OperationNotSupportedException("Value is " + value == null ? "null" : value.getClass().getName());
            }
            if (element == null) {
                output.startElement(GMLSchema.NAMESPACE, "polygonProperty", null);
                GMLComplexTypes.encode(null, (Polygon)value, output);
                output.endElement(GMLSchema.NAMESPACE, "polygonProperty");
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
                GMLComplexTypes.encode(null, (Polygon)value, output);
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    public static class PointPropertyType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new PointPropertyType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("Point", PointType.getInstance(), 0, 1, false, new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 1, 1, true, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return FeatureAssociationType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "PointPropertyType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1) {
                throw new SAXException("must be one geometry");
            }
            return (Point)value[0].getValue();
        }

        @Override
        public Class getInstanceType() {
            return Point.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            if (value == null || !(value instanceof Point)) {
                return false;
            }
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (value == null || !(value instanceof Point)) {
                throw new OperationNotSupportedException("Value is " + value == null ? "null" : value.getClass().getName());
            }
            if (element == null) {
                output.startElement(GMLSchema.NAMESPACE, "pointProperty", null);
                GMLComplexTypes.encode(null, (Point)value, output);
                output.endElement(GMLSchema.NAMESPACE, "pointProperty");
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
                GMLComplexTypes.encode(null, (Point)value, output);
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    public static class BoundingShapeType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new BoundingShapeType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("Box", BoxType.getInstance(), 1, 1, false, null), new GMLSchema.GMLElement("null", new GMLSchema.GMLNullType(), 1, 1, false, null)};
        private static final DefaultChoice seq = new DefaultChoice(elements);
        private static final Geometry NULL_ENV;

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return null;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "BoundingShapeType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1) {
                throw new SAXException("must be one geometry");
            }
            return value[0].getValue() instanceof Geometry ? (Geometry)value[0].getValue() : NULL_ENV;
        }

        @Override
        public Class getInstanceType() {
            return Geometry.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            if (value == null || element == null || !(value instanceof Geometry)) {
                return false;
            }
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!(value instanceof Geometry)) {
                return;
            }
            if (element == null) {
                output.startElement(GMLSchema.NAMESPACE, "boundedBy", null);
                BoxType.getInstance().encode(null, value, output, hints);
                output.endElement(GMLSchema.NAMESPACE, "boundedBy");
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
                BoxType.getInstance().encode(null, value, output, hints);
                output.endElement(element.getNamespace(), element.getName());
            }
        }

        static {
            GeometryFactory fac = new GeometryFactory();
            NULL_ENV = fac.toGeometry(new Envelope());
        }
    }

    public static class FeatureAssociationType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new FeatureAssociationType();
        protected static final Attribute[] attributes = FeatureAssociationType.loadAttributes();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("_Feature", AbstractFeatureType.getInstance(), 0, 1, true, null)};
        static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        private static Attribute[] loadAttributes() {
            Attribute[] gp = XLinkSchema.SimpleLink.getInstance().getAttributes();
            Attribute[] r = new Attribute[gp.length + 1];
            for (int i = 1; i < gp.length; ++i) {
                r[i] = gp[i];
            }
            r[gp.length] = GMLSchema.AttributeList.attributes1[0];
            return r;
        }

        @Override
        public Attribute[] getAttributes() {
            return attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "FeatureAssociationType";
        }

        public SimpleFeature getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1) {
                throw new SAXException("must be one feature " + value.length);
            }
            logger.finest(value[0].getValue() == null ? "null" : value[0].getValue().getClass().getName());
            return (SimpleFeature)value[0].getValue();
        }

        @Override
        public Class getInstanceType() {
            return SimpleFeature.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            if (!(value instanceof SimpleFeature)) {
                return false;
            }
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t == this;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!(value instanceof SimpleFeature)) {
                return;
            }
            if (element == null) {
                output.startElement(GMLSchema.NAMESPACE, "featureMember", null);
                AbstractFeatureType.getInstance().encode(null, value, output, hints);
                output.endElement(GMLSchema.NAMESPACE, "featureMember");
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
                AbstractFeatureType.getInstance().encode(element.findChildElement(((SimpleFeature)value).getFeatureType().getTypeName()), value, output, hints);
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    public static class GeometryPropertyType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new GeometryPropertyType();
        private static final Attribute[] attributes = GeometryPropertyType.loadAttributes();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 0, 1, true, null)};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        private static Attribute[] loadAttributes() {
            Attribute[] gp = XLinkSchema.SimpleLink.getInstance().getAttributes();
            Attribute[] r = new Attribute[gp.length + 1];
            for (int i = 1; i < gp.length; ++i) {
                r[i] = gp[i];
            }
            r[gp.length] = GMLSchema.AttributeList.attributes1[0];
            return r;
        }

        @Override
        public Attribute[] getAttributes() {
            return attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "GeometryPropertyType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1) {
                throw new SAXException("must be one geometry");
            }
            return (Geometry)value[0].getValue();
        }

        @Override
        public Class getInstanceType() {
            return Geometry.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof Geometry;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!(value instanceof Geometry)) {
                return;
            }
            Geometry g = (Geometry)value;
            if (element == null) {
                output.startElement(GMLSchema.NAMESPACE, "geometryProperty", null);
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
            }
            GMLComplexTypes.encode(null, g, output);
            if (element == null) {
                output.endElement(GMLSchema.NAMESPACE, "geometryProperty");
            } else {
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    public static class AbstractFeatureCollectionType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new AbstractFeatureCollectionType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("description", XSISimpleTypes.String.getInstance(), 0, 1, false, null), new GMLSchema.GMLElement("name", XSISimpleTypes.String.getInstance(), 0, 1, false, null), new GMLSchema.GMLElement("boundedBy", BoundingShapeType.getInstance(), 1, 1, false, null), new GMLSchema.GMLElement("featureMember", FeatureAssociationType.getInstance(), 0, Integer.MAX_VALUE, false, null)};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return null;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (hints == null || hints.get("org.geotools.xml.gml.STREAM_HINT") == null) {
                return this.getCollection(attrs, value);
            }
            FCBuffer fcb = (FCBuffer)hints.get("org.geotools.xml.gml.STREAM_HINT");
            fcb.state = -1;
            return null;
        }

        @Override
        public boolean cache(Element element, Map hints) {
            ComplexType e;
            if (hints == null || hints.get("org.geotools.xml.gml.STREAM_HINT") == null) {
                return true;
            }
            ComplexType complexType = e = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (e != null) {
                if (e.getName() != null && e.getName().equals(BoxType.getInstance().getName())) {
                    return true;
                }
                e = e.getParent() instanceof ComplexType ? (ComplexType)e.getParent() : null;
            }
            return false;
        }

        private SimpleFeatureCollection getCollection(Attributes attrs, ElementValue[] value) {
            String id = "";
            id = attrs.getValue("", "ID");
            if (id == null) {
                id = attrs.getValue(GMLSchema.NAMESPACE.toString(), "ID");
            }
            Object value2 = value[0].getValue();
            Envelope envelopeInternal = ((Geometry)value2).getEnvelopeInternal();
            GMLFeatureCollection fc = new GMLFeatureCollection(id, envelopeInternal);
            for (int i = 1; i < value.length; ++i) {
                fc.add((SimpleFeature)value[i].getValue());
            }
            return fc;
        }

        @Override
        public Class getInstanceType() {
            return FeatureCollection.class;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "AbstractFeatureCollectionType";
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof FeatureCollection && ((SimpleFeatureCollection)value).getBounds() != null;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (value == null || !(value instanceof FeatureCollection)) {
                return;
            }
            if (element == null) {
                output.startElement(GMLSchema.NAMESPACE, "_featureCollection", null);
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
            }
            SimpleFeatureCollection fc = (SimpleFeatureCollection)value;
            if (fc.getBounds() == null) {
                throw new IOException("Bounding box required for the FeatureCollection");
            }
            BoundingShapeType.getInstance().encode(null, fc.getBounds(), output, hints);
            SimpleFeatureIterator i = fc.features();
            Element e = null;
            while (i.hasNext()) {
                SimpleFeature f = (SimpleFeature)i.next();
                output.startElement(GMLSchema.NAMESPACE, "featureMember", null);
                if (e == null) {
                    ComplexType t;
                    e = output.findElement(f.getFeatureType().getTypeName());
                    ComplexType complexType = t = e.getType() instanceof ComplexType ? (ComplexType)e.getType() : null;
                    while (t != null && t != AbstractFeatureType.getInstance()) {
                        t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
                    }
                    if (t != AbstractFeatureType.getInstance()) {
                        e = output.findElement(value);
                        ComplexType complexType2 = t = e.getType() instanceof ComplexType ? (ComplexType)e.getType() : null;
                        while (t != null && t != AbstractFeatureType.getInstance()) {
                            t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
                        }
                        if (t != AbstractFeatureType.getInstance()) {
                            throw new OperationNotSupportedException("Could not find a correct Element for FeatureType " + f.getFeatureType().getTypeName());
                        }
                    }
                }
                if (e == null) {
                    throw new NullPointerException("Feature Definition not found in Schema " + element.getNamespace());
                }
                AbstractFeatureType.getInstance().encode(e, f, output, hints);
                output.endElement(GMLSchema.NAMESPACE, "featureMember");
            }
            if (element == null) {
                output.endElement(GMLSchema.NAMESPACE, "_featureCollection");
            } else {
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    public static class AbstractFeatureCollectionsBaseType
    extends AbstractFeatureType {
        private static final Element[] elements1 = new Element[]{new GMLSchema.GMLElement("description", XSISimpleTypes.String.getInstance(), 0, 1, false, null), new GMLSchema.GMLElement("name", XSISimpleTypes.String.getInstance(), 0, 1, false, null), new GMLSchema.GMLElement("boundedBy", BoundingShapeType.getInstance(), 1, 1, false, null)};
        private static final DefaultSequence seq1 = new DefaultSequence(elements1);
        private static final GMLSchema.GMLComplexType instance1 = new AbstractFeatureCollectionsBaseType();

        public static GMLSchema.GMLComplexType getInstance() {
            return instance1;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return AbstractFeatureType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq1;
        }

        @Override
        public String getName() {
            return "AbstractFeatureCollectionBaseType";
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements1.length; ++i) {
                if (!name.equals(elements1[i].getName())) continue;
                return elements1[i];
            }
            return null;
        }
    }

    public static class AbstractFeatureType
    extends GMLSchema.GMLComplexType {
        protected static final Attribute[] attributes = new Attribute[]{new GMLSchema.GMLAttribute("fid", XSISimpleTypes.ID.getInstance(), 0)};
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("description", XSISimpleTypes.String.getInstance(), 0, 1, false, null){

            @Override
            public boolean isNillable() {
                return true;
            }
        }, new GMLSchema.GMLElement("name", XSISimpleTypes.String.getInstance(), 0, 1, false, null){

            @Override
            public boolean isNillable() {
                return true;
            }
        }, new GMLSchema.GMLElement("boundedBy", BoundingShapeType.getInstance(), 0, 1, false, null){

            @Override
            public boolean isNillable() {
                return true;
            }
        }};
        private static final DefaultSequence seq = new DefaultSequence(elements);
        private static final GMLSchema.GMLComplexType instance = new AbstractFeatureType();
        private static final HashMap featureTypeMappings = new HashMap();

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "AbstractFeatureType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            String nm;
            if (hints == null || hints.get("org.geotools.xml.gml.STREAM_HINT") == null) {
                return this.getFeature(element, value, attrs, hints, null);
            }
            if (hints.get(GMLComplexTypes.STREAM_FEATURE_NAME_HINT) == null) {
                hints.put(GMLComplexTypes.STREAM_FEATURE_NAME_HINT, element.getName());
            }
            if ((nm = (String)hints.get(GMLComplexTypes.STREAM_FEATURE_NAME_HINT)) != null && nm.equals(element.getName())) {
                SimpleFeature f = this.getFeature(element, value, attrs, hints, ((FCBuffer)hints.get((Object)"org.geotools.xml.gml.STREAM_HINT")).ft);
                this.stream(f, (FCBuffer)hints.get("org.geotools.xml.gml.STREAM_HINT"));
                return null;
            }
            SimpleFeature f = this.getFeature(element, value, attrs, hints, null);
            return f;
        }

        public SimpleFeature getFeature(Element element, ElementValue[] value, Attributes attrs, Map hints, SimpleFeatureType ft) throws SAXException {
            int i;
            if (ft == null) {
                ft = (SimpleFeatureType)featureTypeMappings.get(element.getType().getNamespace() + "#" + element.getName());
            }
            if (ft == null) {
                ft = this.loadFeatureType(element, value, attrs);
            }
            Object[] values = new Object[ft.getAttributeCount()];
            for (i = 0; i < values.length; ++i) {
                values[i] = null;
            }
            for (i = 0; i < value.length; ++i) {
                int j = -1;
                this.setAttribute(value, ft, values, i, j);
            }
            String fid = attrs.getValue("", "fid");
            if (fid == null || "".equals(fid)) {
                fid = attrs.getValue(GMLSchema.NAMESPACE.toString(), "fid");
            }
            SimpleFeature rt = null;
            if (fid != null || !"".equals(fid)) {
                try {
                    rt = SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])values, (String)fid);
                }
                catch (IllegalAttributeException e) {
                    logger.warning(e.toString());
                    throw new SAXException((Exception)((Object)e));
                }
            }
            try {
                if (rt == null) {
                    rt = SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])values, null);
                }
            }
            catch (IllegalAttributeException e1) {
                logger.warning(e1.toString());
                throw new SAXException((Exception)((Object)e1));
            }
            return rt;
        }

        private void setAttribute(ElementValue[] value, SimpleFeatureType ft, Object[] values, int i, int j) {
            if ((j = this.searchByName(value, ft, i, j)) != -1) {
                this.assignValue(value, values, ft.getDescriptor(j), i, j);
            } else {
                this.searchByType(value, ft, values, i);
            }
        }

        private void searchByType(ElementValue[] value, SimpleFeatureType ft, Object[] values, int i) {
            if (value[i].getValue() != null) {
                if (this.isMatch(value, ft, i, i)) {
                    this.assignValue(value, values, ft.getDescriptor(i), i, i);
                    return;
                }
                for (int k = 0; k < ft.getAttributeCount(); ++k) {
                    if (!this.isMatch(value, ft, i, k) || values[i] != null) continue;
                    this.assignValue(value, values, ft.getDescriptor(k), i, k);
                }
            }
        }

        private void assignValue(ElementValue[] value, Object[] values, AttributeDescriptor at, int i, int k) {
            if (at instanceof ChoiceAttributeType) {
                ChoiceAttributeType choiceAT = (ChoiceAttributeType)at;
                values[k] = choiceAT.convert(value[i].getValue());
            } else {
                values[k] = value[i].getValue();
            }
        }

        private boolean isMatch(ElementValue[] value, SimpleFeatureType ft, int i, int k) {
            AttributeDescriptor AttributeDescriptor2 = ft.getDescriptor(k);
            String typeName = ft.getTypeName();
            if (!AttributeDescriptor2.getLocalName().equals(typeName)) {
                return false;
            }
            Class<?> instanceClass = value[i].getValue().getClass();
            if (AttributeDescriptor2 instanceof ChoiceAttributeType) {
                ChoiceAttributeType choiceAT = (ChoiceAttributeType)AttributeDescriptor2;
                Class[] choices = choiceAT.getChoices();
                for (int j = 0; j < choices.length; ++j) {
                    if (!choices[j].isAssignableFrom(instanceClass)) continue;
                    return true;
                }
            }
            return AttributeDescriptor2.getType().getBinding().isAssignableFrom(instanceClass);
        }

        private int searchByName(ElementValue[] value, SimpleFeatureType ft, int i, int j) {
            for (int k = 0; k < ft.getAttributeCount() && j == -1; ++k) {
                if ((ft.getDescriptor(k).getLocalName() != null || value[i].getElement().getName() != null) && !ft.getDescriptor(k).getLocalName().equals(value[i].getElement().getName())) continue;
                j = k;
            }
            return j;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stream(SimpleFeature feature, FCBuffer featureCollectionBuffer) throws SAXNotSupportedException, SAXException {
            if (!featureCollectionBuffer.addFeature(feature)) {
                throw new SAXException("Buffer overflow");
            }
            if (featureCollectionBuffer.state <= 0) {
                switch (featureCollectionBuffer.state) {
                    case -2: {
                        throw new FCBuffer.StopException();
                    }
                    case -1: {
                        return;
                    }
                }
                featureCollectionBuffer.state = (featureCollectionBuffer.getCapacity() - featureCollectionBuffer.getSize()) / 3;
                logger.finest("New State " + featureCollectionBuffer.state + " " + featureCollectionBuffer.getSize());
                while (featureCollectionBuffer.getSize() > featureCollectionBuffer.getCapacity() - 1) {
                    logger.finest("waiting for reader");
                    FCBuffer fCBuffer = featureCollectionBuffer;
                    synchronized (fCBuffer) {
                        try {
                            featureCollectionBuffer.wait(100L);
                        }
                        catch (InterruptedException e) {
                            throw new FCBuffer.StopException();
                        }
                    }
                    if (featureCollectionBuffer.state != -2) continue;
                    throw new FCBuffer.StopException();
                }
            } else {
                --featureCollectionBuffer.state;
                logger.finest("New State " + featureCollectionBuffer.state + " " + featureCollectionBuffer.getSize());
            }
        }

        @Override
        public Class getInstanceType() {
            return SimpleFeature.class;
        }

        private SimpleFeatureType loadFeatureType(Element element, ElementValue[] value, Attributes attrs) throws SAXException {
            SimpleFeatureType ft = GMLComplexTypes.createFeatureType(element);
            featureTypeMappings.put(element.getType().getNamespace() + "#" + element.getName(), ft);
            return ft;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            if (value == null || element == null || value instanceof FeatureCollection || !(value instanceof SimpleFeature)) {
                return false;
            }
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (this.canEncode(element, value, hints)) {
                SimpleFeature f = (SimpleFeature)value;
                if (element == null) {
                    this.print(f, output, hints);
                } else {
                    this.print(element, f, output, hints);
                }
            }
        }

        private void print(Element e, SimpleFeature f, PrintHandler ph, Map hints) throws OperationNotSupportedException, IOException {
            AttributesImpl ai = new AttributesImpl();
            if (f.getID() != null && !f.getID().equals("")) {
                ai.addAttribute("", "fid", "", "ID", f.getID());
            } else {
                ai = null;
            }
            ph.startElement(e.getNamespace(), e.getName(), ai);
            SimpleFeatureType ft = f.getFeatureType();
            List ats = ft.getAttributeDescriptors();
            if (ats != null) {
                for (int i = 0; i < ats.size(); ++i) {
                    Element e2 = e.findChildElement(((AttributeDescriptor)ats.get(i)).getLocalName());
                    e2.getType().encode(e2, f.getAttribute(i), ph, hints);
                }
            }
            ph.endElement(e.getNamespace(), e.getName());
        }

        private void print(SimpleFeature f, PrintHandler ph, Map hints) throws OperationNotSupportedException, IOException {
            AttributesImpl ai = new AttributesImpl();
            if (f.getID() != null && !f.getID().equals("")) {
                ai.addAttribute("", "fid", "", "ID", f.getID());
            } else {
                ai = null;
            }
            ph.startElement(GMLSchema.NAMESPACE, "_Feature", ai);
            SimpleFeatureType ft = f.getFeatureType();
            List ats = ft.getAttributeDescriptors();
            if (ats != null) {
                for (int i = 0; i < ats.size(); ++i) {
                    SimpleType t = XSISimpleTypes.find(((AttributeDescriptor)ats.get(i)).getType().getBinding());
                    t.encode(null, f.getAttribute(i), ph, hints);
                }
            }
            ph.endElement(GMLSchema.NAMESPACE, "_Feature");
        }
    }

    public static class CoordinatesType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new CoordinatesType();
        private static final Attribute[] attributes = new Attribute[]{new GMLSchema.GMLAttribute("decimal", XSISimpleTypes.String.getInstance(), 0, "."), new GMLSchema.GMLAttribute("cs", XSISimpleTypes.String.getInstance(), 0, ","), new GMLSchema.GMLAttribute("ts", XSISimpleTypes.String.getInstance(), 0, "\t")};

        @Override
        public Element[] getChildElements() {
            return null;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return new DefaultSequence(new Element[0]);
        }

        @Override
        public String getName() {
            return "CoordinatesType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value.length != 1) {
                throw new SAXException("Internal error, ElementValues require an associated Element.");
            }
            String dec = attrs.getValue("", "decimal");
            if (dec == null) {
                dec = attrs.getValue(GMLSchema.NAMESPACE.toString(), "decimal");
            }
            dec = dec == null || dec == "" ? "." : dec;
            String cs = attrs.getValue("", "cs");
            if (cs == null) {
                cs = attrs.getValue(GMLSchema.NAMESPACE.toString(), "cs");
            }
            cs = cs == null || cs == "" ? ",\\s*" : cs + "\\s*";
            String ts = attrs.getValue("", "ts");
            if (ts == null) {
                ts = attrs.getValue(GMLSchema.NAMESPACE.toString(), "ts");
            }
            ts = ts == null || ts == "" || ts.matches("\\s") ? "\\s+" : ts + "\\s*";
            String val = (String)value[0].getValue();
            String[] touples = val.split(ts);
            Coordinate[] coordinates = new Coordinate[touples.length];
            for (int i = 0; i < touples.length; ++i) {
                String[] points = touples[i].split(cs);
                double[] pts = new double[points.length];
                for (int j = 0; j < points.length; ++j) {
                    String t = "";
                    try {
                        if (!dec.equals(".")) {
                            dec = dec.replaceAll("\\", "\\");
                            t = points[j].replaceAll(dec, ".");
                        } else {
                            t = points[j];
                        }
                        pts[j] = Double.parseDouble(t);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        logger.warning(e.toString());
                        logger.warning("Double = '" + t + "' " + j + "/" + points.length + "  Touples = " + i + "/" + touples.length);
                        throw e;
                    }
                }
                coordinates[i] = pts.length == 1 ? new Coordinate(pts[0], 0.0) : (pts.length == 2 ? new Coordinate(pts[0], pts[1]) : new Coordinate(pts[0], pts[1], pts[2]));
            }
            return DefaultCoordinateSequenceFactory.instance().create(coordinates);
        }

        @Override
        public Class getInstanceType() {
            return CoordinateSequence.class;
        }

        @Override
        public Element findChildElement(String name) {
            return null;
        }

        @Override
        public boolean isMixed() {
            return true;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof CoordinateSequence;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            CoordinateSequence g = (CoordinateSequence)value;
            GMLComplexTypes.encodeCoords(element, g, output);
        }
    }

    public static class CoordType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new CoordType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("X", XSISimpleTypes.Decimal.getInstance(), 1, 1, false, null), new GMLSchema.GMLElement("Y", XSISimpleTypes.Decimal.getInstance(), 0, 1, false, null), new GMLSchema.GMLElement("Z", XSISimpleTypes.Decimal.getInstance(), 0, 1, false, null)};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return AbstractGeometryCollectionBaseType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "CoordType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            Double z = null;
            Double y = null;
            Double x = null;
            for (int i = 0; i < value.length; ++i) {
                if (elements[0].getName().equals(value[i].getElement().getName())) {
                    x = (Double)value[i].getValue();
                }
                if (elements[1].getName().equals(value[i].getElement().getName())) {
                    y = (Double)value[i].getValue();
                }
                if (!elements[2].getName().equals(value[i].getElement().getName())) continue;
                z = (Double)value[i].getValue();
            }
            if (x == null) {
                throw new SAXException("An X coord is required");
            }
            if (y == null) {
                return new Coordinate(x, 0.0);
            }
            if (z == null) {
                return new Coordinate(x, y);
            }
            return new Coordinate(x, y, z);
        }

        @Override
        public Class getInstanceType() {
            return Coordinate.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof Coordinate;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            Coordinate g = (Coordinate)value;
            GMLComplexTypes.encodeCoord(element, g, output);
        }
    }

    public static class MultiPolygonType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new MultiPolygonType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("polygonMember", PolygonMemberType.getInstance(), 1, Integer.MAX_VALUE, false, new GMLSchema.GMLElement("geometryMember", GeometryAssociationType.getInstance(), 1, 1, false, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return AbstractGeometryCollectionBaseType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "MultiPolygonType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            GeometryFactory gf = new GeometryFactory(DefaultCoordinateSequenceFactory.instance());
            Polygon[] geoms = new Polygon[value.length];
            for (int i = 0; i < value.length; ++i) {
                geoms[i] = (Polygon)value[i].getValue();
            }
            MultiPolygon mp = gf.createMultiPolygon(geoms);
            ElementValue[] ev = new ElementValue[]{new DefaultElementValue(element, mp)};
            return AbstractGeometryType.getInstance().getValue(element, ev, attrs, hints);
        }

        @Override
        public Class getInstanceType() {
            return MultiPolygon.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof MultiPolygon;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            MultiPolygon g = (MultiPolygon)value;
            GMLComplexTypes.encode(element, g, output);
        }
    }

    public static class MultiLineStringType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new MultiLineStringType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("lineStringMember", LineStringMemberType.getInstance(), 1, Integer.MAX_VALUE, false, new GMLSchema.GMLElement("geometryMember", GeometryAssociationType.getInstance(), 1, 1, false, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return AbstractGeometryCollectionBaseType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "MultiLineStringType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            GeometryFactory gf = new GeometryFactory(DefaultCoordinateSequenceFactory.instance());
            LineString[] geoms = new LineString[value.length];
            for (int i = 0; i < value.length; ++i) {
                geoms[i] = (LineString)value[i].getValue();
            }
            MultiLineString mp = gf.createMultiLineString(geoms);
            ElementValue[] ev = new ElementValue[]{new DefaultElementValue(element, mp)};
            return AbstractGeometryType.getInstance().getValue(element, ev, attrs, hints);
        }

        @Override
        public Class getInstanceType() {
            return MultiLineString.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof MultiLineString;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            MultiLineString g = (MultiLineString)value;
            GMLComplexTypes.encode(element, g, output);
        }
    }

    public static class MultiPointType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new MultiPointType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("pointMember", PointMemberType.getInstance(), 1, Integer.MAX_VALUE, false, new GMLSchema.GMLElement("geometryMember", GeometryAssociationType.getInstance(), 1, 1, false, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return AbstractGeometryCollectionBaseType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "MultiPointType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            GeometryFactory gf = new GeometryFactory(DefaultCoordinateSequenceFactory.instance());
            Point[] geoms = new Point[value.length];
            for (int i = 0; i < value.length; ++i) {
                geoms[i] = (Point)value[i].getValue();
            }
            MultiPoint mp = gf.createMultiPoint(geoms);
            ElementValue[] ev = new ElementValue[]{new DefaultElementValue(element, mp)};
            return AbstractGeometryType.getInstance().getValue(element, ev, attrs, hints);
        }

        @Override
        public Class getInstanceType() {
            return MultiPoint.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof MultiPoint;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            MultiPoint g = (MultiPoint)value;
            GMLComplexTypes.encode(element, g, output);
        }
    }

    public static class GeometryCollectionType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new GeometryCollectionType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("geometryMember", GeometryAssociationType.getInstance(), 1, Integer.MAX_VALUE, false, null)};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return AbstractGeometryCollectionBaseType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "GeometryCollectionType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            GeometryFactory gf = new GeometryFactory(DefaultCoordinateSequenceFactory.instance());
            Geometry[] geoms = new Geometry[value.length];
            for (int i = 0; i < value.length; ++i) {
                geoms[i] = (Geometry)value[i].getValue();
            }
            return gf.createGeometryCollection(geoms);
        }

        @Override
        public Class getInstanceType() {
            return GeometryCollection.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof GeometryCollection;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            GeometryCollection g = (GeometryCollection)value;
            GMLComplexTypes.encode(element, g, output);
        }
    }

    public static class PolygonType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new PolygonType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("outerBoundaryIs", LinearRingMemberType.getInstance(), 1, 1, false, null), new GMLSchema.GMLElement("innerBoundaryIs", LinearRingMemberType.getInstance(), 0, Integer.MAX_VALUE, false, null)};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return AbstractGeometryType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "PolygonType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws OperationNotSupportedException, SAXException {
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            GeometryFactory gf = new GeometryFactory(DefaultCoordinateSequenceFactory.instance());
            LinearRing outerLR = null;
            LinearRing[] innerLR = new LinearRing[value.length > 1 ? value.length - 1 : 0];
            int innerIndex = 0;
            for (int i = 0; i < value.length; ++i) {
                if (elements[0].getName().equalsIgnoreCase(value[i].getElement().getName())) {
                    outerLR = (LinearRing)value[i].getValue();
                    continue;
                }
                innerLR[innerIndex++] = (LinearRing)value[i].getValue();
            }
            Polygon p = gf.createPolygon(outerLR, innerLR);
            ElementValue[] ev = new ElementValue[]{new DefaultElementValue(element, p)};
            return AbstractGeometryType.getInstance().getValue(element, ev, attrs, hints);
        }

        @Override
        public Class getInstanceType() {
            return Polygon.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                if (t.getParent() instanceof ComplexType) {
                    t = (ComplexType)t.getParent();
                    continue;
                }
                t = null;
            }
            return t != null && value instanceof Polygon;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            Polygon g = (Polygon)value;
            GMLComplexTypes.encode(element, g, output);
        }
    }

    public static class BoxType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new BoxType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("coord", CoordType.getInstance(), 2, 2, false, null), new GMLSchema.GMLElement("coordinates", CoordinatesType.getInstance(), 1, 1, false, null)};
        private static final DefaultChoice seq = new DefaultChoice(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return AbstractGeometryType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "BoxType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws OperationNotSupportedException, SAXException {
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            Object t = value[0].getValue();
            LineString p = null;
            if (t == null) {
                throw new SAXException("Invalid coordinate specified");
            }
            GeometryFactory gf = new GeometryFactory(DefaultCoordinateSequenceFactory.instance());
            try {
                Coordinate[] c;
                if (t instanceof Coordinate) {
                    if (value.length != 2) {
                        throw new SAXException("Cannot have more than one coord per " + this.getName());
                    }
                    c = new Coordinate[value.length];
                    for (int i = 0; i < c.length; ++i) {
                        c[i] = (Coordinate)value[i].getValue();
                    }
                    p = gf.createLineString(c);
                } else {
                    if (value.length > 1) {
                        throw new SAXException("Cannot have more than one coordinate sequence per " + this.getName());
                    }
                    c = (Coordinate[])t;
                    p = gf.createLineString((CoordinateSequence)c);
                }
            }
            catch (ClassCastException cce) {
                logger.warning(cce.toString());
                logger.warning(t + (t == null ? "" : t.getClass().getName()));
                throw cce;
            }
            ElementValue[] ev = new ElementValue[]{new DefaultElementValue(element, p.getEnvelope())};
            return AbstractGeometryType.getInstance().getValue(element, ev, attrs, hints);
        }

        @Override
        public Class getInstanceType() {
            return Geometry.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return value instanceof Geometry || value instanceof ReferencedEnvelope;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode " + value);
            }
            if (value instanceof ReferencedEnvelope) {
                ReferencedEnvelope bbox = (ReferencedEnvelope)value;
                AttributesImpl ai = new AttributesImpl();
                if (bbox != null && bbox.getCoordinateReferenceSystem() != null) {
                    String srsName = CRS.toSRS(bbox.getCoordinateReferenceSystem());
                    ai.addAttribute("", "srsName", "", "anyURI", srsName);
                } else {
                    ai = null;
                }
                if (bbox == null || bbox.isNull() || bbox.isEmpty()) {
                    return;
                }
                if (element != null) {
                    output.startElement(GMLSchema.NAMESPACE, element.getName(), ai);
                } else {
                    output.startElement(GMLSchema.NAMESPACE, "Box", ai);
                }
                ReferencedEnvelope e = bbox;
                GMLComplexTypes.encodeCoords(elements[1], (Envelope)e, output);
                if (element != null) {
                    output.endElement(GMLSchema.NAMESPACE, element.getName());
                } else {
                    output.endElement(GMLSchema.NAMESPACE, "Box");
                }
            } else {
                Geometry g = (Geometry)value;
                if (g == null || g.getNumPoints() == 0 || g.getCoordinates().length == 0) {
                    return;
                }
                AttributesImpl ai = GMLComplexTypes.getSrsNameAttribute(g);
                if (element != null) {
                    output.startElement(GMLSchema.NAMESPACE, element.getName(), ai);
                } else {
                    output.startElement(GMLSchema.NAMESPACE, "Box", ai);
                }
                Envelope e = g.getEnvelopeInternal();
                GMLComplexTypes.encodeCoords(elements[1], e, output);
                if (element != null) {
                    output.endElement(GMLSchema.NAMESPACE, element.getName());
                } else {
                    output.endElement(GMLSchema.NAMESPACE, "Box");
                }
            }
        }
    }

    public static class LinearRingType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new LinearRingType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("coord", CoordType.getInstance(), 2, 4, false, null), new GMLSchema.GMLElement("coordinates", CoordinatesType.getInstance(), 1, 1, false, null)};
        private static final DefaultChoice seq = new DefaultChoice(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return AbstractGeometryType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "LinearRingType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws OperationNotSupportedException, SAXException {
            Coordinate[] c;
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            Object t = value[0].getValue();
            LinearRing p = null;
            if (t == null) {
                throw new SAXException("Invalid coordinate specified");
            }
            GeometryFactory gf = new GeometryFactory(DefaultCoordinateSequenceFactory.instance());
            if (t instanceof Coordinate) {
                if (value.length < 4) {
                    throw new SAXException("Cannot have more than one coord per " + this.getName());
                }
                c = new Coordinate[value.length];
                for (int i = 0; i < c.length; ++i) {
                    c[i] = (Coordinate)value[i].getValue();
                }
                p = gf.createLinearRing(c);
            } else {
                if (value.length > 1) {
                    throw new SAXException("Cannot have more than one coordinate sequence per " + this.getName());
                }
                c = (Coordinate[])t;
                p = gf.createLinearRing((CoordinateSequence)c);
            }
            ElementValue[] ev = new ElementValue[]{new DefaultElementValue(element, p)};
            return AbstractGeometryType.getInstance().getValue(element, ev, attrs, hints);
        }

        @Override
        public Class getInstanceType() {
            return LinearRing.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof LinearRing;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            LinearRing g = (LinearRing)value;
            GMLComplexTypes.encode(element, g, output);
        }
    }

    public static class LineStringType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new LineStringType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("coord", CoordType.getInstance(), 2, Integer.MAX_VALUE, false, null), new GMLSchema.GMLElement("coordinates", CoordinatesType.getInstance(), 1, 1, false, null)};
        private static final DefaultChoice seq = new DefaultChoice(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return AbstractGeometryType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "LineStringType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws OperationNotSupportedException, SAXException {
            Object c;
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            Object t = value[0].getValue();
            LineString p = null;
            if (t == null) {
                throw new SAXException("Invalid coordinate specified");
            }
            GeometryFactory gf = new GeometryFactory(DefaultCoordinateSequenceFactory.instance());
            if (t instanceof Coordinate) {
                if (value.length < 2) {
                    throw new SAXException("Cannot have more than one coord per " + this.getName());
                }
                c = new Coordinate[value.length];
                for (int i = 0; i < ((Coordinate[])c).length; ++i) {
                    c[i] = (Coordinate)value[i].getValue();
                }
                p = gf.createLineString((Coordinate[])c);
            } else {
                if (value.length > 1) {
                    throw new SAXException("Cannot have more than one coordinate sequence per " + this.getName());
                }
                c = (Coordinate[])t;
                if (c.size() == 1) {
                    c = DefaultCoordinateSequenceFactory.instance().create(new Coordinate[]{c.getCoordinate(0), c.getCoordinate(0)});
                }
                p = gf.createLineString((CoordinateSequence)c);
            }
            ElementValue[] ev = new ElementValue[]{new DefaultElementValue(element, p)};
            return AbstractGeometryType.getInstance().getValue(element, ev, attrs, hints);
        }

        @Override
        public Class getInstanceType() {
            return LineString.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof LineString;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            LineString g = (LineString)value;
            GMLComplexTypes.encode(element, g, output);
        }
    }

    public static class PointType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new PointType();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("coord", CoordType.getInstance(), 1, 1, false, null), new GMLSchema.GMLElement("coordinates", CoordinatesType.getInstance(), 1, 1, false, null)};
        private static final DefaultChoice seq = new DefaultChoice(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return AbstractGeometryType.attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "PointType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws OperationNotSupportedException, SAXException {
            Cloneable c;
            if (value.length > 1) {
                throw new SAXException("Cannot have more than one coord per " + this.getName());
            }
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            Object t = value[0].getValue();
            Point p = null;
            if (t == null) {
                throw new SAXException("Invalid coordinate specified");
            }
            GeometryFactory gf = new GeometryFactory(DefaultCoordinateSequenceFactory.instance());
            if (t instanceof Coordinate) {
                c = (Coordinate)t;
                p = gf.createPoint((Coordinate)c);
            } else {
                c = (CoordinateSequence)t;
                p = gf.createPoint((CoordinateSequence)c);
            }
            ElementValue[] ev = new ElementValue[]{new DefaultElementValue(element, p)};
            return AbstractGeometryType.getInstance().getValue(element, ev, attrs, hints);
        }

        @Override
        public Class getInstanceType() {
            return Point.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof Point;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            Point g = (Point)value;
            GMLComplexTypes.encode(element, g, output);
        }
    }

    public static class LinearRingMemberType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new LinearRingMemberType();
        private static final Attribute[] attributes = LinearRingMemberType.loadAttributes();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("LinearRing", LinearRingType.getInstance(), 0, 1, false, new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 1, 1, true, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        private static Attribute[] loadAttributes() {
            int i;
            Attribute[] parent = GeometryAssociationType.attributes;
            Attribute[] gp = GMLSchema.GMLAssociationAttributeGroup.attributes1;
            Attribute[] r = new Attribute[parent.length + gp.length];
            for (i = 0; i < parent.length; ++i) {
                r[i] = parent[i];
            }
            for (i = 0; i < gp.length; ++i) {
                r[i + parent.length] = gp[i];
            }
            return r;
        }

        @Override
        public Attribute[] getAttributes() {
            return attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "LinearRingMemberType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length == 0 || value[0] == null) {
                return null;
            }
            if (value.length > 1) {
                throw new SAXException("Cannot have more than one geom per " + this.getName());
            }
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            return (LinearRing)value[0].getValue();
        }

        @Override
        public Class getInstanceType() {
            return LinearRing.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof LinearRing;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            LinearRing g = (LinearRing)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            GMLComplexTypes.encode(null, g, output);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class PolygonMemberType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new PolygonMemberType();
        private static final Attribute[] attributes = PolygonMemberType.loadAttributes();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("Polygon", PolygonType.getInstance(), 0, 1, false, new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 1, 1, true, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        private static Attribute[] loadAttributes() {
            int i;
            Attribute[] parent = GeometryAssociationType.attributes;
            Attribute[] gp = GMLSchema.GMLAssociationAttributeGroup.attributes1;
            Attribute[] r = new Attribute[parent.length + gp.length];
            for (i = 0; i < parent.length; ++i) {
                r[i] = parent[i];
            }
            for (i = 0; i < gp.length; ++i) {
                r[i + parent.length] = gp[i];
            }
            return r;
        }

        @Override
        public Attribute[] getAttributes() {
            return attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "PolygonMemberType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length == 0 || value[0] == null) {
                return null;
            }
            if (value.length > 1) {
                throw new SAXException("Cannot have more than one geom per " + this.getName());
            }
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            return (Polygon)value[0].getValue();
        }

        @Override
        public Class getInstanceType() {
            return Polygon.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof Polygon;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            Polygon g = (Polygon)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            GMLComplexTypes.encode(null, g, output);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class LineStringMemberType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new LineStringMemberType();
        private static final Attribute[] attributes = LineStringMemberType.loadAttributes();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("LineString", LineStringType.getInstance(), 0, 1, false, new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 1, 1, true, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        private static Attribute[] loadAttributes() {
            int i;
            Attribute[] parent = GeometryAssociationType.attributes;
            Attribute[] gp = GMLSchema.GMLAssociationAttributeGroup.attributes1;
            Attribute[] r = new Attribute[parent.length + gp.length];
            for (i = 0; i < parent.length; ++i) {
                r[i] = parent[i];
            }
            for (i = 0; i < gp.length; ++i) {
                r[i + parent.length] = gp[i];
            }
            return r;
        }

        @Override
        public Attribute[] getAttributes() {
            return attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "LineStringMemberType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length == 0 || value[0] == null) {
                return null;
            }
            if (value.length > 1) {
                throw new SAXException("Cannot have more than one geom per " + this.getName());
            }
            Element e = value[0].getElement();
            if (e == null) {
                if (!element.isNillable()) {
                    throw new SAXException("Internal error, ElementValues require an associated Element.");
                }
                return null;
            }
            return (LineString)value[0].getValue();
        }

        @Override
        public Class getInstanceType() {
            return LineString.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof LineString;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            LineString g = (LineString)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            GMLComplexTypes.encode(null, g, output);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class PointMemberType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new PointMemberType();
        private static final Attribute[] attributes = PointMemberType.loadAttributes();
        private static final Element[] elements = new Element[]{new GMLSchema.GMLElement("Point", PointType.getInstance(), 0, 1, false, new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 1, 1, true, null))};
        private static final DefaultSequence seq = new DefaultSequence(elements);

        @Override
        public Element[] getChildElements() {
            return elements;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        private static Attribute[] loadAttributes() {
            int i;
            Attribute[] parent = GeometryAssociationType.attributes;
            Attribute[] gp = GMLSchema.GMLAssociationAttributeGroup.attributes1;
            Attribute[] r = new Attribute[parent.length + gp.length];
            for (i = 0; i < parent.length; ++i) {
                r[i] = parent[i];
            }
            for (i = 0; i < gp.length; ++i) {
                r[i + parent.length] = gp[i];
            }
            return r;
        }

        @Override
        public Attribute[] getAttributes() {
            return attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public String getName() {
            return "PointMemberType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length == 0 || value[0] == null) {
                return null;
            }
            if (value.length > 1) {
                throw new SAXException("Cannot have more than one geom per " + this.getName());
            }
            Element e = value[0].getElement();
            if (e == null) {
                throw new SAXException("Internal error, ElementValues require an associated Element.");
            }
            return (Point)value[0].getValue();
        }

        @Override
        public Class getInstanceType() {
            return Point.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!name.equals(elements[i].getName())) continue;
                return elements[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof Geometry;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            Point g = (Point)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            GMLComplexTypes.encode(null, g, output);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class GeometryAssociationType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new GeometryAssociationType();
        protected static final Attribute[] attributes = GeometryAssociationType.loadAttributes();
        private static final Element[] elems = new Element[]{new GMLSchema.GMLElement("_Geometry", AbstractGeometryType.getInstance(), 0, 1, true, null)};
        private static final DefaultSequence elements = new DefaultSequence(elems);

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        private static Attribute[] loadAttributes() {
            Attribute[] gp = XLinkSchema.SimpleLink.getInstance().getAttributes();
            Attribute[] r = new Attribute[gp.length + 1];
            for (int i = 1; i < gp.length; ++i) {
                r[i] = gp[i];
            }
            r[gp.length] = GMLSchema.AttributeList.attributes1[0];
            return r;
        }

        @Override
        public Attribute[] getAttributes() {
            return attributes;
        }

        @Override
        public ElementGrouping getChild() {
            return elements;
        }

        @Override
        public String getName() {
            return "GeometryAssociationType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length == 0 || value[0] == null) {
                return null;
            }
            if (value.length > 1) {
                throw new SAXException("Cannot have more than one geom per " + this.getName());
            }
            Element e = value[0].getElement();
            if (e == null) {
                throw new SAXException("Internal error, ElementValues require an associated Element.");
            }
            return (Geometry)value[0].getValue();
        }

        @Override
        public Class getInstanceType() {
            return Geometry.class;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < elems.length; ++i) {
                if (!name.equals(elems[i].getName())) continue;
                return elems[i];
            }
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            ComplexType t;
            ComplexType complexType = t = element.getType() instanceof ComplexType ? (ComplexType)element.getType() : null;
            while (t != null && t != this) {
                t = t.getParent() instanceof ComplexType ? (ComplexType)t.getParent() : null;
            }
            return t != null && value instanceof Geometry;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode");
            }
            Geometry g = (Geometry)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            GMLComplexTypes.encode(null, g, output);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class AbstractGeometryCollectionBaseType
    extends GMLSchema.GMLComplexType {
        protected static final Attribute[] attributes = new Attribute[]{new GMLSchema.GMLAttribute("gid", XSISimpleTypes.ID.getInstance()), new GMLSchema.GMLAttribute("srsName", XSISimpleTypes.AnyURI.getInstance(), 2)};
        private static final GMLSchema.GMLComplexType instance = new AbstractGeometryCollectionBaseType();

        @Override
        public Element[] getChildElements() {
            return null;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return new Attribute[0];
        }

        @Override
        public ElementGrouping getChild() {
            return new DefaultSequence(new Element[0]);
        }

        @Override
        public String getName() {
            return "AbstractGeometryCollectionBaseType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            try {
                Geometry g = (Geometry)value[0].getValue();
                String srsName = attrs.getValue("srsName");
                if (srsName != null && !"".equals(srsName)) {
                    g.setUserData(srsName);
                }
                return g;
            }
            catch (ClassCastException e) {
                throw new SAXException("Expected a Geometry to be passed to this abstract type");
            }
        }

        @Override
        public Class getInstanceType() {
            return Geometry.class;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public Element findChildElement(String name) {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class AbstractGeometryType
    extends GMLSchema.GMLComplexType {
        private static final GMLSchema.GMLComplexType instance = new AbstractGeometryType();
        protected static Attribute[] attributes = new Attribute[]{new GMLSchema.GMLAttribute("gid", XSISimpleTypes.ID.getInstance()), new GMLSchema.GMLAttribute("srsName", XSISimpleTypes.AnyURI.getInstance())};

        @Override
        public Element[] getChildElements() {
            return null;
        }

        public static GMLSchema.GMLComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return new Attribute[0];
        }

        @Override
        public ElementGrouping getChild() {
            return new DefaultSequence(new Element[0]);
        }

        @Override
        public String getName() {
            return "AbstractGeometryType";
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            try {
                Geometry g = (Geometry)value[0].getValue();
                String srsName = attrs.getValue("srsName");
                if (srsName != null && !"".equals(srsName)) {
                    g.setUserData(srsName);
                }
                return g;
            }
            catch (ClassCastException e) {
                throw new SAXException("Expected a Geometry to be passed to this abstract type");
            }
        }

        @Override
        public Class getInstanceType() {
            return Geometry.class;
        }

        @Override
        public Element findChildElement(String name) {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            if (element.getType() == null || !(value instanceof Geometry)) {
                return false;
            }
            return !(element.getType() instanceof SimpleType);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException();
            }
            Geometry g = (Geometry)value;
            GMLComplexTypes.encode(null, g, output);
        }
    }

    private static class DefaultSequence
    implements Sequence {
        private Element[] elements = null;

        private DefaultSequence() {
        }

        public DefaultSequence(Element[] elems) {
            this.elements = elems;
        }

        @Override
        public ElementGrouping[] getChildren() {
            return this.elements;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public int getMaxOccurs() {
            return 1;
        }

        @Override
        public int getMinOccurs() {
            return 1;
        }

        @Override
        public int getGrouping() {
            return 8;
        }

        @Override
        public Element findChildElement(String name) {
            if (this.elements == null || this.elements.length == 0 || name == null) {
                return null;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                if (!name.equals(this.elements[i].getName())) continue;
                return this.elements[i];
            }
            return null;
        }

        @Override
        public Element findChildElement(String localName, URI namespaceURI) {
            if (this.elements == null || this.elements.length == 0 || localName == null) {
                return null;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                if (!localName.equals(this.elements[i].getName()) || !namespaceURI.equals(this.elements[i].getNamespace())) continue;
                return this.elements[i];
            }
            return null;
        }
    }

    private static class DefaultChoice
    implements Choice {
        private Element[] elements = null;

        private DefaultChoice() {
        }

        public DefaultChoice(Element[] elems) {
            this.elements = elems;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public int getMaxOccurs() {
            return 1;
        }

        @Override
        public int getMinOccurs() {
            return 1;
        }

        @Override
        public ElementGrouping[] getChildren() {
            return this.elements;
        }

        @Override
        public int getGrouping() {
            return 16;
        }

        @Override
        public Element findChildElement(String name) {
            if (this.elements == null || this.elements.length == 0 || name == null) {
                return null;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                if (!name.equals(this.elements[i].getName())) continue;
                return this.elements[i];
            }
            return null;
        }

        @Override
        public Element findChildElement(String localName, URI namespaceURI) {
            if (this.elements == null || this.elements.length == 0 || localName == null) {
                return null;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                if (!localName.equals(this.elements[i].getName()) || !namespaceURI.equals(this.elements[i].getNamespace())) continue;
                return this.elements[i];
            }
            return null;
        }
    }

    private static class DefaultElementValue
    implements ElementValue {
        private Element elem;
        private Object value;

        public DefaultElementValue(Element elem, Object value) {
            this.elem = elem;
            this.value = value;
        }

        @Override
        public Element getElement() {
            return this.elem;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.getElement() != null && this.getElement().toString() != null) {
                buf.append(this.getElement().toString());
            } else {
                buf.append(this.getClass().getName());
            }
            buf.append("[");
            buf.append(this.value);
            buf.append("]");
            return buf.toString();
        }
    }
}

