/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import javax.xml.namespace.QName;
import org.geotools.filter.v1_0.OGC;
import org.geotools.util.Converters;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.geotools.xml.Text;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Literal;
import org.picocontainer.MutablePicoContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OGCLiteralTypeBinding
extends AbstractComplexBinding {
    private FilterFactory factory;

    public OGCLiteralTypeBinding(FilterFactory factory) {
        this.factory = factory;
    }

    public QName getTarget() {
        return OGC.LiteralType;
    }

    public int getExecutionMode() {
        return 2;
    }

    public Class getType() {
        return Literal.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        if (!node.getChildren().isEmpty()) {
            Object childValue = node.getChildValue(0);
            if (childValue instanceof Text) {
                childValue = ((Text)childValue).getValue();
            }
            return this.factory.literal(childValue);
        }
        return this.factory.literal(value);
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        Literal literal = (Literal)object;
        Object unconvertedValue = literal.getValue();
        if (unconvertedValue != null) {
            String textValue = (String)Converters.convert((Object)unconvertedValue, String.class);
            value.appendChild(document.createTextNode(textValue));
        }
        return value;
    }
}

