/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver.jtds;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.logging.Logging;

public class JTDSDateConverterFactory
implements ConverterFactory {
    private static final Logger LOGGER = Logging.getLogger(JTDSDateConverterFactory.class);
    JTDSDateConverter converter = new JTDSDateConverter();
    static final Class<?> JTDS_DATE;
    static final Class<?> JTDS_TIMESTAMP;
    static final Method JTDS_DATE_DVALUE;
    static final Method JTDS_DATE_TSVALUE;
    static final Method JTDS_TS_DVALUE;
    static final Method JTDS_TS_TSVALUE;

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (JTDS_DATE == null) {
            LOGGER.finest("No JTDS jar on classpath");
            return null;
        }
        if (!Date.class.isAssignableFrom(target)) {
            LOGGER.finest("Target is not a Date");
            return null;
        }
        if (!JTDS_TIMESTAMP.isAssignableFrom(source) && !JTDS_DATE.isAssignableFrom(source)) {
            LOGGER.finest("Source is not a date time object");
            return null;
        }
        return this.converter;
    }

    static {
        Class<?> jTDSDateClass = null;
        try {
            jTDSDateClass = Class.forName("net.sourceforge.jtds.jdbc.DateTime");
        }
        catch (ClassNotFoundException e) {
            LOGGER.finest("Couldn't find JTDS jar on classpath");
        }
        if (jTDSDateClass == null) {
            JTDS_DATE = null;
            JTDS_DATE_DVALUE = null;
            JTDS_DATE_TSVALUE = null;
            JTDS_TIMESTAMP = null;
            JTDS_TS_DVALUE = null;
            JTDS_TS_TSVALUE = null;
        } else {
            try {
                JTDS_DATE = jTDSDateClass;
                JTDS_DATE_DVALUE = JTDS_DATE.getMethod("toDate", new Class[0]);
                JTDS_DATE_TSVALUE = JTDS_DATE.getMethod("toTimestamp", new Class[0]);
                JTDS_TIMESTAMP = Class.forName("net.sourceforge.jtds.jdbc.DateTime");
                JTDS_TS_DVALUE = JTDS_TIMESTAMP.getMethod("toDate", new Class[0]);
                JTDS_TS_TSVALUE = JTDS_TIMESTAMP.getMethod("toTimestamp", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize the jtds date converter", e);
            }
        }
    }

    class JTDSDateConverter
    implements Converter {
        JTDSDateConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (JTDS_TIMESTAMP.isInstance(source)) {
                if (java.sql.Date.class.isAssignableFrom(target)) {
                    LOGGER.finest("converting to Date from " + source.toString());
                    return (T)JTDS_TS_DVALUE.invoke(source, new Object[0]);
                }
                LOGGER.finest("converting to timestamp from " + source.toString());
                return (T)JTDS_TS_TSVALUE.invoke(source, new Object[0]);
            }
            if (java.sql.Date.class.isAssignableFrom(target)) {
                LOGGER.finest("converting to Date from " + source.toString());
                return (T)JTDS_DATE_DVALUE.invoke(source, new Object[0]);
            }
            LOGGER.finest("converting to timestamp from " + source.toString());
            return (T)JTDS_DATE_TSVALUE.invoke(source, new Object[0]);
        }
    }
}

