/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.rendered.viewer;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class ImageTreeModel
implements TreeModel {
    private List<TreeModelListener> vector = new ArrayList<TreeModelListener>();
    RenderedImage root;

    ImageTreeModel() {
    }

    public void setRoot(RenderedImage root) {
        this.root = root;
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(root)));
    }

    public Object getChild(Object parent, int index) {
        RenderedImage ro = (RenderedImage)parent;
        return ro.getSources().get(index);
    }

    public int getChildCount(Object parent) {
        RenderedImage ro = (RenderedImage)parent;
        if (ro.getSources() != null) {
            return ro.getSources().size();
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        RenderedImage ro = (RenderedImage)parent;
        Vector<RenderedImage> sources = ro.getSources();
        for (int i = 0; i < sources.size(); ++i) {
            if (!sources.get(i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("This tree is read only");
    }

    public void addTreeModelListener(TreeModelListener listener) {
        if (listener != null && !this.vector.contains(listener)) {
            this.vector.add(listener);
        }
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        if (listener != null) {
            this.vector.remove(listener);
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent e) {
        for (TreeModelListener listener : this.vector) {
            listener.treeStructureChanged(e);
        }
    }
}

