/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.filter.AbstractFilter;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public class NullFilterImpl
extends AbstractFilter
implements PropertyIsNull {
    private Expression nullCheck = null;

    protected NullFilterImpl() {
    }

    protected NullFilterImpl(Expression expresion) {
        this.setExpression(expresion);
    }

    public Expression getExpression() {
        return this.nullCheck;
    }

    public void setExpression(Expression nullCheck) {
        if (nullCheck == null || !(nullCheck instanceof PropertyName)) {
            throw new IllegalFilterException("PropertyName expression required");
        }
        this.nullCheck = nullCheck;
    }

    public boolean evaluate(Object feature) {
        if (this.nullCheck == null) {
            return false;
        }
        return this.nullCheck.evaluate(feature) == null;
    }

    public String toString() {
        return "[ " + this.nullCheck.toString() + " is null ]";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            NullFilterImpl nullFilter = (NullFilterImpl)obj;
            return Filters.getFilterType(nullFilter) == Filters.getFilterType(this) && nullFilter.getExpression().equals(this.nullCheck);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.nullCheck == null ? 0 : this.nullCheck.hashCode());
        return result;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((PropertyIsNull)this, extraData);
    }
}

