/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.bandmerge;

import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BandMergeDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "BandMerge"}, {"LocalName", "BandMerge"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "Operation used for merging multiple images into a single multibanded image"}, {"DocURL", "Not Defined"}, {"Version", "1.0"}, {"arg0Desc", "NoData values"}, {"arg1Desc", "Destination No Data value"}, {"arg2Desc", "Transformations List"}, {"arg3Desc", "ROI object to use"}, {"arg4Desc", "Boolean indicating if the last band is an alpha band"}};
    private static final String[] paramNames = new String[]{"noData", "destinationNoData", "transformations", "roi", "setAlpha"};
    private static final Class[] paramClasses = new Class[]{Range[].class, Double.class, List.class, ROI.class, Boolean.class};
    private static final Object[] paramDefaults = new Object[]{null, 0.0, null, null, false};

    public BandMergeDescriptor() {
        super(resources, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return true;
    }

    public static RenderedOp create(Range[] noData, double destinationNoData, boolean setAlpha, RenderingHints hints, RenderedImage ... sources) {
        return BandMergeDescriptor.create(noData, destinationNoData, setAlpha, hints, null, sources);
    }

    public static RenderedOp create(Range[] noData, double destinationNoData, boolean setAlpha, RenderingHints hints, List<AffineTransform> transform, RenderedImage ... sources) {
        return BandMergeDescriptor.create(noData, destinationNoData, setAlpha, hints, transform, null, sources);
    }

    public static RenderedOp create(Range[] noData, double destinationNoData, boolean setAlpha, RenderingHints hints, List<AffineTransform> transform, ROI roi, RenderedImage ... sources) {
        ParameterBlockJAI pb = new ParameterBlockJAI("BandMerge", "rendered");
        int numSources = sources.length;
        if (numSources <= 0) {
            throw new IllegalArgumentException("No resources are present");
        }
        for (int index = 0; index < numSources; ++index) {
            RenderedImage source = sources[index];
            if (source == null) {
                throw new IllegalArgumentException("This resource is null");
            }
            pb.setSource((Object)source, index);
        }
        if (transform != null && !transform.isEmpty() && transform.get(0) instanceof AffineTransform) {
            pb.setParameter("transformations", transform);
        }
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("setAlpha", setAlpha);
        return JAI.create((String)"BandMerge", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(Range[] noData, double destinationNoData, RenderingHints hints, RenderableImage ... sources) {
        return BandMergeDescriptor.createRenderable(noData, destinationNoData, hints, null, sources);
    }

    public static RenderableOp createRenderable(Range[] noData, double destinationNoData, RenderingHints hints, List<AffineTransform> transform, RenderableImage ... sources) {
        return BandMergeDescriptor.createRenderable(noData, destinationNoData, hints, transform, null, sources);
    }

    public static RenderableOp createRenderable(Range[] noData, double destinationNoData, RenderingHints hints, List<AffineTransform> transform, ROI roi, RenderableImage ... sources) {
        ParameterBlockJAI pb = new ParameterBlockJAI("BandMerge", "renderable");
        int numSources = sources.length;
        if (numSources <= 0) {
            throw new IllegalArgumentException("No resources are present");
        }
        for (int index = 0; index < numSources; ++index) {
            RenderableImage source = sources[index];
            if (source == null) {
                throw new IllegalArgumentException("This resource is null");
            }
            pb.setSource((Object)source, index);
        }
        if (transform != null && !transform.isEmpty() && transform.get(0) instanceof AffineTransform) {
            pb.setParameter("transformations", transform);
        }
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        pb.setParameter("roi", (Object)roi);
        return JAI.createRenderable((String)"BandMerge", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

