/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.gml;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import nl.b3p.brmo.loader.gml.BGTGMLLightTransformerFactory;
import nl.b3p.brmo.loader.gml.GMLLightFeatureTransformer;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.xml.sax.SAXException;

public class BGTGMLLightLoader {
    private static final Log LOG = LogFactory.getLog(BGTGMLLightLoader.class);
    private File scanDirectory;
    private Properties dbConnProps;
    private boolean isOracle = false;
    private boolean isMSSQL = false;
    private boolean createTables = false;
    private Parser parser;
    private Geometry omhullendeVanZipFile = null;
    private final StringBuilder opmerkingen = new StringBuilder();
    private STATUS status = STATUS.OK;

    public BGTGMLLightLoader() {
        String schemaLocation = BGTGMLLightLoader.class.getResource("/imgeo-simple_resolved.xsd").toString();
        ApplicationSchemaConfiguration configuration = new ApplicationSchemaConfiguration("http://www.geostandaarden.nl/imgeo/2.1/simple/gml31", schemaLocation);
        configuration.getContext().registerComponentInstance((Object)new GeometryFactory(new PrecisionModel(), 28992));
        this.parser = new Parser((Configuration)configuration);
        this.parser.setValidating(true);
        this.parser.setStrict(false);
        this.parser.setFailOnValidationError(false);
    }

    public BGTGMLLightLoader(File scanDirectory, Properties dbConnProps) {
        this.scanDirectory = scanDirectory;
        this.dbConnProps = dbConnProps;
        this.isOracle = "oracle".equalsIgnoreCase(dbConnProps.getProperty("dbtype"));
        this.isMSSQL = "jtds-sqlserver".equalsIgnoreCase(dbConnProps.getProperty("dbtype")) | "sqlserver".equalsIgnoreCase(dbConnProps.getProperty("dbtype"));
    }

    public void processZipFiles(List<File> zipFiles) throws FileNotFoundException, IOException {
        for (File zip : zipFiles) {
            LOG.debug((Object)("Verwerken zipfile: " + zip.getName()));
            this.processZipFile(zip);
        }
    }

    public int processZipFile(File zipExtract) throws FileNotFoundException, IOException {
        this.omhullendeVanZipFile = null;
        this.resetStatus();
        int result = 0;
        int total = 0;
        String eName = "";
        if (this.isValidZipFile(zipExtract)) {
            try (ZipInputStream zip = new ZipInputStream(new FileInputStream(zipExtract));){
                ZipEntry entry = zip.getNextEntry();
                if (entry == null) {
                    LOG.error((Object)("Geen bestanden in zipfile (" + zipExtract + ") gevonden."));
                }
                while (entry != null) {
                    if (!entry.getName().toLowerCase().endsWith(".gml")) {
                        LOG.warn((Object)("Overslaan zip entry geen GML bestand: " + entry.getName()));
                    } else {
                        eName = entry.getName();
                        LOG.info((Object)("Lezen GML bestand: " + eName + " uit zip file: " + zipExtract.getCanonicalPath()));
                        result = this.storeFeatureCollection((InputStream)new CloseShieldInputStream((InputStream)zip), eName.toLowerCase());
                        this.opmerkingen.append(result).append(" features geladen uit: ").append(eName).append(", zipfile: ").append(zipExtract.getCanonicalPath()).append("\n");
                        total += result;
                    }
                    entry = zip.getNextEntry();
                }
            }
            catch (ParserConfigurationException | SAXException ex) {
                LOG.error((Object)("Er is een parse fout opgetreden tijdens verwerken van " + eName + " uit " + zipExtract.getCanonicalPath()), (Throwable)ex);
                this.opmerkingen.append("Er is een parse fout opgetreden tijdens verwerken van ").append(eName).append(" Foutmelding: ").append(ex).append("\n");
                this.status = STATUS.NOK;
            }
        } else {
            LOG.error((Object)("Ongeldige of corrupte zipfile: " + zipExtract.getCanonicalPath()));
            this.opmerkingen.append("Ongeldige of corrupte zipfile: ").append(zipExtract.getCanonicalPath()).append("\nHet bestand kan niet verwerkt worden. Download het bestand opnieuw.");
            this.status = STATUS.NOK;
        }
        return total;
    }

    public int processGMLFile(File gml) throws IOException {
        int result = 0;
        try {
            result = this.storeFeatureCollection(new FileInputStream(gml), gml.getName().toLowerCase());
        }
        catch (ParserConfigurationException | SAXException ex) {
            LOG.error((Object)("Er is een parse fout opgetreden tijdens verwerken van: " + gml.getCanonicalPath()), (Throwable)ex);
            this.status = STATUS.NOK;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int storeFeatureCollection(InputStream in, String gmlFileName) throws IOException, IllegalStateException, SAXException, ParserConfigurationException {
        String[] typeNames;
        int inserts = 0;
        int updates = 0;
        int deletes = 0;
        int features = 0;
        JDBCDataStore dataStore = (JDBCDataStore)DataStoreFinder.getDataStore((Map)this.dbConnProps);
        if (dataStore == null) {
            throw new IllegalStateException("Datastore mag niet 'null' zijn voor opslaan van data.");
        }
        if (this.isOracle) {
            dataStore.getClassToSqlTypeMappings().put(Boolean.class, 12);
        }
        if (this.isMSSQL) {
            dataStore.getClassToSqlTypeMappings().put(Boolean.class, 12);
        }
        SimpleFeatureCollection gmlFeatCollection = (SimpleFeatureCollection)this.parser.parse(in);
        List validationErrors = this.parser.getValidationErrors();
        if (!validationErrors.isEmpty()) {
            LOG.warn((Object)("Er zijn validatie fouten opgetreden tijdens verwerking van bestand: " + gmlFileName));
            for (Exception e : validationErrors) {
                LOG.warn((Object)("validatie fout: " + e.getMessage()));
            }
        }
        if (gmlFeatCollection.isEmpty()) {
            this.opmerkingen.append("Geen features gevonden in bestand: ").append(gmlFileName).append("\n");
            LOG.info((Object)("Geen features gevonden in bestand: " + gmlFileName));
            dataStore.dispose();
            return 0;
        }
        SimpleFeatureType sft = (SimpleFeatureType)gmlFeatCollection.getSchema();
        GMLLightFeatureTransformer featTransformer = BGTGMLLightTransformerFactory.getTransformer(sft.getTypeName());
        if (featTransformer == null) {
            LOG.error((Object)("Opzoeken van FeatureTransformer voor " + sft.getTypeName() + " is mislukt; er geen transformer beschikbaar voor dit bestand."));
            dataStore.dispose();
            return 0;
        }
        String tableName = BGTGMLLightTransformerFactory.getTableName(sft.getTypeName());
        boolean exists = false;
        for (String name : typeNames = dataStore.getTypeNames()) {
            if (!tableName.equalsIgnoreCase(name)) continue;
            LOG.debug((Object)("De tabel '" + tableName + "' is gevonden in de database als: " + name));
            exists = true;
        }
        SimpleFeatureType targetSchema = featTransformer.getTargetSchema(sft, tableName, this.isOracle);
        LOG.debug((Object)("Doel tabel schema: " + targetSchema));
        if (!exists) {
            if (!this.createTables) {
                LOG.error((Object)("Tabel: " + tableName + " is niet beschikbaar in de database."));
                throw new IllegalStateException("De tabel " + tableName + " ontbreekt in de database; opslaan van gegevens uit GML " + gmlFileName + " is niet mogelijk.");
            }
            dataStore.createSchema(targetSchema);
            LOG.warn((Object)("De volgende tabel is aangemaakt in de database: " + targetSchema.getTypeName()));
            if (this.isOracle) {
                try {
                    dataStore.getConnection(Transaction.AUTO_COMMIT).createStatement().execute("UPDATE USER_SDO_GEOM_METADATA SET SRID=28992");
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Bijwerken ruimtelijke metadata is mislukt", (Throwable)ex);
                }
            }
        } else {
            dataStore.setExposePrimaryKeyColumns(true);
            LOG.info((Object)("Probeer tabel leeg te maken: " + targetSchema.getTypeName()));
            try {
                StringBuffer sql = new StringBuffer("TRUNCATE TABLE ");
                Method encodeTableName = dataStore.getClass().getDeclaredMethod("encodeTableName", String.class, StringBuffer.class, Hints.class);
                encodeTableName.setAccessible(true);
                encodeTableName.invoke((Object)dataStore, targetSchema.getTypeName(), sql, null);
                if (this.isOracle) {
                    sql.append(" PURGE MATERIALIZED VIEW LOG REUSE STORAGE");
                }
                LOG.debug((Object)("SQL: " + sql.toString()));
                new QueryRunner(dataStore.getDataSource()).update(sql.toString());
                LOG.info((Object)"Tabel leeggemaakt");
            }
            catch (Exception e) {
                LOG.debug((Object)"Exception bij TRUNCATE", (Throwable)e);
                LOG.error((Object)("Fout bij TRUNCATE, probeer met DELETE FROM: " + e.getClass() + ": " + e.getMessage()));
                try {
                    StringBuffer sql = new StringBuffer("DELETE FROM ");
                    Method encodeTableName = dataStore.getClass().getDeclaredMethod("encodeTableName", String.class, StringBuffer.class, Hints.class);
                    encodeTableName.setAccessible(true);
                    encodeTableName.invoke((Object)dataStore, targetSchema.getTypeName(), sql, null);
                    LOG.debug((Object)("SQL: " + sql.toString()));
                    new QueryRunner(dataStore.getDataSource()).update(sql.toString());
                    LOG.info((Object)"Tabel leeggemaakt met DELETE FROM");
                }
                catch (Exception e2) {
                    LOG.error((Object)"Fout bij DELETE FROM, tabel kon niet leeggemaakt worden! ", (Throwable)e2);
                }
            }
        }
        HashMap<String, ImmutablePair> records = new HashMap<String, ImmutablePair>();
        DefaultTransaction transaction = new DefaultTransaction("add-bgt");
        DefaultTransaction updatetransaction = new DefaultTransaction("update-bgt");
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        try (SimpleFeatureIterator feats = gmlFeatCollection.features();){
            FeatureStore store = (FeatureStore)dataStore.getFeatureSource(targetSchema.getTypeName(), (Transaction)transaction);
            FeatureStore store2 = (FeatureStore)dataStore.getFeatureSource(targetSchema.getTypeName(), (Transaction)updatetransaction);
            while (feats.hasNext()) {
                boolean beeindigd;
                SimpleFeature gmlSF = (SimpleFeature)feats.next();
                ++features;
                SimpleFeature transformed = featTransformer.transform(gmlSF, targetSchema, this.isOracle, dataStore.isExposePrimaryKeyColumns());
                if (transformed == null) {
                    LOG.warn((Object)("Fout bij transformeren feature op index " + features + ", null geretourneerd"));
                    continue;
                }
                String id = transformed.getID();
                Pair record = (Pair)records.get(id);
                Date tijdstipRegistratie = (Date)gmlSF.getAttribute("tijdstipRegistratie");
                if (tijdstipRegistratie == null) {
                    LOG.error((Object)("Feature voor object " + id + " zonder tijdstipRegistratie gevonden, genegeerd"));
                    continue;
                }
                boolean bl = beeindigd = gmlSF.getAttribute("objectEindTijd") != null;
                if (LOG.isDebugEnabled()) {
                    Object[] objectArray = new Object[5];
                    objectArray[0] = id;
                    objectArray[1] = beeindigd ? "ja" : "nee";
                    objectArray[2] = tijdstipRegistratie;
                    Object object = objectArray[3] = record != null ? record.getLeft() : null;
                    objectArray[4] = record != null ? (((Boolean)record.getRight()).booleanValue() ? "ja" : "nee") : "-";
                    LOG.info((Object)String.format("Object %s, beeindigd=%s, tijdstipRegistratie=%tc, eerder tijdstip %tc, eerder beeindigd %s", objectArray));
                }
                if (record != null && tijdstipRegistratie.before((Date)record.getLeft())) {
                    LOG.warn((Object)String.format("Feature voor object %s gevonden met tijdstipRegistratie %tc eerder dan vorig record van %tc, genegeerd", id, tijdstipRegistratie, record.getLeft()));
                    continue;
                }
                if (beeindigd) {
                    Date eindTijd = (Date)gmlSF.getAttribute("objectEindTijd");
                    if (eindTijd.after(new Date())) {
                        LOG.warn((Object)String.format("Object %s vervallen in de toekomst op %tc, wordt alvast verwijderd!", id, eindTijd));
                    }
                    if (record != null && !((Boolean)record.getRight()).booleanValue()) {
                        LOG.info((Object)String.format("Object %s vervallen met tijdstipRegistratie %tc, verwijder eerder geinsert record met laatste tijdstipRegistratie %tc", id, tijdstipRegistratie, record.getLeft()));
                        transaction.close();
                        Id filter = ff.id(new FeatureId[]{transformed.getIdentifier()});
                        store2.removeFeatures((Filter)filter);
                        updatetransaction.commit();
                        transaction = new DefaultTransaction("add-bgt");
                        store.setTransaction((Transaction)transaction);
                        ++deletes;
                    }
                    records.put(id, new ImmutablePair((Object)tijdstipRegistratie, (Object)true));
                    continue;
                }
                if (record != null) {
                    if (((Boolean)record.getRight()).booleanValue()) {
                        LOG.error((Object)String.format("Object %s was eerder vervallen met tijdstipRegistratie %tc, nu weer niet met tijdstipRegistratie %tc, genegeerd", id, record.getLeft(), tijdstipRegistratie));
                        continue;
                    }
                    transaction.close();
                    Id filter = CommonFactoryFinder.getFilterFactory2(null).id(new FeatureId[]{transformed.getIdentifier()});
                    FeatureIterator bestaandeFeats = store2.getFeatures((Filter)filter).features();
                    SimpleFeature bestaandeFeat = (SimpleFeature)bestaandeFeats.next();
                    String idAttr = this.isOracle ? "identif".toUpperCase() : "identif";
                    for (AttributeDescriptor attr : transformed.getFeatureType().getAttributeDescriptors()) {
                        Name attrName = attr.getName();
                        if (attrName.getLocalPart().equals(idAttr)) continue;
                        store2.modifyFeatures(attrName, transformed.getAttribute(attrName), (Filter)filter);
                    }
                    updatetransaction.commit();
                    LOG.info((Object)String.format("Object %s geupdate van tijdstip %tc naar nieuw tijdstipRegistratie %tc", id, record.getLeft(), tijdstipRegistratie));
                    bestaandeFeats.close();
                    transaction = new DefaultTransaction("add-bgt");
                    store.setTransaction((Transaction)transaction);
                    ++updates;
                } else {
                    store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)transformed));
                    ++inserts;
                    transaction.commit();
                    LOG.debug((Object)String.format("Object toegevoegd in database met NEN3610ID: %s en tijdstipRegistratie %tc", id, tijdstipRegistratie));
                }
                records.put(id, new ImmutablePair((Object)tijdstipRegistratie, (Object)false));
            }
            String s = String.format("Totaal verwerkte features voor %s: %d, inserts: %d, updates: %d, deletes: %d\n", gmlFileName, features, inserts, updates, deletes);
            this.opmerkingen.append(s).append("\n");
            LOG.info((Object)s);
            return inserts;
        }
        catch (IOException ioe) {
            String s = String.format("Fout opgetreden, hiervoor verwerkte features voor %s: %d, inserts: %d, updates: %d, deletes: %d\n", gmlFileName, features, inserts, updates, deletes);
            this.opmerkingen.append(s).append("\n");
            LOG.info((Object)s);
            LOG.error((Object)"I/O database probleem tijdens insert van features", (Throwable)ioe);
            this.status = STATUS.NOK;
            transaction.rollback();
            return inserts;
        }
        finally {
            try {
                transaction.close();
                updatetransaction.close();
                dataStore.dispose();
            }
            catch (Exception e) {
                LOG.error((Object)"Fout sluiten datastores", (Throwable)e);
            }
        }
    }

    private boolean isDuplicateKeyViolationMessage(String message) {
        return message != null && message.startsWith("ORA-00001:") | message.startsWith("ERROR: duplicate key value violates unique constraint") | message.contains("Cannot insert duplicate key in object");
    }

    public List<File> scanDirectory() {
        List<File> zipfiles = Collections.emptyList();
        if (this.scanDirectory != null && this.scanDirectory.isDirectory() && this.scanDirectory.canExecute()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith("zip");
                }
            };
            File[] files = this.scanDirectory.listFiles(filter);
            zipfiles = Arrays.asList(files);
        } else {
            LOG.fatal((Object)("De directory (" + this.scanDirectory + ") kan niet worden gelezen of doorbladerd."));
            this.status = STATUS.NOK;
        }
        return zipfiles;
    }

    public void setScanDirectory(String scanDirectory) {
        this.scanDirectory = new File(scanDirectory);
    }

    public void setScanDirectory(File scanDirectory) {
        this.scanDirectory = scanDirectory;
    }

    public void setDbConnProps(Properties dbConnProps) {
        this.dbConnProps = dbConnProps;
        this.isOracle = "oracle".equalsIgnoreCase(dbConnProps.getProperty("dbtype"));
        this.isMSSQL = "jtds-sqlserver".equalsIgnoreCase(dbConnProps.getProperty("dbtype")) | "sqlserver".equalsIgnoreCase(dbConnProps.getProperty("dbtype"));
    }

    public void setCreateTables(boolean createTables) {
        this.createTables = createTables;
    }

    public void setIsOracle(boolean isOracle) {
        this.isOracle = isOracle;
    }

    public void setIsMSSQL(boolean isMSSQL) {
        this.isMSSQL = isMSSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidZipFile(File file) {
        ZipFile zipfile = null;
        ZipInputStream zis = null;
        String path = null;
        try {
            path = file.getCanonicalPath();
            zipfile = new ZipFile(file, 1);
            zis = new ZipInputStream(new FileInputStream(file));
            ZipEntry ze = zis.getNextEntry();
            if (ze == null) {
                boolean bl = false;
                return bl;
            }
            while (ze != null) {
                zipfile.getInputStream(ze);
                ze.getCrc();
                ze.getCompressedSize();
                ze.getName();
                ze = zis.getNextEntry();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error((Object)("Ongeldige zipfile: " + path), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                    zipfile = null;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Fout tijdens sluiten zipfile, mogelijk corrupt bestand: " + path), (Throwable)e);
            }
            try {
                if (zis != null) {
                    zis.close();
                    zis = null;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Fout tijdens sluiten zipstream, mogelijk corrupt bestand: " + path), (Throwable)e);
            }
        }
    }

    public Geometry getOmhullendeVanZipFile() {
        return this.omhullendeVanZipFile;
    }

    public String getOpmerkingen() {
        return this.opmerkingen.toString();
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void resetStatus() {
        this.status = STATUS.OK;
    }

    public static enum STATUS {
        OK,
        NOK;

    }
}

