/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.util;

import java.lang.reflect.Method;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.logging.Log;
import org.geotools.factory.Hints;
import org.geotools.jdbc.JDBCDataStore;

public class JDBCDataStoreUtil {
    public static boolean truncateTable(JDBCDataStore dataStore, String typeName, boolean isOracle, Log log) {
        log.info((Object)("Probeer tabel leeg te maken: " + typeName));
        try {
            StringBuffer sql = new StringBuffer("TRUNCATE TABLE ");
            Method encodeTableName = dataStore.getClass().getDeclaredMethod("encodeTableName", String.class, StringBuffer.class, Hints.class);
            encodeTableName.setAccessible(true);
            encodeTableName.invoke((Object)dataStore, typeName, sql, null);
            if (isOracle) {
                sql.append(" PURGE MATERIALIZED VIEW LOG REUSE STORAGE");
            }
            log.trace((Object)("SQL: " + sql.toString()));
            new QueryRunner(dataStore.getDataSource()).update(sql.toString());
            log.info((Object)"Tabel leeggemaakt");
            return true;
        }
        catch (Exception e) {
            log.debug((Object)"Exception bij TRUNCATE", (Throwable)e);
            log.warn((Object)("Fout bij TRUNCATE, probeer met DELETE FROM: " + e.getClass() + ": " + e.getMessage()));
            try {
                StringBuffer sql = new StringBuffer("DELETE FROM ");
                Method encodeTableName = dataStore.getClass().getDeclaredMethod("encodeTableName", String.class, StringBuffer.class, Hints.class);
                encodeTableName.setAccessible(true);
                encodeTableName.invoke((Object)dataStore, typeName, sql, null);
                log.trace((Object)("SQL: " + sql.toString()));
                new QueryRunner(dataStore.getDataSource()).update(sql.toString());
                log.info((Object)"Tabel leeggemaakt met DELETE FROM");
                return true;
            }
            catch (Exception e2) {
                log.error((Object)"Fout bij DELETE FROM, tabel kon niet leeggemaakt worden! ", (Throwable)e2);
                return false;
            }
        }
    }
}

