/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.gml;

import java.util.HashMap;
import java.util.Map;
import nl.b3p.brmo.loader.gml.GMLLightFeatureTransformer;

public enum BGTGMLLightTransformerFactory {
    bak("bgt_bak.gml", "Bak"),
    bord("bgt_bord.gml", "Bord"),
    put("bgt_put.gml", "Put"),
    paal("bgt_paal.gml", "Paal"),
    mast("bgt_mast.gml", "Mast"),
    sensor("bgt_sensor.gml", "Sensor"),
    installatie("bgt_installatie.gml", "Installatie"),
    kast("bgt_kast.gml", "Kast"),
    gebouw_installatie("bgt_buildinginstallation.gml", "GebouwInstallatie"),
    pand("bgt_buildingpart.gml", "Pand"),
    overig_bouwwerk("bgt_overigbouwwerk.gml", "OverigBouwwerk"),
    openbareruimte("bgt_openbareruimte.gml", "OpenbareRuimte"),
    openbareruimtelabel("bgt_openbareruimtelabel.gml", "OpenbareRuimteLabel"),
    functioneelgebied("bgt_functioneelgebied.gml", "FunctioneelGebied"),
    stadsdeel("bgt_stadsdeel.gml", "Stadsdeel"),
    buurt("bgt_buurt.gml", "Buurt"),
    wijk("bgt_wijk.gml", "Wijk"),
    waterschap("bgt_waterschap.gml", "Waterschap"),
    ongeclassificeerdobject("bgt_ongeclassificeerdobject.gml", "OngeclassificeerdObject"),
    begroeid_terreindeel("bgt_begroeidterreindeel.gml", "BegroeidTerreindeel"),
    onbegroeid_terreindeel("bgt_onbegroeidterreindeel.gml", "OnbegroeidTerreindeel"),
    vegetatieobject("bgt_vegetatieobject.gml", "VegetatieObject"),
    spoor("bgt_spoor.gml", "Spoor"),
    scheiding("bgt_scheiding.gml", "Scheiding"),
    overige_scheiding("bgt_overigescheiding.gml", "OverigeScheiding"),
    waterdeel("bgt_waterdeel.gml", "Waterdeel"),
    ondersteunend_waterdeel("bgt_ondersteunendwaterdeel.gml", "OndersteunendWaterdeel"),
    waterinrichtingselement("bgt_waterinrichtingselement.gml", "Waterinrichtingselement"),
    overbruggingsdeel("bgt_overbruggingsdeel.gml", "Overbruggingsdeel"),
    kunstwerkdeel("bgt_kunstwerkdeel.gml", "Kunstwerkdeel"),
    ondersteunend_wegdeel("bgt_ondersteunendwegdeel.gml", "OndersteunendWegdeel"),
    wegdeel("bgt_wegdeel.gml", "Wegdeel"),
    tunneldeel("bgt_tunneldeel.gml", "Tunneldeel"),
    straatmeubilair("bgt_straatmeubilair.gml", "Straatmeubilair"),
    weginrichtingselement("bgt_weginrichtingselement.gml", "Weginrichtingselement");

    private final String gmlFileName;
    private final String transformerClassName;
    private static final Map<String, BGTGMLLightTransformerFactory> lookup;

    private BGTGMLLightTransformerFactory(String gmlFileName, String transformerClassName) {
        this.gmlFileName = gmlFileName;
        this.transformerClassName = transformerClassName;
    }

    public String getGmlFileName() {
        return this.gmlFileName;
    }

    public String getTransformerClassName() {
        return this.transformerClassName;
    }

    public static String getTableName(String gmlFileName) {
        return lookup.get(gmlFileName).name();
    }

    public static GMLLightFeatureTransformer getTransformer(String gmlFileName) {
        try {
            Class<?> c = Class.forName(GMLLightFeatureTransformer.class.getPackage().getName() + ".light." + lookup.get(gmlFileName).getTransformerClassName());
            return (GMLLightFeatureTransformer)c.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException ex) {
            return null;
        }
    }

    static {
        lookup = new HashMap<String, BGTGMLLightTransformerFactory>();
        for (BGTGMLLightTransformerFactory d : BGTGMLLightTransformerFactory.values()) {
            lookup.put(d.getTransformerClassName(), d);
        }
    }
}

