/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.SchemaException;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.json.simple.parser.JSONParser;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class PDOKBGTLightUtil {
    private static final Log LOG = LogFactory.getLog(PDOKBGTLightUtil.class);
    public static final String TILEINFO_F_TYPE = "geom:Polygon:srid=28992,extractset:String,id:Integer";

    public static Set<Integer> calculateGridIds(String wktGeom, String jsonUrl) {
        Geometry geometry = null;
        SimpleFeatureCollection fc = null;
        try {
            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
            WKTReader reader = new WKTReader(geometryFactory);
            geometry = reader.read(wktGeom);
            geometry.setSRID(28992);
            URL u = new URL(jsonUrl);
            JSONParser parser = new JSONParser();
            Object json = parser.parse((Reader)new InputStreamReader(u.openStream()));
            FeatureJSON io = new FeatureJSON();
            try {
                SimpleFeatureType jsonType = DataUtilities.createType((String)"tileinfo", (String)TILEINFO_F_TYPE);
                io.setFeatureType(jsonType);
            }
            catch (SchemaException se) {
                LOG.warn((Object)"Aanmaken van tileinfo featuretype is mislukt", (Throwable)se);
            }
            fc = (SimpleFeatureCollection)io.readFeatureCollection((Object)json.toString());
        }
        catch (ParseException ex) {
            LOG.error((Object)"Parsen van de WKT selectie geometrie is mislukt", (Throwable)ex);
        }
        catch (IOException | org.json.simple.parser.ParseException io) {
            LOG.error((Object)"Ophalen of parsen van de geojson file met tiles is mislukt", io);
        }
        return PDOKBGTLightUtil.calculateGridIds(geometry, fc);
    }

    public static Set<Integer> calculateGridIds(Geometry aoi, SimpleFeatureCollection grid) {
        TreeSet<Integer> ids = new TreeSet<Integer>();
        aoi = aoi.buffer(10.0, 1);
        try (SimpleFeatureIterator sfi = grid.features();){
            while (sfi.hasNext()) {
                SimpleFeature sf = (SimpleFeature)sfi.next();
                if (!aoi.intersects((Geometry)sf.getDefaultGeometry())) continue;
                LOG.debug((Object)(sf.getAttribute("id") + " Toevoegen aan de lijst van op te halen ids"));
                ids.add((Integer)sf.getAttribute("id"));
            }
        }
        LOG.debug((Object)("De lijst bevat de volgende id's: " + ids));
        return ids;
    }

    private PDOKBGTLightUtil() {
    }
}

