/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.b3p.brmo.bgt.loader.Utils;
import nl.b3p.brmo.schema.ObjectType;
import nl.b3p.brmo.schema.Schema;
import nl.b3p.brmo.schema.mapping.AttributeColumnMapping;
import nl.b3p.brmo.sql.dialect.SQLDialect;

public abstract class SchemaSQLMapper {
    private final Schema schema;
    protected final Map<String, String> objectTypeNameToTableName = new HashMap<String, String>();
    private static final Set<String> reservedWords = Stream.of(new String[]{"function"}).collect(Collectors.toSet());

    public SchemaSQLMapper(Schema schema) {
        this.schema = schema;
        schema.getAllObjectTypes().map(ObjectType::getName).forEach(name -> this.objectTypeNameToTableName.put((String)name, name.toLowerCase()));
    }

    public Schema getSchema() {
        return this.schema;
    }

    public abstract String getMetadataTableName();

    public String getTableNameForObjectType(ObjectType objectType, String tablePrefix) {
        return tablePrefix + this.objectTypeNameToTableName.get(objectType.getName());
    }

    public String getColumnNameForObjectType(ObjectType objectType, String attributeName) {
        if (reservedWords.contains(attributeName = ((String)attributeName).toLowerCase())) {
            attributeName = (String)attributeName + "_";
        }
        String tableNameLower = this.getTableNameForObjectType(objectType, null).toLowerCase();
        String attributeNameLower = ((String)attributeName).toLowerCase();
        int i = attributeNameLower.indexOf(tableNameLower);
        if (i != -1) {
            attributeName = new StringBuilder((String)attributeName).replace(i, i + tableNameLower.length(), "").toString();
        }
        return ((String)attributeName).replaceAll("\\-", "_");
    }

    public void printSchema(SQLDialect dialect, String tablePrefix, Predicate<ObjectType> objectTypeFilter) {
        TreeMap<String, ObjectType> tableNamesObjectTypes = new TreeMap<String, ObjectType>(this.getSchema().getAllObjectTypes().filter(objectTypeFilter == null ? objectType -> true : objectTypeFilter).collect(Collectors.toMap(objectType -> this.getTableNameForObjectType((ObjectType)objectType, ""), objectType -> objectType)));
        String createTable = tableNamesObjectTypes.values().stream().flatMap(objectType -> this.getCreateTableStatements((ObjectType)objectType, dialect, tablePrefix)).collect(Collectors.joining("; \n\n"));
        System.out.println(createTable + ";\n\n");
        String geometryMetadata = tableNamesObjectTypes.values().stream().flatMap(objectType -> this.getCreateGeometryMetadataStatements((ObjectType)objectType, dialect, tablePrefix)).filter(sql -> sql.length() > 0).collect(Collectors.joining(";\n"));
        if (geometryMetadata.length() > 0) {
            System.out.printf("-- %s\n\n", Utils.getBundleString("schema.geometry_metadata"));
            System.out.println(geometryMetadata + ";\n");
        }
        System.out.printf("-- %s\n\n", Utils.getBundleString("schema.loader_metadata"));
        System.out.println(this.getCreateMetadataTableStatements(dialect, tablePrefix).stream().collect(Collectors.joining(";\n")) + ";\n");
        System.out.printf("-- %s %s\n\n", Utils.getBundleString("schema.primary_keys"), Utils.getBundleString("schema.after_initial_load"));
        String primaryKeys = tableNamesObjectTypes.values().stream().flatMap(objectType -> this.getCreatePrimaryKeyStatements((ObjectType)objectType, dialect, tablePrefix)).collect(Collectors.joining("; \n"));
        System.out.println(primaryKeys + ";\n");
        System.out.printf("-- %s %s\n\n", Utils.getBundleString("schema.geometry_indexes"), Utils.getBundleString("schema.after_initial_load"));
        String geometryIndexes = tableNamesObjectTypes.values().stream().flatMap(objectType -> this.getCreateGeometryIndexStatements((ObjectType)objectType, dialect, tablePrefix)).collect(Collectors.joining(";\n"));
        System.out.println(geometryIndexes + ";\n");
    }

    public Stream<String> getCreateTableStatements(ObjectType objectType, SQLDialect dialect, String tablePrefix) {
        ArrayList<Object> statements = new ArrayList<Object>();
        String tableName = this.getTableNameForObjectType(objectType, tablePrefix);
        if (dialect.supportsDropTableIfExists()) {
            statements.add("drop table if exists " + tableName);
        }
        String columns = objectType.getDirectAttributes().stream().map(column -> String.format("  %s %s%s", this.getColumnNameForObjectType(objectType, column.getName()), dialect.getType(column.getType()), column.isNotNull() ? " not null" : "")).collect(Collectors.joining(",\n"));
        statements.add(String.format("create table %s (\n%s\n)", tableName, columns));
        statements.addAll(objectType.getOneToManyAttributeObjectTypes().stream().flatMap(oneToManyObjectType -> this.getCreateTableStatements((ObjectType)oneToManyObjectType, dialect, tablePrefix)).collect(Collectors.toList()));
        return statements.stream();
    }

    public Stream<String> getCreatePrimaryKeyStatements(ObjectType objectType, SQLDialect dialect, String tablePrefix) {
        return this.getCreatePrimaryKeyStatements(objectType, dialect, tablePrefix, true);
    }

    public Stream<String> getCreatePrimaryKeyStatements(ObjectType objectType, SQLDialect dialect, String tablePrefix, boolean includeOneToMany) {
        String tableName = this.getTableNameForObjectType(objectType, tablePrefix);
        String columns = objectType.getDirectAttributes().stream().filter(AttributeColumnMapping::isPrimaryKey).map(column -> this.getColumnNameForObjectType(objectType, column.getName())).collect(Collectors.joining(", "));
        String sql = String.format("alter table %s add constraint %s_pkey primary key(%s)", tableName, tableName, columns);
        return Stream.concat(Stream.of(sql), includeOneToMany ? objectType.getOneToManyAttributeObjectTypes().stream().flatMap(oneToManyObjectType -> this.getCreatePrimaryKeyStatements((ObjectType)oneToManyObjectType, dialect, tablePrefix)) : Stream.empty());
    }

    public Stream<String> getCreateGeometryMetadataStatements(ObjectType objectType, SQLDialect dialect, String tablePrefix) {
        return Stream.concat(objectType.getGeometryAttributes().stream().map(column -> dialect.getCreateGeometryMetadataSQL(this.getTableNameForObjectType(objectType, tablePrefix), this.getColumnNameForObjectType(objectType, column.getName()), column.getType())), objectType.getOneToManyAttributeObjectTypes().stream().flatMap(oneToManyObjectType -> this.getCreateGeometryMetadataStatements((ObjectType)oneToManyObjectType, dialect, tablePrefix)));
    }

    public Stream<String> getCreateGeometryIndexStatements(ObjectType objectType, SQLDialect dialect, String tablePrefix) {
        return this.getCreateGeometryIndexStatements(objectType, dialect, tablePrefix, true);
    }

    public Stream<String> getCreateGeometryIndexStatements(ObjectType objectType, SQLDialect dialect, String tablePrefix, boolean includeOneToMany) {
        return Stream.concat(objectType.getGeometryAttributes().stream().map(column -> dialect.getCreateGeometryIndexSQL(this.getTableNameForObjectType(objectType, tablePrefix), this.getColumnNameForObjectType(objectType, column.getName()), column.getType())), includeOneToMany ? objectType.getOneToManyAttributeObjectTypes().stream().flatMap(oneToManyObjectType -> this.getCreateGeometryIndexStatements((ObjectType)oneToManyObjectType, dialect, tablePrefix)) : Stream.empty());
    }

    public List<String> getCreateMetadataTableStatements(SQLDialect dialect, String tablePrefix) {
        ArrayList<String> statements = new ArrayList<String>();
        String tableName = this.getMetadataTableName();
        if (dialect.supportsDropTableIfExists()) {
            statements.add("drop table if exists " + tableName);
        }
        String sql = String.format("create table %s(\n  naam %s,\n  waarde %s,\n  primary key(naam)\n)", tableName, dialect.getType("varchar(255)"), dialect.getType("text"));
        statements.add(sql);
        return statements;
    }

    public int getMaxTableLength() {
        return this.objectTypeNameToTableName.values().stream().map(String::length).reduce(0, Integer::max);
    }
}

