/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.schema.mapping;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import nl.b3p.brmo.schema.mapping.AttributeColumnMapping;

public class SimpleDateFormatAttributeColumnMapping
extends AttributeColumnMapping {
    public static final String PATTERN_XML_DATE = "yyyy-MM-dd";
    public static final String PATTERN_XML_TIMESTAMP = "yyyy-MM-dd'T'HH:mm:ss";
    private final SimpleDateFormat dateFormat;

    public SimpleDateFormatAttributeColumnMapping(String name, String type, boolean notNull, boolean primaryKey, String dateFormatPattern) {
        super(name, type, notNull, primaryKey);
        this.dateFormat = new SimpleDateFormat(dateFormatPattern);
    }

    public SimpleDateFormatAttributeColumnMapping(String name, String type, boolean notNull, String dateFormatPattern) {
        this(name, type, notNull, false, dateFormatPattern);
    }

    public SimpleDateFormatAttributeColumnMapping(String name, String type, String dateFormatPattern) {
        this(name, type, true, false, dateFormatPattern);
    }

    @Override
    public Object toQueryParameter(Object value) throws ParseException {
        if (value == null) {
            return null;
        }
        Date date = this.dateFormat.parse(value.toString());
        if ("timestamp".equals(this.getType())) {
            return new Timestamp(date.getTime());
        }
        return new java.sql.Date(date.getTime());
    }
}

