/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.schema;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.b3p.brmo.schema.ObjectType;
import nl.b3p.brmo.schema.SchemaObjectInstance;
import nl.b3p.brmo.schema.SchemaSQLMapper;
import nl.b3p.brmo.schema.mapping.AttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.GeometryAttributeColumnMapping;
import nl.b3p.brmo.sql.GeometryHandlingPreparedStatementBatch;
import nl.b3p.brmo.sql.PostGISCopyInsertBatch;
import nl.b3p.brmo.sql.QueryBatch;
import nl.b3p.brmo.sql.dialect.PostGISDialect;
import nl.b3p.brmo.sql.dialect.SQLDialect;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectTableWriter {
    private static final Log log = LogFactory.getLog(ObjectTableWriter.class);
    private final Connection connection;
    private final SQLDialect dialect;
    private final SchemaSQLMapper schemaSQLMapper;
    private int batchSize = 100;
    private boolean multithreading = true;
    private boolean usePgCopy = true;
    private Integer objectLimit = null;
    private boolean linearizeCurves = false;
    private boolean createSchema = false;
    private String tablePrefix = null;
    private Consumer<Progress> progressUpdater;
    private Progress progress = null;
    private Throwable exceptionFromWorkerThread = null;
    private final Runnable worker = () -> {
        try {
            block3: while (true) {
                ArrayList<SchemaObjectInstance> objects = new ArrayList<SchemaObjectInstance>(this.progress.objectsToWrite.size());
                objects.add(this.progress.objectsToWrite.take());
                this.progress.objectsToWrite.drainTo(objects);
                Iterator iterator = objects.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block3;
                    SchemaObjectInstance object = (SchemaObjectInstance)iterator.next();
                    if (object.getObjectType() == null) {
                        return;
                    }
                    this.addObjectToBatch(object, true);
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            log.error((Object)"Exception in object writing thread", e);
            this.setExceptionFromWorkerThread(e);
        }
    };
    private Thread workerThread = null;

    public ObjectTableWriter(Connection connection, SQLDialect dialect, SchemaSQLMapper schemaSQLMapper) {
        this.connection = connection;
        this.dialect = dialect;
        this.schemaSQLMapper = schemaSQLMapper;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    public SchemaSQLMapper getSchemaSQLMapper() {
        return this.schemaSQLMapper;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isMultithreading() {
        return this.multithreading;
    }

    public void setMultithreading(boolean multithreading) {
        this.multithreading = multithreading;
    }

    public boolean isUsePgCopy() {
        return this.usePgCopy;
    }

    public void setUsePgCopy(boolean usePgCopy) {
        this.usePgCopy = usePgCopy;
    }

    public Integer getObjectLimit() {
        return this.objectLimit;
    }

    public void setObjectLimit(Integer objectLimit) {
        this.objectLimit = objectLimit;
    }

    public boolean isLinearizeCurves() {
        return this.linearizeCurves;
    }

    public void setLinearizeCurves(boolean linearizeCurves) {
        this.linearizeCurves = linearizeCurves;
    }

    public boolean isCreateSchema() {
        return this.createSchema;
    }

    public void setCreateSchema(boolean createSchema) {
        this.createSchema = createSchema;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public Consumer<Progress> getProgressUpdater() {
        return this.progressUpdater;
    }

    public void setProgressUpdater(Consumer<Progress> progressUpdater) {
        this.progressUpdater = progressUpdater;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    protected void prepareDatabaseForObject(SchemaObjectInstance object) throws Exception {
        this.getInsertBatch(object);
    }

    protected synchronized QueryBatch getInsertBatch(SchemaObjectInstance object) throws Exception {
        Map<ObjectType, QueryBatch> insertBatches = this.progress.insertBatches;
        if (insertBatches.isEmpty() && this.progress.initialLoad) {
            if (this.isCreateSchema()) {
                QueryRunner qr = new QueryRunner();
                for (String sql : Stream.concat(this.schemaSQLMapper.getCreateTableStatements(object.getObjectType(), this.dialect, this.tablePrefix), this.schemaSQLMapper.getCreateGeometryMetadataStatements(object.getObjectType(), this.dialect, this.tablePrefix)).collect(Collectors.toList())) {
                    qr.update(this.connection, sql);
                }
            } else {
                this.truncateTable(this.connection, object.getObjectType());
                for (ObjectType oneToManyObjectType : object.getObjectType().getOneToManyAttributeObjectTypes()) {
                    this.truncateTable(this.connection, oneToManyObjectType);
                }
            }
        }
        if (!insertBatches.containsKey(object.getObjectType())) {
            QueryBatch queryBatch;
            String sql;
            if (this.dialect instanceof PostGISDialect && this.usePgCopy) {
                sql = this.buildPgCopySql(object, this.progress.initialLoad);
                boolean bufferCopy = !this.progress.singleTableInserts;
                queryBatch = new PostGISCopyInsertBatch(this.connection, sql, this.batchSize, this.dialect, bufferCopy, this.linearizeCurves);
            } else {
                sql = this.buildInsertSql(object);
                Boolean[] parameterIsGeometry = (Boolean[])object.getObjectType().getDirectAttributes().stream().map(attributeColumnMapping -> attributeColumnMapping instanceof GeometryAttributeColumnMapping).toArray(Boolean[]::new);
                queryBatch = new GeometryHandlingPreparedStatementBatch(this.connection, sql, this.batchSize, this.dialect, parameterIsGeometry, this.linearizeCurves);
            }
            insertBatches.put(object.getObjectType(), queryBatch);
        }
        return insertBatches.get(object.getObjectType());
    }

    protected void addObjectToBatch(SchemaObjectInstance object) throws Exception {
        if (this.progress.firstObject) {
            this.progress.setSingleTableInserts(this.progress.initialLoad && object.getObjectType().getOneToManyAttributeObjectTypes().isEmpty());
            this.progress.firstObject = false;
        }
        try {
            this.addObjectToBatch(object, false);
        }
        catch (Throwable e) {
            String message = "Exception writing object to database, object: ";
            if (this.getBatchSize() > 1) {
                message = "Exception adding parameters to database write batch, may be caused by previous batches. Object: ";
            }
            throw new Exception(message + object, e);
        }
    }

    private void addObjectToBatch(SchemaObjectInstance object, boolean fromWorkerThread) throws Throwable {
        if (this.multithreading && !fromWorkerThread) {
            while (this.exceptionFromWorkerThread == null) {
                if (!this.progress.objectsToWrite.offer(object, 500L, TimeUnit.MILLISECONDS)) continue;
                return;
            }
            throw this.exceptionFromWorkerThread;
        }
        QueryBatch batch = this.getInsertBatch(object);
        Map<String, Object> attributes = object.getAttributes();
        ArrayList<Object> params = new ArrayList<Object>();
        for (AttributeColumnMapping attributeColumnMapping : object.getObjectType().getDirectAttributes()) {
            Object attribute = attributes.get(attributeColumnMapping.getName());
            params.add(attributeColumnMapping.toQueryParameter(attribute));
        }
        for (ObjectType oneToManyAttribute : object.getObjectType().getOneToManyAttributeObjectTypes()) {
            List objects = (List)attributes.get(oneToManyAttribute.getName());
            if (objects == null || objects.isEmpty()) continue;
            for (int i = 0; i < objects.size(); ++i) {
                SchemaObjectInstance oneToMany = (SchemaObjectInstance)objects.get(i);
                String tableName = this.schemaSQLMapper.getTableNameForObjectType(object.getObjectType(), "");
                String idColumnName = object.getObjectType().getPrimaryKeys().get(0).getName();
                oneToMany.getAttributes().put(this.schemaSQLMapper.getColumnNameForObjectType(oneToMany.getObjectType(), tableName + idColumnName), object.getAttributes().get(idColumnName));
                oneToMany.getAttributes().put("idx", i);
                Object eindRegistratie = object.getAttributes().get("eindRegistratie");
                oneToMany.getAttributes().put(this.schemaSQLMapper.getColumnNameForObjectType(oneToMany.getObjectType(), tableName + "eindRegistratie"), eindRegistratie != null);
                this.addObjectToBatch(oneToMany, fromWorkerThread);
            }
        }
        batch.addBatch(params.toArray());
        this.updateProgress();
    }

    private synchronized Throwable getExceptionFromWorkerThread() {
        return this.exceptionFromWorkerThread;
    }

    private synchronized void setExceptionFromWorkerThread(Throwable exceptionFromWorkerThread) {
        this.exceptionFromWorkerThread = exceptionFromWorkerThread;
    }

    protected void updateProgress(Stage stage) {
        this.progress.stage = stage;
        this.updateProgress(true);
    }

    protected void updateProgress() {
        this.updateProgress(false);
    }

    private void updateProgress(boolean always) {
        boolean timeForProgress;
        if (this.progressUpdater == null) {
            return;
        }
        boolean bl = timeForProgress = this.progress.lastProgressUpdate == null || this.progress.objectCount % 500L == 0L && (double)Duration.between(this.progress.lastProgressUpdate, Instant.now()).getNano() > 2.5E8;
        if (always || timeForProgress) {
            this.progressUpdater.accept(this.progress);
            this.progress.lastProgressUpdate = Instant.now();
        }
    }

    private void truncateTable(Connection c, ObjectType objectType) throws SQLException {
        new QueryRunner().execute(c, String.format("truncate table %s", this.schemaSQLMapper.getTableNameForObjectType(objectType, this.tablePrefix)), new Object[0]);
    }

    private String buildInsertSql(SchemaObjectInstance object) {
        StringBuilder sql = new StringBuilder("insert into ");
        String tableName = this.schemaSQLMapper.getTableNameForObjectType(object.getObjectType(), this.tablePrefix);
        sql.append(tableName).append("(");
        sql.append(this.buildColumnList(object.getObjectType()));
        sql.append(") values (");
        String paramPlaceholders = object.getObjectType().getDirectAttributes().stream().map(c -> "?").collect(Collectors.joining(", "));
        sql.append(paramPlaceholders).append(")");
        return sql.toString();
    }

    private String buildPgCopySql(SchemaObjectInstance object, boolean initialLoad) {
        String tableName = this.schemaSQLMapper.getTableNameForObjectType(object.getObjectType(), this.tablePrefix);
        String copySql = "copy " + tableName + "(" + this.buildColumnList(object.getObjectType()) + ") from stdin";
        return copySql + (initialLoad ? " with freeze" : "");
    }

    private String buildColumnList(ObjectType objectType) {
        return objectType.getDirectAttributes().stream().map(column -> this.schemaSQLMapper.getColumnNameForObjectType(objectType, column.getName())).collect(Collectors.joining(", "));
    }

    protected void start(Progress progress) throws SQLException {
        this.progress = progress;
        this.getConnection().setAutoCommit(false);
        if (this.multithreading) {
            this.workerThread = new Thread(this.worker);
            this.workerThread.start();
        }
    }

    protected void endOfObjects() throws Exception {
        if (this.workerThread != null) {
            this.progress.objectsToWrite.put(new SchemaObjectInstance(null, Collections.emptyMap()));
            this.workerThread.join();
        }
        for (QueryBatch batch : this.progress.insertBatches.values()) {
            batch.executeBatch();
        }
    }

    protected void complete() throws SQLException {
        if (this.isCreateSchema() && this.progress.initialLoad) {
            QueryRunner qr = new QueryRunner();
            this.updateProgress(Stage.CREATE_PRIMARY_KEY);
            for (ObjectType objectType : this.progress.insertBatches.keySet()) {
                for (String sql : this.schemaSQLMapper.getCreatePrimaryKeyStatements(objectType, this.dialect, this.tablePrefix, false).collect(Collectors.toList())) {
                    qr.update(this.connection, sql);
                }
            }
            this.updateProgress(Stage.CREATE_GEOMETRY_INDEX);
            for (ObjectType objectType : this.progress.insertBatches.keySet()) {
                for (String sql : this.schemaSQLMapper.getCreateGeometryIndexStatements(objectType, this.dialect, this.tablePrefix, false).collect(Collectors.toList())) {
                    qr.update(this.connection, sql);
                }
            }
        }
        this.connection.commit();
        this.updateProgress(Stage.FINISHED);
    }

    protected void closeBatches() {
        this.progress.insertBatches.values().stream().forEach(QueryBatch::closeQuietly);
    }

    public class Progress {
        private Map<ObjectType, QueryBatch> insertBatches = new HashMap<ObjectType, QueryBatch>();
        private boolean initialLoad = true;
        private boolean firstObject = true;
        private boolean singleTableInserts = false;
        private final BlockingQueue<SchemaObjectInstance> objectsToWrite;
        private Stage stage = Stage.PARSE_INPUT;
        private long objectCount = 0L;
        private Instant lastProgressUpdate = null;

        protected Progress() {
            int batchSize = ObjectTableWriter.this.getBatchSize();
            if (batchSize <= 0) {
                batchSize = 2500;
            }
            this.objectsToWrite = new ArrayBlockingQueue<SchemaObjectInstance>(batchSize);
        }

        public void setSingleTableInserts(boolean singleTableInserts) {
            this.singleTableInserts = singleTableInserts;
        }

        public void setInitialLoad(boolean initialLoad) {
            this.initialLoad = initialLoad;
        }

        public ObjectTableWriter getWriter() {
            return ObjectTableWriter.this;
        }

        public Stage getStage() {
            return this.stage;
        }

        public long getObjectCount() {
            return this.objectCount;
        }

        public void setObjectCount(long objectCount) {
            this.objectCount = objectCount;
        }
    }

    public static enum Stage {
        PARSE_INPUT,
        LOAD_OBJECTS,
        CREATE_PRIMARY_KEY,
        CREATE_GEOMETRY_INDEX,
        FINISHED;

    }
}

