/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.schema;

import java.util.List;
import java.util.stream.Collectors;
import nl.b3p.brmo.schema.Schema;
import nl.b3p.brmo.schema.mapping.AttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.GeometryAttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.OneToManyColumnMapping;

public class ObjectType {
    private final String name;
    private final Schema schema;
    private List<AttributeColumnMapping> attributes;
    private final List<AttributeColumnMapping> primaryKeys;
    private final List<AttributeColumnMapping> directAttributes;
    private final List<GeometryAttributeColumnMapping> geometryAttributes;
    private List<ObjectType> oneToManyAttributeObjectTypes;

    protected ObjectType(Schema schema, String name, List<AttributeColumnMapping> attributes) {
        this.schema = schema;
        this.name = name;
        this.attributes = attributes;
        this.primaryKeys = attributes.stream().filter(AttributeColumnMapping::isPrimaryKey).collect(Collectors.toList());
        this.directAttributes = attributes.stream().filter(attributeColumnMapping -> !(attributeColumnMapping instanceof OneToManyColumnMapping)).collect(Collectors.toList());
        this.geometryAttributes = attributes.stream().filter(attributeColumnMapping -> attributeColumnMapping instanceof GeometryAttributeColumnMapping).map(attributeColumnMapping -> (GeometryAttributeColumnMapping)attributeColumnMapping).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public List<AttributeColumnMapping> getAllAttributes() {
        return this.attributes;
    }

    public List<AttributeColumnMapping> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<AttributeColumnMapping> getDirectAttributes() {
        return this.directAttributes;
    }

    public List<ObjectType> getOneToManyAttributeObjectTypes() {
        if (this.oneToManyAttributeObjectTypes == null) {
            this.oneToManyAttributeObjectTypes = this.attributes.stream().filter(attributeColumnMapping -> attributeColumnMapping instanceof OneToManyColumnMapping).map(attributeColumnMapping -> this.schema.getObjectTypes().get(attributeColumnMapping.getName())).collect(Collectors.toList());
        }
        return this.oneToManyAttributeObjectTypes;
    }

    public List<GeometryAttributeColumnMapping> getGeometryAttributes() {
        return this.geometryAttributes;
    }
}

