/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.loader.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.b3p.brmo.bgt.download.model.DeltaCustomDownloadRequest;
import nl.b3p.brmo.bgt.loader.BGTDatabase;
import nl.b3p.brmo.bgt.loader.ProgressReporter;
import nl.b3p.brmo.bgt.loader.ResumingBGTDownloadInputStream;
import nl.b3p.brmo.bgt.loader.Utils;
import nl.b3p.brmo.bgt.loader.cli.CLIOptions;
import nl.b3p.brmo.bgt.loader.cli.ConsoleProgressReporter;
import nl.b3p.brmo.bgt.loader.cli.DatabaseOptions;
import nl.b3p.brmo.bgt.loader.cli.DownloadCommand;
import nl.b3p.brmo.bgt.loader.cli.FeatureTypeSelectionOptions;
import nl.b3p.brmo.bgt.loader.cli.LoadOptions;
import nl.b3p.brmo.bgt.schema.BGTObjectTableWriter;
import nl.b3p.brmo.bgt.schema.BGTSchemaMapper;
import nl.b3p.brmo.schema.ObjectType;
import nl.b3p.brmo.sql.dialect.SQLDialect;
import nl.b3p.brmo.util.CountingSeekableByteChannel;
import nl.b3p.brmo.util.http.HttpSeekableByteChannel;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.geotools.util.logging.Logging;
import picocli.CommandLine;

@CommandLine.Command(name="bgt-loader", mixinStandardHelpOptions=true, versionProvider=BGTLoaderMain.class, resourceBundle="BGTLoader", subcommands={DownloadCommand.class})
public class BGTLoaderMain
implements CommandLine.IVersionProvider {
    private static Log log;

    public static void configureLogging(boolean standAlone) {
        if (standAlone) {
            PropertyConfigurator.configure((InputStream)BGTLoaderMain.class.getResourceAsStream("/bgt-loader-cli-log4.properties"));
            log = LogFactory.getLog(BGTLoaderMain.class);
            try {
                Logging.ALL.setLoggerFactory("org.geotools.util.logging.Log4JLoggerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            log = LogFactory.getLog(BGTLoaderMain.class);
        }
    }

    public static void main(String[] args) {
        BGTLoaderMain.configureLogging(true);
        CommandLine cmd = new CommandLine((Object)new BGTLoaderMain()).setUsageHelpAutoWidth(true);
        System.exit(cmd.execute(args));
    }

    @CommandLine.Command(name="schema", sortOptions=false)
    public int schema(@CommandLine.Option(names={"--dialect"}, paramLabel="<dialect>", defaultValue="postgis") BGTDatabase.SQLDialectEnum dialectEnum, @CommandLine.Mixin FeatureTypeSelectionOptions featureTypeSelectionOptions, @CommandLine.Option(names={"--table-prefix"}, defaultValue="", hidden=true) String tablePrefix, @CommandLine.Option(names={"-h", "--help"}, usageHelp=true) boolean showHelp) throws SQLException {
        SQLDialect dialect = BGTDatabase.createDialect(dialectEnum);
        if (featureTypeSelectionOptions.featureTypes.contains("all") || featureTypeSelectionOptions.featureTypes.contains("bgt")) {
            featureTypeSelectionOptions.getFeatureTypes().add(DeltaCustomDownloadRequest.FeaturetypesEnum.PLAATSBEPALINGSPUNT.getValue());
        }
        Set tableNames = featureTypeSelectionOptions.getFeatureTypesList().stream().map(DeltaCustomDownloadRequest.FeaturetypesEnum::getValue).collect(Collectors.toSet());
        BGTSchemaMapper bgtSchemaMapper = BGTSchemaMapper.getInstance();
        bgtSchemaMapper.printSchema(dialect, tablePrefix, objectType -> tableNames.contains(bgtSchemaMapper.getTableNameForObjectType((ObjectType)objectType, "")));
        return 0;
    }

    @CommandLine.Command(name="load", sortOptions=false)
    public int load(@CommandLine.Mixin DatabaseOptions dbOptions, @CommandLine.Mixin LoadOptions loadOptions, @CommandLine.Mixin FeatureTypeSelectionOptions featureTypeSelectionOptions, @CommandLine.Parameters(paramLabel="<file>") String file, @CommandLine.Mixin CLIOptions cliOptions, @CommandLine.Option(names={"-h", "--help"}, usageHelp=true) boolean showHelp) throws Exception {
        log.info((Object)Utils.getUserAgent());
        try (BGTDatabase db = new BGTDatabase(dbOptions);){
            BGTObjectTableWriter writer = db.createObjectTableWriter(loadOptions, dbOptions);
            ProgressReporter progressReporter = cliOptions.isConsoleProgressEnabled() ? new ConsoleProgressReporter() : new ProgressReporter();
            writer.setProgressUpdater(progressReporter);
            if (loadOptions.createSchema) {
                db.createMetadataTable(loadOptions);
            }
            if (file.endsWith(".zip") && (file.startsWith("http://") || file.startsWith("https://"))) {
                this.loadZipFromURI(new URI(file), writer, featureTypeSelectionOptions, loadOptions, true);
            } else if (file.endsWith(".zip")) {
                this.loadZip(new File(file), writer, featureTypeSelectionOptions);
            } else if (file.matches(".*\\.[xg]ml")) {
                this.loadXml(new File(file), writer);
            } else {
                System.err.println(Utils.getMessageFormattedString("load.invalid_extension", file));
                int n = 2;
                return n;
            }
            if (writer.getProgress() == null) {
                System.err.println(Utils.getBundleString("error.no_feature_types"));
                int n = 1;
                return n;
            }
            db.setMetadataValue(BGTSchemaMapper.Metadata.LOADER_VERSION, Utils.getLoaderVersion());
            db.setFeatureTypesEnumMetadata(featureTypeSelectionOptions.getFeatureTypesList());
            db.setMetadataValue(BGTSchemaMapper.Metadata.INCLUDE_HISTORY, "" + loadOptions.includeHistory);
            db.setMetadataValue(BGTSchemaMapper.Metadata.LINEARIZE_CURVES, "" + loadOptions.linearizeCurves);
            db.setMetadataValue(BGTSchemaMapper.Metadata.TABLE_PREFIX, loadOptions.tablePrefix);
            BGTObjectTableWriter.BGTProgress progress = writer.getProgress();
            if (progress.getMutatieInhoud() != null) {
                db.setMetadataForMutaties(progress.getMutatieInhoud());
                db.setMetadataValue(BGTSchemaMapper.Metadata.GEOM_FILTER, progress.getMutatieInhoud().getGebied());
                log.info((Object)Utils.getMessageFormattedString("load.mutatie", progress.getMutatieInhoud().getMutatieType(), progress.getMutatieInhoud().getLeveringsId()));
            }
            progressReporter.reportTotalSummary();
            db.getConnection().commit();
        }
        return 0;
    }

    private static boolean isBGTZipEntrySelected(String entryName, FeatureTypeSelectionOptions featureTypeSelectionOptions, boolean logSkipAsInfo) {
        Set<DeltaCustomDownloadRequest.FeaturetypesEnum> featureTypes = featureTypeSelectionOptions.getFeatureTypesList();
        Pattern p = Pattern.compile("bgt_(.+).[xg]ml");
        Matcher m = p.matcher(entryName);
        if (!m.matches()) {
            log.warn((Object)Utils.getMessageFormattedString("load.skip_entry", entryName));
            return false;
        }
        String tableName = m.group(1);
        try {
            DeltaCustomDownloadRequest.FeaturetypesEnum featureType = DeltaCustomDownloadRequest.FeaturetypesEnum.fromValue(tableName);
            if (!featureTypes.contains((Object)featureType)) {
                String msg = Utils.getMessageFormattedString("load.skip_unselected", tableName);
                if (logSkipAsInfo) {
                    log.info((Object)msg);
                } else {
                    log.debug((Object)msg);
                }
                return false;
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)Utils.getMessageFormattedString("load.skip_unknown_feature_type", entryName));
            return false;
        }
    }

    public void loadZipFromURI(URI uri, BGTObjectTableWriter writer, FeatureTypeSelectionOptions featureTypeSelectionOptions, LoadOptions loadOptions, boolean showSelected) throws Exception {
        log.info((Object)Utils.getMessageFormattedString("download.downloading_from", uri));
        if (loadOptions.isHttpZipRandomAccess()) {
            this.loadZipFromURIUsingRandomAccess(uri, writer, featureTypeSelectionOptions, showSelected, loadOptions.isDebugHttpSeeks());
        } else {
            this.loadZipFromURIUsingStreaming(uri, writer, featureTypeSelectionOptions);
        }
    }

    public void loadZipFromURIUsingRandomAccess(URI uri, BGTObjectTableWriter writer, FeatureTypeSelectionOptions featureTypeSelectionOptions, boolean showSelected, boolean debugHttpSeeks) throws Exception {
        Instant start = Instant.now();
        try (HttpSeekableByteChannel channel = new HttpSeekableByteChannel(uri).withDebug(debugHttpSeeks);
             CountingSeekableByteChannel loggingChannel = new CountingSeekableByteChannel(channel);
             ZipFile zipFile = new ZipFile((SeekableByteChannel)loggingChannel, uri.toString(), "UTF8", false, true);){
            if (debugHttpSeeks) {
                System.out.println();
            }
            int count = 0;
            long uncompressed = 0L;
            Iterator it = zipFile.getEntries().asIterator();
            while (it.hasNext()) {
                ZipArchiveEntry entry2 = (ZipArchiveEntry)it.next();
                ++count;
                uncompressed += entry2.getSize();
            }
            log.info((Object)Utils.getMessageFormattedString("download.zip.read", Utils.formatTimeSince(start), count, FileUtils.byteCountToDisplaySize((long)channel.size()), FileUtils.byteCountToDisplaySize((long)uncompressed)));
            if (debugHttpSeeks) {
                log.info((Object)Utils.getMessageFormattedString("download.zip.debug-http-seeks.entries", loggingChannel.getNonConsecutiveIops(), channel.getHttpRequestCount(), channel.getBytesRead()));
            }
            loggingChannel.setLoggingEnabled(false);
            ProgressReporter progressReporter = (ProgressReporter)writer.getProgressUpdater();
            ArrayList selected = new ArrayList();
            zipFile.getEntries().asIterator().forEachRemaining(entry -> {
                if (BGTLoaderMain.isBGTZipEntrySelected(entry.getName(), featureTypeSelectionOptions, false)) {
                    selected.add(entry);
                }
            });
            if (selected.size() > 1) {
                Long totalSize = selected.stream().map(ZipArchiveEntry::getSize).reduce(0L, Long::sum);
                Long totalCompressedSize = selected.stream().map(ZipEntry::getCompressedSize).reduce(0L, Long::sum);
                progressReporter.setTotalBytes(totalSize);
                if (showSelected) {
                    log.info((Object)Utils.getMessageFormattedString("download.zip.selected", selected.size(), FileUtils.byteCountToDisplaySize((long)totalCompressedSize), FileUtils.byteCountToDisplaySize((long)totalSize)));
                }
            }
            Long[] previousEntriesBytesRead = new Long[]{0L};
            progressReporter.setTotalBytesReadFunction(() -> previousEntriesBytesRead[0] + writer.getProgress().getBytesRead());
            for (ZipArchiveEntry entry3 : selected) {
                progressReporter.startNewFile(entry3.getName(), entry3.getSize());
                writer.write(zipFile.getInputStream(entry3));
            }
            if (debugHttpSeeks) {
                log.info((Object)Utils.getMessageFormattedString("download.zip.debug-http-seeks.totals", loggingChannel.getNonConsecutiveIops(), channel.getHttpRequestCount(), channel.getBytesRead(), FileUtils.byteCountToDisplaySize((long)channel.getBytesRead())));
            }
        }
    }

    public void loadZipFromURIUsingStreaming(URI downloadURI, BGTObjectTableWriter writer, FeatureTypeSelectionOptions featureTypeSelectionOptions) throws Exception {
        ProgressReporter progressReporter = (ProgressReporter)writer.getProgressUpdater();
        try (ResumingBGTDownloadInputStream input = new ResumingBGTDownloadInputStream(downloadURI, writer);){
            CountingInputStream countingInputStream = new CountingInputStream((InputStream)input);
            progressReporter.setTotalBytesReadFunction(() -> ((CountingInputStream)countingInputStream).getByteCount());
            try (ZipInputStream zis = new ZipInputStream((InputStream)countingInputStream);){
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    if (BGTLoaderMain.isBGTZipEntrySelected(entry.getName(), featureTypeSelectionOptions, true)) {
                        progressReporter.startNewFile(entry.getName(), null);
                        writer.write((InputStream)CloseShieldInputStream.wrap((InputStream)zis));
                    }
                    entry = zis.getNextEntry();
                }
            }
        }
    }

    public void loadZip(File file, BGTObjectTableWriter writer, FeatureTypeSelectionOptions featureTypeSelectionOptions) throws Exception {
        try (java.util.zip.ZipFile zipFile = new java.util.zip.ZipFile(file);){
            List entries = zipFile.stream().filter(entry -> BGTLoaderMain.isBGTZipEntrySelected(entry.getName(), featureTypeSelectionOptions, false)).collect(Collectors.toList());
            ProgressReporter progressReporter = (ProgressReporter)writer.getProgressUpdater();
            if (entries.size() > 1) {
                Long totalSize = entries.stream().map(ZipEntry::getSize).reduce(0L, Long::sum);
                progressReporter.setTotalBytes(totalSize);
            }
            Long[] previousEntriesBytesRead = new Long[]{0L};
            progressReporter.setTotalBytesReadFunction(() -> previousEntriesBytesRead[0] + writer.getProgress().getBytesRead());
            for (ZipEntry entry2 : entries) {
                InputStream in = zipFile.getInputStream(entry2);
                try {
                    this.loadInputStream(entry2.getName(), in, entry2.getSize(), writer);
                    Long[] longArray = previousEntriesBytesRead;
                    Long.valueOf(longArray[0] + entry2.getSize());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            progressReporter.reportTotalSummary();
        }
    }

    public void loadXml(File file, BGTObjectTableWriter writer) throws Exception {
        try (FileInputStream in = new FileInputStream(file);){
            this.loadInputStream(file.getName(), in, file.length(), writer);
        }
    }

    public void loadInputStream(String name, InputStream input, long size, BGTObjectTableWriter writer) throws Exception {
        ProgressReporter progressReporter = (ProgressReporter)writer.getProgressUpdater();
        progressReporter.startNewFile(name, size);
        writer.write(input);
    }

    public String[] getVersion() {
        return new String[]{Utils.getLoaderVersion(), Utils.getUserAgent()};
    }
}

