/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.loader.cli;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import nl.b3p.brmo.bgt.download.api.CustomDownloadProgress;
import nl.b3p.brmo.bgt.download.model.DeltaCustomDownloadStatusResponse;
import nl.b3p.brmo.bgt.loader.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CustomDownloadProgressReporter
implements Consumer<CustomDownloadProgress> {
    private static final Log log = LogFactory.getLog(CustomDownloadProgressReporter.class);
    private final boolean printProgress;
    private DeltaCustomDownloadStatusResponse.StatusEnum lastStatus;
    private Instant lastProgress = null;

    public CustomDownloadProgressReporter(boolean printProgress) {
        this.printProgress = printProgress;
    }

    @Override
    public void accept(CustomDownloadProgress progress) {
        if (progress.getStatusApiCalls() == 0 && progress.getDownloadRequestId() != null) {
            log.debug((Object)Utils.getMessageFormattedString("download.request_id", progress.getDownloadRequestId()));
            log.info((Object)Utils.getBundleString("download.requesting_status"));
        } else {
            DeltaCustomDownloadStatusResponse.StatusEnum status = progress.getStatusResponse().getStatus();
            if (!this.printProgress) {
                if (this.lastStatus != status) {
                    log.info((Object)Utils.getMessageFormattedString("download.extract_status", new Object[]{status}));
                }
                if (status == DeltaCustomDownloadStatusResponse.StatusEnum.RUNNING) {
                    if (this.lastProgress == null) {
                        this.lastProgress = Instant.now();
                    } else if (Duration.between(this.lastProgress, Instant.now()).getSeconds() > 300L) {
                        log.info((Object)Utils.getMessageFormattedString("download.extract_status", String.format("%s (%2d%%)", new Object[]{status, progress.getStatusResponse().getProgress()})));
                        this.lastProgress = Instant.now();
                    }
                }
            } else if (status == DeltaCustomDownloadStatusResponse.StatusEnum.PENDING) {
                System.out.print("\r" + Utils.getMessageFormattedString("download.extract_pending", progress.getTimeSinceStart()));
            } else if (status == DeltaCustomDownloadStatusResponse.StatusEnum.RUNNING) {
                System.out.print("\r" + Utils.getMessageFormattedString("download.extract_running", String.format("%3d", progress.getStatusResponse().getProgress()), progress.getTimeSinceStart()));
            } else if (status == DeltaCustomDownloadStatusResponse.StatusEnum.COMPLETED) {
                log.debug((Object)Utils.getMessageFormattedString("download.extract_ready", progress.getTimeSinceStart()));
                System.out.printf("\r%s\r", " ".repeat(30));
            }
            this.lastStatus = status;
        }
    }
}

