/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.loader;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Set;
import java.util.stream.Collectors;
import nl.b3p.brmo.bgt.download.model.DeltaCustomDownloadRequest;
import nl.b3p.brmo.bgt.loader.BGTObjectStreamer;
import nl.b3p.brmo.bgt.loader.Utils;
import nl.b3p.brmo.bgt.loader.cli.DatabaseOptions;
import nl.b3p.brmo.bgt.loader.cli.LoadOptions;
import nl.b3p.brmo.bgt.schema.BGTObjectTableWriter;
import nl.b3p.brmo.bgt.schema.BGTSchemaMapper;
import nl.b3p.brmo.sql.LoggingQueryRunner;
import nl.b3p.brmo.sql.dialect.MSSQLDialect;
import nl.b3p.brmo.sql.dialect.OracleDialect;
import nl.b3p.brmo.sql.dialect.PostGISDialect;
import nl.b3p.brmo.sql.dialect.SQLDialect;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BGTDatabase
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(BGTDatabase.class);
    private SQLDialect dialect;
    private final DatabaseOptions dbOptions;
    private Connection connection;
    private final boolean allowConnectionCreation;

    public BGTDatabase(DatabaseOptions dbOptions) throws ClassNotFoundException {
        this.dbOptions = dbOptions;
        this.dialect = BGTDatabase.createDialect(dbOptions.getConnectionString());
        this.dialect.loadDriver();
        this.allowConnectionCreation = true;
    }

    public BGTDatabase(DatabaseOptions dbOptions, Connection connection) throws SQLException {
        this.dbOptions = dbOptions;
        this.dialect = BGTDatabase.createDialect(connection.getMetaData().getURL());
        this.connection = connection;
        this.allowConnectionCreation = false;
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.createConnection();
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setDialect(SQLDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    private Connection createConnection() {
        if (!this.allowConnectionCreation) {
            throw new RuntimeException("New connection required but supplied connection is null or closed");
        }
        try {
            return DriverManager.getConnection(this.dbOptions.getConnectionString(), this.dbOptions.getUser(), this.dbOptions.getPassword());
        }
        catch (SQLException e) {
            throw new RuntimeException(Utils.getMessageFormattedString("db.connection_error", this.dbOptions.getConnectionString()), e);
        }
    }

    public BGTObjectTableWriter createObjectTableWriter(LoadOptions loadOptions, DatabaseOptions dbOptions) throws SQLException {
        BGTObjectTableWriter writer = new BGTObjectTableWriter(this.getConnection(), this.getDialect(), BGTSchemaMapper.getInstance());
        if (loadOptions == null) {
            loadOptions = new LoadOptions();
        }
        writer.setBatchSize(dbOptions.getBatchSize() != null ? dbOptions.getBatchSize().intValue() : this.getDialect().getDefaultOptimalBatchSize());
        writer.setMultithreading(loadOptions.isMultithreading());
        writer.setUsePgCopy(dbOptions.isUsePgCopy());
        writer.setObjectLimit(loadOptions.getMaxObjects());
        writer.setLinearizeCurves(loadOptions.isLinearizeCurves());
        writer.setCurrentObjectsOnly(!loadOptions.isIncludeHistory());
        writer.setCreateSchema(loadOptions.isCreateSchema());
        writer.setDropIfExists(loadOptions.isDropIfExists());
        writer.setTablePrefix(loadOptions.getTablePrefix());
        return writer;
    }

    public static SQLDialect createDialect(String connectionString) {
        SQLDialectEnum sqlDialectEnum;
        if (connectionString.startsWith("jdbc:postgresql:")) {
            sqlDialectEnum = SQLDialectEnum.postgis;
        } else if (connectionString.startsWith("jdbc:oracle:thin:")) {
            sqlDialectEnum = SQLDialectEnum.oracle;
        } else if (connectionString.startsWith("jdbc:sqlserver:")) {
            sqlDialectEnum = SQLDialectEnum.mssql;
        } else {
            throw new IllegalArgumentException(Utils.getMessageFormattedString("db.unknown_connection_string_dialect", connectionString));
        }
        return BGTDatabase.createDialect(sqlDialectEnum);
    }

    public static SQLDialect createDialect(SQLDialectEnum dialectEnum) {
        switch (dialectEnum) {
            case postgis: {
                return new PostGISDialect();
            }
            case oracle: {
                return new OracleDialect();
            }
            case mssql: {
                return new MSSQLDialect();
            }
        }
        throw new IllegalArgumentException(Utils.getMessageFormattedString("db.dialect_invalid", new Object[]{dialectEnum}));
    }

    public void createMetadataTable(LoadOptions loadOptions) throws SQLException {
        log.info((Object)Utils.getBundleString("db.create_metadata"));
        for (String sql : BGTSchemaMapper.getInstance().getCreateMetadataTableStatements(this.getDialect(), loadOptions.getTablePrefix(), loadOptions.isDropIfExists())) {
            new LoggingQueryRunner().update(this.getConnection(), sql);
        }
    }

    public String getMetadata(BGTSchemaMapper.Metadata key) throws SQLException {
        Object value = new LoggingQueryRunner().query(this.getConnection(), "select waarde from brmo_metadata where naam = ?", new ScalarHandler(), new Object[]{key.getDbKey()});
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return clob.getSubString(1L, (int)clob.length());
        }
        return value.toString();
    }

    public void setMetadataValue(BGTSchemaMapper.Metadata key, String value) throws Exception {
        try {
            int updated = new LoggingQueryRunner().update(this.getConnection(), "update brmo_metadata set waarde = ? where naam = ?", value, key.getDbKey());
            if (updated == 0) {
                new LoggingQueryRunner().update(this.getConnection(), "insert into brmo_metadata(naam, waarde) values(?,?)", key.getDbKey(), value);
            }
        }
        catch (SQLException e) {
            throw new Exception(Utils.getMessageFormattedString("db.metadata_error", key.getDbKey(), value, e.getMessage()), e);
        }
    }

    public void setMetadataForMutaties(BGTObjectStreamer.MutatieInhoud mutatieInhoud) throws Exception {
        this.setMetadataValue(BGTSchemaMapper.Metadata.DELTA_TIME_TO, null);
        if (mutatieInhoud == null || mutatieInhoud.getLeveringsId() == null) {
            this.setMetadataValue(BGTSchemaMapper.Metadata.INITIAL_LOAD_DELTA_ID, null);
            this.setMetadataValue(BGTSchemaMapper.Metadata.INITIAL_LOAD_TIME, null);
            this.setMetadataValue(BGTSchemaMapper.Metadata.DELTA_ID, null);
        } else {
            String deltaId = mutatieInhoud.getLeveringsId();
            if ("initial".equals(mutatieInhoud.getMutatieType())) {
                this.setMetadataValue(BGTSchemaMapper.Metadata.INITIAL_LOAD_DELTA_ID, deltaId);
                this.setMetadataValue(BGTSchemaMapper.Metadata.INITIAL_LOAD_TIME, Instant.now().toString());
            }
            this.setMetadataValue(BGTSchemaMapper.Metadata.DELTA_ID, deltaId);
        }
    }

    public void setFeatureTypesEnumMetadata(Set<DeltaCustomDownloadRequest.FeaturetypesEnum> featureTypes) throws Exception {
        this.setMetadataValue(BGTSchemaMapper.Metadata.FEATURE_TYPES, featureTypes.stream().map(DeltaCustomDownloadRequest.FeaturetypesEnum::toString).collect(Collectors.joining(",")));
    }

    public static enum SQLDialectEnum {
        postgis,
        oracle,
        mssql;

    }
}

