/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.sql.dialect;

import com.microsoft.sqlserver.jdbc.Geometry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import nl.b3p.brmo.sql.dialect.SQLDialect;
import nl.b3p.brmo.util.StandardLinearizedWKTWriter;
import org.geotools.geometry.jts.MultiSurface;
import org.geotools.geometry.jts.WKTWriter2;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

public class MSSQLDialect
implements SQLDialect {
    private final StandardLinearizedWKTWriter wktWriter = new StandardLinearizedWKTWriter();
    private final WKTWriter2 wktWriter2 = new WKTWriter2();

    @Override
    public String getDriverClass() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public String getType(String type) {
        if (type.startsWith("varchar")) {
            return "n" + type;
        }
        if (type.equals("timestamp")) {
            return "datetime2";
        }
        if (type.equals("boolean")) {
            return "bit";
        }
        if (type.startsWith("geometry(")) {
            return "geometry";
        }
        if (type.equals("text")) {
            return "ntext";
        }
        return type;
    }

    @Override
    public Object getGeometryParameter(Connection c, org.locationtech.jts.geom.Geometry geometry, boolean linearizeCurves) throws SQLException {
        String wkt;
        if (linearizeCurves) {
            wkt = this.wktWriter.write(geometry);
        } else if (geometry instanceof MultiSurface) {
            MultiSurface multiSurface = (MultiSurface)geometry;
            if (multiSurface.getNumGeometries() == 1) {
                wkt = this.wktWriter2.write(multiSurface.getGeometryN(0));
            } else {
                GeometryFactory geometryFactory = new GeometryFactory();
                org.locationtech.jts.geom.Geometry[] geometries = new org.locationtech.jts.geom.Geometry[multiSurface.getNumGeometries()];
                for (int i = 0; i < multiSurface.getNumGeometries(); ++i) {
                    geometries[i] = multiSurface.getGeometryN(i);
                }
                GeometryCollection collection = geometryFactory.createGeometryCollection(geometries);
                wkt = this.wktWriter2.write((org.locationtech.jts.geom.Geometry)collection);
            }
        } else {
            wkt = this.wktWriter2.write(geometry);
        }
        try {
            return Geometry.STGeomFromText((String)wkt, (int)geometry.getSRID());
        }
        catch (SQLException e) {
            throw new SQLException("Error converting geometry to MSSQL geometry for WKT: " + wkt, e);
        }
    }

    @Override
    public void setGeometryParameter(Connection c, PreparedStatement ps, int parameterIndex, int pmdType, org.locationtech.jts.geom.Geometry geometry, boolean linearizeCurves) throws SQLException {
        if (geometry == null) {
            ps.setNull(parameterIndex, 1111);
        } else {
            ps.setObject(parameterIndex, this.getGeometryParameter(c, geometry, linearizeCurves));
        }
    }

    @Override
    public String getCreateGeometryIndexSQL(String tableName, String geometryColumn, String type) {
        return String.format("create spatial index idx_%s_%s on %s (%s) with (bounding_box = (12000,304000,280000,620000))", tableName, geometryColumn, tableName, geometryColumn);
    }

    @Override
    public int getDefaultOptimalBatchSize() {
        return 250;
    }

    @Override
    public boolean supportsDropTableIfExists() {
        return false;
    }
}

