/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.loader.cli;

import java.time.Instant;
import nl.b3p.brmo.bgt.loader.ProgressReporter;
import nl.b3p.brmo.bgt.loader.Utils;
import nl.b3p.brmo.bgt.schema.BGTObjectTableWriter;
import nl.b3p.brmo.schema.ObjectTableWriter;

public class ConsoleProgressReporter
extends ProgressReporter {
    Instant totalStart = Instant.now();

    @Override
    protected void log(String msg) {
        System.out.print("\r" + msg);
    }

    @Override
    protected void status(String msg) {
        System.out.print("\r" + msg + " ".repeat(40));
    }

    @Override
    public void reportTotalSummary() {
        super.reportTotalSummary();
        System.out.println();
    }

    @Override
    public void accept(ObjectTableWriter.Progress genericProgress) {
        super.accept(genericProgress);
        BGTObjectTableWriter.BGTProgress progress = (BGTObjectTableWriter.BGTProgress)genericProgress;
        if (progress.getStage() == ObjectTableWriter.Stage.FINISHED) {
            System.out.println();
        } else if (progress.getStage() == ObjectTableWriter.Stage.LOAD_OBJECTS) {
            String total = "";
            if (this.getTotalBytes() != null) {
                total = String.format(" - %s %4.1f%%   %s", Utils.getBundleString("progress.total"), 100.0 / (double)this.getTotalBytes().longValue() * (double)this.getTotalBytesReadFunction().get().longValue(), Utils.formatTimeSince(this.totalStart));
            }
            String current = this.getCurrentFileSize() != null ? String.format("%4.1f%% ", 100.0 / (double)this.getCurrentFileSize().longValue() * (double)progress.getBytesRead()) : String.format("%,6d MB", progress.getBytesRead() / 1024L / 1024L);
            System.out.printf("\r%s: %s  %s, %,10d %s%s", this.getCurrentFileName(), current, Utils.formatTimeSince(this.getCurrentFileStart()), progress.getObjectCount(), Utils.getBundleString("progress.objects"), total);
        }
    }
}

