/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.loader.cli;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.b3p.brmo.bgt.download.model.DeltaCustomDownloadRequest;
import nl.b3p.brmo.bgt.schema.BGTSchema;
import nl.b3p.brmo.bgt.schema.BGTSchemaMapper;
import nl.b3p.brmo.schema.ObjectType;
import picocli.CommandLine;

public class FeatureTypeSelectionOptions {
    @CommandLine.Option(names={"--feature-types"}, split=",", defaultValue="all", paramLabel="<name>")
    List<String> featureTypes;

    public List<String> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(List<String> featureTypes) {
        this.featureTypes = featureTypes;
    }

    public Set<DeltaCustomDownloadRequest.FeaturetypesEnum> getFeatureTypesList() {
        HashSet<DeltaCustomDownloadRequest.FeaturetypesEnum> types = new HashSet<DeltaCustomDownloadRequest.FeaturetypesEnum>();
        if (this.featureTypes.contains("all")) {
            types.addAll(Arrays.asList(DeltaCustomDownloadRequest.FeaturetypesEnum.values()));
        } else {
            BGTSchema bgtSchema = BGTSchema.getInstance();
            BGTSchemaMapper bgtSchemaMapper = BGTSchemaMapper.getInstance();
            if (this.featureTypes.contains("bgt")) {
                types.addAll(BGTSchema.getInstance().getOnlyBGTObjectTypes().map(objectType -> {
                    try {
                        return DeltaCustomDownloadRequest.FeaturetypesEnum.fromValue(bgtSchemaMapper.getTableNameForObjectType((ObjectType)objectType, ""));
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toSet()));
            }
            if (this.featureTypes.contains("plus")) {
                types.addAll(bgtSchema.getIMGeoPlusObjectTypes().map(objectType -> DeltaCustomDownloadRequest.FeaturetypesEnum.fromValue(bgtSchemaMapper.getTableNameForObjectType((ObjectType)objectType, ""))).collect(Collectors.toSet()));
            }
        }
        types.remove((Object)DeltaCustomDownloadRequest.FeaturetypesEnum.PLAATSBEPALINGSPUNT);
        for (String featureType : this.featureTypes) {
            if (!Stream.of("all", "bgt", "plus").noneMatch(t -> t.equals(featureType))) continue;
            try {
                types.add(DeltaCustomDownloadRequest.FeaturetypesEnum.fromValue(featureType));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid feature type: \"%s\"", featureType));
            }
        }
        return types;
    }
}

